/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.JavaComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodDialog
extends RefactoringDialog
implements AbstractExtractDialog {
    static final String EXTRACT_METHOD_DEFAULT_VISIBILITY = "extract.method.default.visibility";
    static final String EXTRACT_METHOD_GENERATE_ANNOTATIONS = "extractMethod.generateAnnotations";
    private final Project myProject;
    private final PsiType myReturnType;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiType[] myExceptions;
    private final boolean myStaticFlag;
    private final boolean myCanBeStatic;
    @Nullable
    private final Nullability myNullability;
    private final PsiElement[] myElementsToExtract;
    private final String myHelpId;
    private final NameSuggestionsField myNameField;
    private final MethodSignatureComponent mySignature;
    private final JCheckBox myMakeStatic;
    protected JCheckBox myMakeVarargs;
    protected JCheckBox myGenerateAnnotations;
    private JCheckBox myCbChainedConstructor;
    private final InputVariables myVariableData;
    private final PsiClass myTargetClass;
    private ComboBoxVisibilityPanel<String> myVisibilityPanel;
    private boolean myDefaultVisibility = true;
    private boolean myChangingVisibility;
    private final JCheckBox myFoldParameters = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.folded.parameters"));
    public JPanel myCenterPanel;
    public JPanel myParamTable;
    private VariableData[] myInputVariables;
    private TypeSelector mySelector;
    private final Supplier<Integer> myDuplicatesCountSupplier;

    public ExtractMethodDialog(Project project, PsiClass targetClass, InputVariables inputVariables, PsiType returnType, PsiTypeParameterList typeParameterList, PsiType[] exceptions, boolean isStatic, boolean canBeStatic, boolean canBeChainedConstructor, String title, String helpId, @Nullable Nullability nullability, PsiElement[] elementsToExtract, @Nullable Supplier<Integer> duplicatesCountSupplier) {
        super(project, true);
        this.myProject = project;
        this.myTargetClass = targetClass;
        this.myReturnType = returnType;
        this.myTypeParameterList = typeParameterList;
        this.myExceptions = exceptions;
        this.myStaticFlag = isStatic;
        this.myCanBeStatic = canBeStatic;
        this.myNullability = nullability;
        this.myElementsToExtract = elementsToExtract;
        this.myVariableData = inputVariables;
        this.myHelpId = helpId;
        this.mySignature = new MethodSignatureComponent("", project, (FileType)JavaFileType.INSTANCE);
        this.mySignature.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
        this.mySignature.setMinimumSize((Dimension)JBUI.size((int)500, (int)100));
        this.setTitle(title);
        this.myNameField = new NameSuggestionsField(this.suggestMethodNames(), this.myProject);
        this.myMakeStatic = new NonFocusableCheckBox();
        this.myMakeStatic.setText(RefactoringBundle.message((String)"declare.static.checkbox"));
        if (canBeChainedConstructor) {
            this.myCbChainedConstructor = new NonFocusableCheckBox(RefactoringBundle.message((String)"extract.chained.constructor.checkbox"));
        }
        this.myInputVariables = this.myVariableData.getInputVariables().toArray(new VariableData[0]);
        this.myDuplicatesCountSupplier = duplicatesCountSupplier;
        this.setPreviewResults(duplicatesCountSupplier != null);
        this.init();
    }

    protected String[] suggestMethodNames() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected boolean areTypesDirected() {
        return true;
    }

    @Override
    public boolean isMakeStatic() {
        return this.myStaticFlag || this.myCanBeStatic && this.myMakeStatic.isSelected();
    }

    @Override
    public boolean isChainedConstructor() {
        return this.myCbChainedConstructor != null && this.myCbChainedConstructor.isSelected();
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    protected boolean hasHelpAction() {
        return this.getHelpId() != null;
    }

    @Override
    @NotNull
    public String getChosenMethodName() {
        String string = this.myNameField.getEnteredName().trim();
        if (string == null) {
            ExtractMethodDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public VariableData[] getChosenParameters() {
        return this.myInputVariables;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    protected void doAction() {
        PsiMethod containingMethod;
        ConflictsDialog conflictsDialog;
        MultiMap conflicts = new MultiMap();
        this.checkMethodConflicts((MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty() && !(conflictsDialog = new ConflictsDialog(this.myProject, conflicts)).showAndGet()) {
            if (conflictsDialog.isShowConflicts()) {
                this.close(1);
            }
            return;
        }
        if (this.myMakeVarargs != null && this.myMakeVarargs.isSelected()) {
            VariableData data = this.myInputVariables[this.myInputVariables.length - 1];
            if (data.type instanceof PsiArrayType) {
                data.type = new PsiEllipsisType(((PsiArrayType)data.type).getComponentType());
            }
        }
        if ((containingMethod = this.getContainingMethod()) != null && containingMethod.hasModifierProperty("public")) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(EXTRACT_METHOD_DEFAULT_VISIBILITY, this.getVisibility());
        }
        if (this.myGenerateAnnotations != null && this.myGenerateAnnotations.isEnabled()) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(EXTRACT_METHOD_GENERATE_ANNOTATIONS, this.myGenerateAnnotations.isSelected(), true);
        }
        this.close(0);
    }

    protected JComponent createNorthPanel() {
        JPanel returnTypePanel;
        JPanel main = new JPanel(new BorderLayout());
        JPanel namePanel = new JPanel(new BorderLayout(0, 2));
        JLabel nameLabel = new JLabel();
        nameLabel.setText(RefactoringBundle.message((String)"changeSignature.name.prompt"));
        namePanel.add((Component)nameLabel, "North");
        namePanel.add((Component)this.myNameField, "South");
        nameLabel.setLabelFor((Component)this.myNameField);
        this.myNameField.addDataChangedListener(this::update);
        this.myVisibilityPanel = this.createVisibilityPanel();
        if (!this.myNameField.hasSuggestions()) {
            this.myVisibilityPanel.registerUpDownActionsFor((JComponent)this.myNameField);
        }
        JPanel visibilityAndReturnType = new JPanel(new BorderLayout(2, 0));
        if (!this.myTargetClass.isInterface()) {
            visibilityAndReturnType.add((Component)this.myVisibilityPanel, "West");
        }
        if ((returnTypePanel = this.createReturnTypePanel()) != null) {
            visibilityAndReturnType.add((Component)returnTypePanel, "East");
        }
        JPanel visibilityAndName = new JPanel(new BorderLayout(2, 0));
        visibilityAndName.add((Component)visibilityAndReturnType, "West");
        visibilityAndName.add((Component)namePanel, "Center");
        main.add((Component)visibilityAndName, "Center");
        this.setOKActionEnabled(false);
        this.setActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.myNameField.getEnteredName()));
        JPanel options = new JPanel(new BorderLayout());
        options.add((Component)this.createOptionsPanel(), "West");
        main.add((Component)options, "South");
        return main;
    }

    private void setActionEnabled(boolean enabled) {
        this.setOKActionEnabled(enabled);
        this.getRefactorAction().setEnabled(enabled);
        this.getPreviewAction().setEnabled(enabled);
    }

    protected boolean isVoidReturn() {
        return false;
    }

    @Nullable
    private JPanel createReturnTypePanel() {
        if (TypeConversionUtil.isPrimitiveWrapper((PsiType)this.myReturnType) && this.myNullability == Nullability.NULLABLE) {
            return null;
        }
        TypeSelectorManagerImpl manager = new TypeSelectorManagerImpl(this.myProject, this.myReturnType, this.findOccurrences(), this.areTypesDirected()){

            @Override
            public PsiType[] getTypesForAll(boolean direct) {
                Object[] types = super.getTypesForAll(direct);
                return !ExtractMethodDialog.this.isVoidReturn() ? types : (PsiType[])ArrayUtil.prepend((Object)PsiType.VOID, (Object[])types);
            }
        };
        this.mySelector = manager.getTypeSelector();
        JComponent component = this.mySelector.getComponent();
        if (component instanceof ComboBox) {
            if (this.isVoidReturn()) {
                this.mySelector.selectType((PsiType)PsiType.VOID);
            }
            JPanel returnTypePanel = new JPanel(new BorderLayout(2, 0));
            JLabel label = new JLabel(RefactoringBundle.message((String)"changeSignature.return.type.prompt"));
            returnTypePanel.add((Component)label, "North");
            returnTypePanel.add((Component)component, "South");
            DialogUtil.registerMnemonic((JLabel)label, (JComponent)component);
            ((JComboBox)component).addActionListener(e -> {
                PsiType selectedType = this.mySelector.getSelectedType();
                if (this.myGenerateAnnotations != null) {
                    boolean enabled;
                    boolean bl = enabled = PsiUtil.resolveClassInType((PsiType)selectedType) != null;
                    if (!enabled) {
                        this.myGenerateAnnotations.setSelected(false);
                    }
                    this.myGenerateAnnotations.setEnabled(enabled);
                }
                ExtractMethodDialog.resizeReturnCombo(component, selectedType);
                returnTypePanel.revalidate();
                returnTypePanel.repaint();
                this.updateSignature();
            });
            ExtractMethodDialog.resizeReturnCombo(component, this.mySelector.getSelectedType());
            return returnTypePanel;
        }
        return null;
    }

    private static void resizeReturnCombo(JComponent component, PsiType selectedType) {
        if (selectedType != null) {
            String presentableText = selectedType.getPresentableText();
            int presentableTextWidth = component.getFontMetrics(component.getFont()).stringWidth(presentableText);
            ((ComboBox)component).setMinimumAndPreferredWidth(presentableTextWidth);
        }
    }

    protected PsiExpression[] findOccurrences() {
        return PsiExpression.EMPTY_ARRAY;
    }

    protected JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new FlowLayout(0, 0, 5));
        this.createStaticOptions(optionsPanel, RefactoringBundle.message((String)"declare.static.pass.fields.checkbox"));
        this.myFoldParameters.setSelected(this.myVariableData.isFoldingSelectedByDefault());
        this.myFoldParameters.setVisible(this.myVariableData.isFoldable());
        this.myVariableData.setFoldingAvailable(this.myFoldParameters.isSelected());
        this.myInputVariables = this.myVariableData.getInputVariables().toArray(new VariableData[0]);
        this.myFoldParameters.addActionListener(e -> {
            this.myVariableData.setFoldingAvailable(this.myFoldParameters.isSelected());
            this.myInputVariables = this.myVariableData.getInputVariables().toArray(new VariableData[0]);
            this.updateVarargsEnabled();
            this.createParametersPanel();
            this.updateSignature();
        });
        optionsPanel.add(this.myFoldParameters);
        JBEmptyBorder emptyBorder = JBUI.Borders.empty((int)5, (int)0, (int)5, (int)4);
        this.myFoldParameters.setBorder((Border)emptyBorder);
        boolean canBeVarargs = false;
        for (VariableData data : this.myInputVariables) {
            canBeVarargs |= data.type instanceof PsiArrayType;
        }
        if (this.myVariableData.isFoldable()) {
            canBeVarargs |= this.myVariableData.isFoldingSelectedByDefault();
        }
        if (canBeVarargs) {
            this.myMakeVarargs = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.varargs.checkbox"));
            this.myMakeVarargs.setBorder((Border)emptyBorder);
            this.updateVarargsEnabled();
            this.myMakeVarargs.addItemListener(e -> this.updateSignature());
            this.myMakeVarargs.setSelected(false);
            optionsPanel.add(this.myMakeVarargs);
        }
        if (this.myNullability != null && this.myNullability != Nullability.UNKNOWN) {
            boolean isSelected = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(EXTRACT_METHOD_GENERATE_ANNOTATIONS, true);
            this.myGenerateAnnotations = new JCheckBox(RefactoringBundle.message((String)"declare.generated.annotations"), isSelected);
            this.myGenerateAnnotations.addItemListener(e -> this.updateSignature());
            optionsPanel.add(this.myGenerateAnnotations);
        }
        if (this.myCbChainedConstructor != null) {
            optionsPanel.add(this.myCbChainedConstructor);
            this.myCbChainedConstructor.setBorder((Border)emptyBorder);
            this.myCbChainedConstructor.addItemListener(e -> {
                if (this.myDefaultVisibility) {
                    this.myChangingVisibility = true;
                    try {
                        if (this.isChainedConstructor()) {
                            this.myVisibilityPanel.setVisibility((Object)VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myTargetClass.getModifierList()));
                        } else {
                            this.myVisibilityPanel.setVisibility((Object)"private");
                        }
                    }
                    finally {
                        this.myChangingVisibility = false;
                    }
                }
                this.update();
            });
        }
        return optionsPanel;
    }

    protected void createStaticOptions(JPanel optionsPanel, String passFieldsAsParamsLabel) {
        if (this.myStaticFlag || this.myCanBeStatic) {
            this.myMakeStatic.setEnabled(!this.myStaticFlag);
            this.myMakeStatic.setSelected(this.myStaticFlag);
            if (this.myVariableData.hasInstanceFields()) {
                this.myMakeStatic.setText(passFieldsAsParamsLabel);
            }
            this.myMakeStatic.addItemListener(e -> {
                if (this.myVariableData.hasInstanceFields()) {
                    this.myVariableData.setPassFields(this.myMakeStatic.isSelected());
                    this.myInputVariables = this.myVariableData.getInputVariables().toArray(new VariableData[0]);
                    this.updateVarargsEnabled();
                    this.createParametersPanel();
                }
                this.updateSignature();
            });
            optionsPanel.add(this.myMakeStatic);
        } else {
            this.myMakeStatic.setSelected(false);
            this.myMakeStatic.setEnabled(false);
        }
        this.myMakeStatic.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)4));
    }

    private ComboBoxVisibilityPanel<String> createVisibilityPanel() {
        JavaComboBoxVisibilityPanel panel = new JavaComboBoxVisibilityPanel();
        PsiMethod containingMethod = this.getContainingMethod();
        panel.setVisibility(containingMethod != null && containingMethod.hasModifierProperty("public") ? PropertiesComponent.getInstance((Project)this.myProject).getValue(EXTRACT_METHOD_DEFAULT_VISIBILITY, "private") : "private");
        panel.addListener(e -> {
            this.updateSignature();
            if (!this.myChangingVisibility) {
                this.myDefaultVisibility = false;
            }
        });
        return panel;
    }

    private PsiMethod getContainingMethod() {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.findCommonParent((PsiElement[])this.myElementsToExtract), PsiMethod.class);
    }

    private void updateVarargsEnabled() {
        if (this.myMakeVarargs != null) {
            this.myMakeVarargs.setEnabled(this.myInputVariables[this.myInputVariables.length - 1].type instanceof PsiArrayType);
        }
    }

    private void update() {
        this.myNameField.setEnabled(!this.isChainedConstructor());
        if (this.myMakeStatic != null) {
            this.myMakeStatic.setEnabled(!this.myStaticFlag && this.myCanBeStatic && !this.isChainedConstructor());
        }
        this.updateSignature();
        this.setActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.myNameField.getEnteredName()) || this.isChainedConstructor());
    }

    @Override
    @NotNull
    public String getVisibility() {
        String string = this.myTargetClass.isInterface() || this.myVisibilityPanel == null ? "public" : (String)ObjectUtils.notNull((Object)this.myVisibilityPanel.getVisibility(), (Object)"public");
        if (string == null) {
            ExtractMethodDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.createParametersPanel();
        Splitter splitter = new Splitter(true);
        splitter.setShowDividerIcon(false);
        splitter.setFirstComponent((JComponent)this.myCenterPanel);
        JPanel secondPanel = new JPanel(new BorderLayout(0, 5));
        secondPanel.add((Component)this.createSignaturePanel(), "Center");
        if (this.hasPreviewButton()) {
            JBLabel duplicatesCount = this.createDuplicatesCountLabel();
            secondPanel.add((Component)duplicatesCount, "South");
        }
        splitter.setSecondComponent((JComponent)secondPanel);
        return splitter;
    }

    @NotNull
    private JBLabel createDuplicatesCountLabel() {
        final JBLabel duplicatesCount = new JBLabel();
        if (this.myDuplicatesCountSupplier != null) {
            duplicatesCount.setText(RefactoringBundle.message((String)"refactoring.extract.method.dialog.duplicates.pending"));
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, RefactoringBundle.message((String)"refactoring.extract.method.dialog.duplicates.progress")){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    int count = (Integer)ReadAction.compute(((Supplier)ExtractMethodDialog.this.myDuplicatesCountSupplier)::get);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (count != 0) {
                            this.showCount(UIUtil.getBalloonInformationIcon(), " " + RefactoringBundle.message((String)"refactoring.extract.method.dialog.duplicates.count", (Object[])new Object[]{count}), (Border)JBUI.Borders.empty((int)18, (int)0));
                        } else {
                            this.showCount(null, "", null);
                        }
                    }, ModalityState.any());
                }

                private void showCount(Icon icon, String message2, Border border) {
                    duplicatesCount.setIcon(icon);
                    duplicatesCount.setText(message2);
                    duplicatesCount.setBorder(border);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/extractMethod/ExtractMethodDialog$2", "run"));
                }
            });
        }
        JBLabel jBLabel = duplicatesCount;
        if (jBLabel == null) {
            ExtractMethodDialog.$$$reportNull$$$0(2);
        }
        return jBLabel;
    }

    protected boolean isOutputVariable(PsiVariable var) {
        return false;
    }

    protected void createParametersPanel() {
        if (this.myParamTable != null) {
            this.myCenterPanel.remove(this.myParamTable);
        }
        this.myParamTable = this.createParameterTableComponent();
        this.myParamTable.setMinimumSize((Dimension)JBUI.size((int)500, (int)100));
        this.myCenterPanel.add((Component)this.myParamTable, "Center");
        final JTable table = (JTable)UIUtil.findComponentOfType((JComponent)this.myParamTable, JTable.class);
        this.myCenterPanel.add((Component)SeparatorFactory.createSeparator((String)"&Parameters", (JComponent)table), "North");
        if (table != null) {
            table.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (table.getRowCount() > 0) {
                        int col = table.getSelectedColumn();
                        int row = table.getSelectedRow();
                        if (col == -1 || row == -1) {
                            table.getSelectionModel().setSelectionInterval(0, 0);
                            table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
                        }
                    }
                }
            });
        }
    }

    protected ParameterTablePanel createParameterTableComponent() {
        return new ParameterTablePanel(this.myProject, this.myInputVariables, this.myElementsToExtract){

            protected void updateSignature() {
                ExtractMethodDialog.this.updateVarargsEnabled();
                ExtractMethodDialog.this.updateSignature();
            }

            protected void doEnterAction() {
                ExtractMethodDialog.this.clickDefaultButton();
            }

            protected void doCancelAction() {
                ExtractMethodDialog.this.doCancelAction();
            }

            protected boolean areTypesDirected() {
                return ExtractMethodDialog.this.areTypesDirected();
            }

            @Override
            protected boolean isUsedAfter(PsiVariable variable) {
                return ExtractMethodDialog.this.isOutputVariable(variable);
            }
        };
    }

    protected JComponent createSignaturePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"signature.preview.border.title"), null), "North");
        panel.add((Component)this.mySignature, "Center");
        this.updateSignature();
        return panel;
    }

    protected void updateSignature() {
        if (this.mySignature != null) {
            this.mySignature.setSignature(this.getSignature());
        }
    }

    protected String getSignature() {
        String typeParamsText;
        StringBuilder buffer = new StringBuilder();
        if (this.myGenerateAnnotations != null && this.myGenerateAnnotations.isSelected()) {
            NullableNotNullManager nullManager = NullableNotNullManager.getInstance((Project)this.myProject);
            buffer.append("@");
            buffer.append(StringUtil.getShortName((String)(this.myNullability == Nullability.NULLABLE ? nullManager.getDefaultNullable() : nullManager.getDefaultNotNull())));
            buffer.append("\n");
        }
        String visibilityString = VisibilityUtil.getVisibilityString((String)this.getVisibility());
        buffer.append(visibilityString);
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        if (this.isMakeStatic() && !this.isChainedConstructor()) {
            buffer.append("static ");
        }
        if (this.myTypeParameterList != null && !(typeParamsText = this.myTypeParameterList.getText()).isEmpty()) {
            buffer.append(typeParamsText);
            buffer.append(" ");
        }
        if (this.isChainedConstructor()) {
            buffer.append(this.myTargetClass.getName());
        } else {
            buffer.append(PsiFormatUtil.formatType((PsiType)(this.mySelector != null ? this.mySelector.getSelectedType() : this.myReturnType), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(" ");
            buffer.append(this.myNameField.getEnteredName());
        }
        buffer.append("(");
        String INDENT = StringUtil.repeatSymbol((char)' ', (int)buffer.length());
        VariableData[] datas = this.myInputVariables;
        int count = 0;
        for (int i = 0; i < datas.length; ++i) {
            VariableData data = datas[i];
            if (!data.passAsParameter) continue;
            PsiType type2 = data.type;
            if (i == datas.length - 1 && type2 instanceof PsiArrayType && this.myMakeVarargs != null && this.myMakeVarargs.isSelected()) {
                type2 = new PsiEllipsisType(((PsiArrayType)type2).getComponentType());
            }
            String typeText = type2.getPresentableText();
            if (count > 0) {
                buffer.append(",\n");
                buffer.append(INDENT);
            }
            buffer.append(typeText);
            buffer.append(" ");
            buffer.append(data.name);
            ++count;
        }
        buffer.append(")");
        if (this.myExceptions.length > 0) {
            buffer.append("\n");
            buffer.append("throws\n");
            for (PsiType exception : this.myExceptions) {
                buffer.append(INDENT);
                buffer.append(PsiFormatUtil.formatType((PsiType)exception, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    protected String getDimensionServiceKey() {
        return "extract.method.dialog";
    }

    protected void checkMethodConflicts(MultiMap<PsiElement, String> conflicts) {
        PsiMethod prototype;
        this.checkParametersConflicts(conflicts);
        try {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
            prototype = factory.createMethod(this.getChosenMethodName(), this.myReturnType);
            if (this.myTypeParameterList != null) {
                prototype.getTypeParameterList().replace((PsiElement)this.myTypeParameterList);
            }
            for (VariableData data : this.myInputVariables) {
                if (!data.passAsParameter) continue;
                prototype.getParameterList().add((PsiElement)factory.createParameter(data.name, data.type));
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)prototype, (String)"private", (boolean)true);
        }
        catch (IncorrectOperationException e) {
            return;
        }
        ConflictsUtil.checkMethodConflicts(this.myTargetClass, null, prototype, conflicts);
    }

    protected void checkParametersConflicts(MultiMap<PsiElement, String> conflicts) {
        HashSet<String> usedNames = new HashSet<String>();
        for (VariableData data : this.myInputVariables) {
            if (!data.passAsParameter || usedNames.add(data.name)) continue;
            conflicts.putValue(null, (Object)("Conflicting parameter name: " + data.name));
        }
    }

    @Override
    public PsiType getReturnType() {
        return this.mySelector != null ? this.mySelector.getSelectedType() : this.myReturnType;
    }

    @Override
    public boolean showInTransaction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/extractMethod/ExtractMethodDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenMethodName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDuplicatesCountLabel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

