/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.OptimizeImportsTask;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OptimizeImportsRefactoringHelper
implements RefactoringHelper<Set<PsiJavaFile>> {
    private static final String REMOVING_REDUNDANT_IMPORTS_TITLE = "Removing redundant imports";

    public Set<PsiJavaFile> prepareOperation(UsageInfo[] usages) {
        HashSet<PsiJavaFile> javaFiles = new HashSet<PsiJavaFile>();
        for (UsageInfo usage : usages) {
            PsiFile file;
            if (usage.isNonCodeUsage || !((file = usage.getFile()) instanceof PsiJavaFile)) continue;
            javaFiles.add((PsiJavaFile)file);
        }
        return javaFiles;
    }

    public void performOperation(Project project, Set<PsiJavaFile> javaFiles) {
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> PsiDocumentManager.getInstance((Project)project).commitAllDocuments());
        DumbService.getInstance((Project)project).completeJustSubmittedTasks();
        ArrayList redundants = new ArrayList();
        Runnable findRedundantImports = () -> ReadAction.run(() -> {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(false);
            }
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
            int i = 0;
            int fileCount = javaFiles.size();
            for (PsiJavaFile file : javaFiles) {
                Collection perFile;
                VirtualFile virtualFile;
                if (!file.isValid() || (virtualFile = file.getVirtualFile()) == null) continue;
                if (progressIndicator != null) {
                    progressIndicator.setText2(virtualFile.getPresentableUrl());
                    progressIndicator.setFraction((double)i++ / (double)fileCount);
                }
                if ((perFile = styleManager.findRedundantImports(file)) == null) continue;
                for (PsiImportStatementBase redundant : perFile) {
                    redundants.add(pointerManager.createSmartPsiElementPointer((PsiElement)redundant));
                }
            }
        });
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findRedundantImports, REMOVING_REDUNDANT_IMPORTS_TITLE, false, project)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, REMOVING_REDUNDANT_IMPORTS_TITLE, false);
            progressTask.setMinIterationTime(200L);
            progressTask.setTask((SequentialTask)new OptimizeImportsTask(progressTask, redundants));
            ProgressManager.getInstance().run((Task)progressTask);
        });
    }
}

