/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangInvokeHandleReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private final PsiExpression myContext;

    public JavaLangInvokeHandleReference(@NotNull PsiLiteralExpression literal, @NotNull PsiExpression context) {
        if (literal == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(2);
        }
        return element;
    }

    @Nullable
    public PsiElement resolve() {
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String) {
            JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
            String name = (String)value2;
            String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
            if (type2 != null && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass(this.myContext)) != null) {
                switch (type2) {
                    case "findGetter": 
                    case "findSetter": {
                        return JavaLangInvokeHandleReference.resolveField(name, ownerClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isNonStaticField));
                    }
                    case "findStaticGetter": 
                    case "findStaticSetter": {
                        return JavaLangInvokeHandleReference.resolveField(name, ownerClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isStaticField));
                    }
                    case "findVirtual": 
                    case "findSpecial": {
                        return this.resolveMethod(name, ownerClass, (Condition<? super PsiMethod>)((Condition)JavaLangInvokeHandleReference::isNonStaticMethod));
                    }
                    case "findStatic": {
                        return this.resolveMethod(name, ownerClass, (Condition<? super PsiMethod>)((Condition)JavaLangInvokeHandleReference::isStaticMethod));
                    }
                    case "findVarHandle": {
                        return JavaLangInvokeHandleReference.resolveField(name, ownerClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isNonStaticField));
                    }
                    case "findStaticVarHandle": {
                        return JavaLangInvokeHandleReference.resolveField(name, ownerClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isStaticField));
                    }
                }
            }
        }
        return null;
    }

    private static PsiElement resolveField(@NotNull String name, @NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Condition<? super PsiField> filter) {
        PsiField field;
        if (name == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(3);
        }
        if (ownerClass == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(4);
        }
        return (field = ownerClass.getPsiClass().findFieldByName(name, true)) != null && filter.value((Object)field) ? field : null;
    }

    private PsiElement resolveMethod(@NotNull String name, @NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Condition<? super PsiMethod> filter) {
        PsiExpression typeExpression;
        JavaReflectionReferenceUtil.ReflectiveSignature expectedSignature;
        PsiExpression[] arguments;
        PsiMethodCallExpression definitionCall;
        Object[] methods;
        if (name == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(5);
        }
        if (ownerClass == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(6);
        }
        if ((methods = ownerClass.getPsiClass().findMethodsByName(name, true)).length != 0 && (methods = ContainerUtil.filter((Object[])methods, filter).toArray(PsiMethod.EMPTY_ARRAY)).length > 1 && (definitionCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiMethodCallExpression.class)) != null && (arguments = definitionCall.getArgumentList().getExpressions()).length > 2 && (expectedSignature = JavaReflectionReferenceUtil.composeMethodSignature(typeExpression = ParenthesesUtils.stripParentheses(arguments[2]))) != null) {
            return (PsiElement)ContainerUtil.find((Object[])methods, method -> expectedSignature.equals(JavaReflectionReferenceUtil.getMethodSignature(method)));
        }
        return methods.length != 0 ? methods[0] : null;
    }

    @NotNull
    public Object[] getVariants() {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        String type2;
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String && (type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement)) != null && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass(this.myContext)) != null) {
            switch (type2) {
                case "findGetter": 
                case "findSetter": {
                    Object[] objectArray = this.lookupFields(ownerClass, JavaLangInvokeHandleReference::isNonStaticField);
                    if (objectArray == null) {
                        JavaLangInvokeHandleReference.$$$reportNull$$$0(7);
                    }
                    return objectArray;
                }
                case "findStaticGetter": 
                case "findStaticSetter": {
                    Object[] objectArray = this.lookupFields(ownerClass, JavaLangInvokeHandleReference::isStaticField);
                    if (objectArray == null) {
                        JavaLangInvokeHandleReference.$$$reportNull$$$0(8);
                    }
                    return objectArray;
                }
                case "findVirtual": {
                    Object[] objectArray = this.lookupMethods(ownerClass, JavaLangInvokeHandleReference::isNonStaticMethod);
                    if (objectArray == null) {
                        JavaLangInvokeHandleReference.$$$reportNull$$$0(9);
                    }
                    return objectArray;
                }
                case "findStatic": {
                    Object[] objectArray = this.lookupMethods(ownerClass, JavaLangInvokeHandleReference::isStaticMethod);
                    if (objectArray == null) {
                        JavaLangInvokeHandleReference.$$$reportNull$$$0(10);
                    }
                    return objectArray;
                }
                case "findVarHandle": {
                    Object[] objectArray = this.lookupFields(ownerClass, JavaLangInvokeHandleReference::isNonStaticField);
                    if (objectArray == null) {
                        JavaLangInvokeHandleReference.$$$reportNull$$$0(11);
                    }
                    return objectArray;
                }
                case "findStaticVarHandle": {
                    Object[] objectArray = this.lookupFields(ownerClass, JavaLangInvokeHandleReference::isStaticField);
                    if (objectArray == null) {
                        JavaLangInvokeHandleReference.$$$reportNull$$$0(12);
                    }
                    return objectArray;
                }
            }
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(13);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private Object[] lookupMethods(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Predicate<? super PsiMethod> filter) {
        if (ownerClass == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(14);
        }
        return ownerClass.getPsiClass().getVisibleSignatures().stream().map(MethodSignatureBackedByPsiMethod::getMethod).filter(filter).sorted(Comparator.comparingInt(method -> JavaReflectionReferenceUtil.getMethodSortOrder(method)).thenComparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.withPriority(JavaReflectionReferenceUtil.lookupMethod(method, this), -JavaReflectionReferenceUtil.getMethodSortOrder(method))).filter(Objects::nonNull).toArray();
    }

    private Object[] lookupFields(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Predicate<? super PsiField> filter) {
        if (ownerClass == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(15);
        }
        THashSet uniqueNames = new THashSet();
        return Arrays.stream(ownerClass.getPsiClass().getAllFields()).filter(arg_0 -> JavaLangInvokeHandleReference.lambda$lookupFields$3(ownerClass, (Set)uniqueNames, arg_0)).filter(filter).sorted(Comparator.comparing(field -> JavaReflectionReferenceUtil.isPublic((PsiMember)field) ? 0 : 1).thenComparing(PsiNamedElement::getName)).map(field -> JavaReflectionReferenceUtil.withPriority((LookupElement)JavaLookupElementBuilder.forField(field).withInsertHandler((InsertHandler)this), JavaReflectionReferenceUtil.isPublic((PsiMember)field))).toArray();
    }

    private static boolean isNonStaticField(PsiField field) {
        return field != null && !field.hasModifierProperty("static");
    }

    private static boolean isStaticField(PsiField field) {
        return field != null && field.hasModifierProperty("static");
    }

    private static boolean isNonStaticMethod(@Nullable PsiMethod method) {
        return JavaReflectionReferenceUtil.isRegularMethod(method) && !method.hasModifierProperty("static");
    }

    private static boolean isStaticMethod(@Nullable PsiMethod method) {
        return JavaReflectionReferenceUtil.isRegularMethod(method) && method.hasModifierProperty("static");
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Object object;
        if (context == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(16);
        }
        if (item == null) {
            JavaLangInvokeHandleReference.$$$reportNull$$$0(17);
        }
        if ((object = item.getObject()) instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
            String text2 = ", " + JavaReflectionReferenceUtil.getMethodTypeExpressionText((JavaReflectionReferenceUtil.ReflectiveSignature)object);
            JavaReflectionReferenceUtil.replaceText(context, text2);
        } else if (object instanceof PsiField) {
            PsiField field = (PsiField)object;
            String typeText = JavaReflectionReferenceUtil.getTypeText(field.getType());
            String text3 = ", " + typeText + ".class";
            JavaReflectionReferenceUtil.replaceText(context, text3);
        }
    }

    private static /* synthetic */ boolean lambda$lookupFields$3(JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Set uniqueNames, PsiField field) {
        return field != null && (field.getContainingClass() == ownerClass.getPsiClass() || !field.hasModifierProperty("private")) && field.getName() != null && uniqueNames.add(field.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveMethod";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lookupMethods";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lookupFields";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JavaLangInvokeHandleReferenceProvider
    extends PsiReferenceProvider {
        JavaLangInvokeHandleReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiElement parent;
            PsiLiteralExpression literal;
            if (element == null) {
                JavaLangInvokeHandleReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JavaLangInvokeHandleReferenceProvider.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiLiteralExpression && (literal = (PsiLiteralExpression)element).getValue() instanceof String && (parent = element.getParent()) instanceof PsiExpressionList) {
                PsiExpression qualifier;
                PsiExpression[] expressions2 = ((PsiExpressionList)parent).getExpressions();
                PsiExpression psiExpression = qualifier = expressions2.length != 0 ? expressions2[0] : null;
                if (qualifier != null) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new JavaLangInvokeHandleReference(literal, qualifier)};
                    if (psiReferenceArray == null) {
                        JavaLangInvokeHandleReferenceProvider.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaLangInvokeHandleReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference$JavaLangInvokeHandleReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference$JavaLangInvokeHandleReferenceProvider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

