/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ConstructorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ICodeFragmentElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaCodeReferenceElementImpl
extends CompositePsiElement
implements PsiAnnotatedJavaCodeReferenceElement,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl");
    private volatile String myCachedQName;
    private volatile String myCachedNormalizedText;
    private volatile Kind myKindWhenDummy = Kind.CLASS_NAME_KIND;
    private final int myHC = ourHC++;

    public PsiJavaCodeReferenceElementImpl() {
        super(JavaElementType.JAVA_CODE_REFERENCE);
    }

    public final int hashCode() {
        return this.myHC;
    }

    public int getTextOffset() {
        ASTNode refName = this.getReferenceNameNode();
        return refName != null ? refName.getStartOffset() : super.getTextOffset();
    }

    public void setKindWhenDummy(@NotNull Kind kind2) {
        if (kind2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(0);
        }
        IElementType type2 = this.getTreeParent().getElementType();
        LOG.assertTrue(PsiJavaCodeReferenceElementImpl.isDummy(type2), (Object)type2);
        this.myKindWhenDummy = kind2;
    }

    private static boolean isDummy(IElementType type2) {
        return type2 == TokenType.DUMMY_HOLDER || type2 == JavaElementType.DUMMY_ELEMENT;
    }

    @NotNull
    public Kind getKindEnum(@NotNull PsiFile containingFile) {
        CompositeElement treeParent;
        IElementType i;
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(1);
        }
        if (!containingFile.isValid()) {
            PsiUtilCore.ensureValid((PsiElement)this);
        }
        if (PsiJavaCodeReferenceElementImpl.isDummy(i = (treeParent = this.getTreeParent()).getElementType())) {
            Kind kind2 = this.myKindWhenDummy;
            if (kind2 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(2);
            }
            return kind2;
        }
        if (i == JavaElementType.TYPE) {
            Kind kind3 = treeParent.getTreeParent().getPsi() instanceof PsiTypeCodeFragment ? Kind.CLASS_OR_PACKAGE_NAME_KIND : Kind.CLASS_NAME_KIND;
            if (kind3 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(3);
            }
            return kind3;
        }
        if (i == JavaElementType.EXTENDS_LIST || i == JavaElementType.IMPLEMENTS_LIST || i == JavaElementType.EXTENDS_BOUND_LIST || i == JavaElementType.THROWS_LIST || i == JavaElementType.THIS_EXPRESSION || i == JavaElementType.SUPER_EXPRESSION || i == JavaDocElementType.DOC_METHOD_OR_FIELD_REF || i == JavaDocElementType.DOC_TAG_VALUE_ELEMENT || i == JavaElementType.REFERENCE_PARAMETER_LIST || i == JavaElementType.ANNOTATION || i == JavaElementType.USES_STATEMENT || i == JavaElementType.PROVIDES_STATEMENT || i == JavaElementType.PROVIDES_WITH_LIST) {
            Kind kind4 = this.isQualified() ? Kind.CLASS_OR_PACKAGE_NAME_KIND : Kind.CLASS_NAME_KIND;
            if (kind4 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(4);
            }
            return kind4;
        }
        if (i == JavaElementType.NEW_EXPRESSION) {
            ASTNode qualifier = treeParent.findChildByRole(54);
            Kind kind5 = qualifier != null ? Kind.CLASS_IN_QUALIFIED_NEW_KIND : Kind.CLASS_NAME_KIND;
            if (kind5 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(5);
            }
            return kind5;
        }
        if (i == JavaElementType.ANONYMOUS_CLASS) {
            if (treeParent.getChildRole((ASTNode)this) == 78) {
                CompositeElement granny = treeParent.getTreeParent();
                IElementType gType = granny.getElementType();
                LOG.assertTrue(gType == JavaElementType.NEW_EXPRESSION, (Object)gType);
                ASTNode qualifier = granny.findChildByRole(54);
                Kind kind6 = qualifier != null ? Kind.CLASS_IN_QUALIFIED_NEW_KIND : Kind.CLASS_NAME_KIND;
                if (kind6 == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(6);
                }
                return kind6;
            }
            Kind kind7 = Kind.CLASS_OR_PACKAGE_NAME_KIND;
            if (kind7 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(7);
            }
            return kind7;
        }
        if (i == JavaElementType.PACKAGE_STATEMENT || i == JavaElementType.EXPORTS_STATEMENT || i == JavaElementType.OPENS_STATEMENT) {
            Kind kind8 = Kind.PACKAGE_NAME_KIND;
            if (kind8 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(8);
            }
            return kind8;
        }
        if (i == JavaElementType.IMPORT_STATEMENT) {
            boolean isOnDemand = ((PsiImportStatement)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)treeParent)).isOnDemand();
            Kind kind9 = isOnDemand ? Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND : Kind.CLASS_FQ_NAME_KIND;
            if (kind9 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(9);
            }
            return kind9;
        }
        if (i == JavaElementType.IMPORT_STATIC_STATEMENT) {
            Kind kind10 = Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND;
            if (kind10 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(10);
            }
            return kind10;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            Kind parentKind = ((PsiJavaCodeReferenceElementImpl)treeParent).getKindEnum(containingFile);
            if (parentKind == Kind.CLASS_NAME_KIND) {
                Kind kind11 = Kind.CLASS_OR_PACKAGE_NAME_KIND;
                if (kind11 == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(11);
                }
                return kind11;
            }
            if (parentKind == Kind.CLASS_FQ_NAME_KIND) {
                Kind kind12 = Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND;
                if (kind12 == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(12);
                }
                return kind12;
            }
            Kind kind13 = parentKind;
            if (kind13 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(13);
            }
            return kind13;
        }
        if (i == JavaElementType.CLASS || i == JavaElementType.PARAMETER_LIST || i == TokenType.ERROR_ELEMENT) {
            Kind kind14 = Kind.CLASS_OR_PACKAGE_NAME_KIND;
            if (kind14 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(14);
            }
            return kind14;
        }
        if (i == JavaElementType.IMPORT_STATIC_REFERENCE) {
            Kind kind15 = Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND;
            if (kind15 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(15);
            }
            return kind15;
        }
        if (i == JavaDocElementType.DOC_TAG || i == JavaDocElementType.DOC_INLINE_TAG || i == JavaDocElementType.DOC_REFERENCE_HOLDER || i == JavaDocElementType.DOC_TYPE_HOLDER) {
            PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)this, PsiDocComment.class);
            if (JavaDocUtil.isInsidePackageInfo(docComment)) {
                Kind kind16 = Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND;
                if (kind16 == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(16);
                }
                return kind16;
            }
            Kind kind17 = Kind.CLASS_OR_PACKAGE_NAME_KIND;
            if (kind17 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(17);
            }
            return kind17;
        }
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(i)) {
            PsiJavaCodeReferenceCodeFragment fragment = (PsiJavaCodeReferenceCodeFragment)treeParent.getPsi();
            Kind kind18 = fragment.isClassesAccepted() ? Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND : Kind.PACKAGE_NAME_KIND;
            if (kind18 == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(18);
            }
            return kind18;
        }
        this.diagnoseUnknownParent();
        Kind kind19 = Kind.CLASS_NAME_KIND;
        if (kind19 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(19);
        }
        return kind19;
    }

    @Deprecated
    public int getKind(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(20);
        }
        return this.getKindEnum(containingFile).ordinal() + 1;
    }

    private void diagnoseUnknownParent() {
        CompositeElement parent;
        IElementType i = parent.getElementType();
        StringBuilder msg = new StringBuilder("Unknown parent for java code reference: '").append(parent).append("'; Type: ").append(i).append(";\n");
        for (parent = this.getTreeParent(); parent != null && parent.getPsi() instanceof PsiExpression; parent = parent.getTreeParent()) {
            msg.append(" Parent: '").append(parent).append("'; \n");
        }
        if (parent != null) {
            msg.append(DebugUtil.treeToString((ASTNode)parent, (boolean)false));
        }
        LOG.error(msg.toString());
    }

    private static boolean isCodeFragmentType(IElementType type2) {
        return type2 == TokenType.CODE_FRAGMENT || type2 instanceof ICodeFragmentElementType;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(21);
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByType(JavaTokenType.DOT, child);
            assert (dot != null) : this;
            this.deleteChildRange(child.getPsi(), dot.getPsi());
            ASTNode ref = this.findChildByRole(53);
            assert (ref != null) : this;
            PsiElement lastChild = ref.getPsi().getPrevSibling();
            if (lastChild != null) {
                PsiModifierList modifierList = PsiImplUtil.findNeighbourModifierList((PsiJavaCodeReferenceElement)this);
                if (modifierList != null) {
                    modifierList.addRange(this.getFirstChild(), lastChild);
                } else {
                    this.getParent().addRangeBefore(this.getFirstChild(), lastChild, (PsiElement)this);
                }
                if (ref != this.getFirstChild()) {
                    this.deleteChildRange(this.getFirstChild(), ref.getPsi().getPrevSibling());
                }
            }
        } else if (child.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST) {
            this.replaceChildInternal(child, PsiReferenceExpressionImpl.createEmptyRefParameterList(this.getProject()));
        } else {
            super.deleteChildInternal(child);
        }
    }

    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role), (Object)role);
        switch (role) {
            case 53: {
                return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.IDENTIFIER);
            }
            case 246: {
                TreeElement lastChild = this.getLastChildNode();
                return lastChild.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST ? lastChild : null;
            }
            case 54: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
        }
        return null;
    }

    public final int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(22);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getCanonicalText(false, null, this.getContainingFile());
        if (string == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations2) {
        String string = this.getCanonicalText(annotated, annotations2, this.getContainingFile());
        if (string == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations2, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(25);
        }
        Kind kind2 = this.getKindEnum(containingFile);
        switch (kind2) {
            case CLASS_NAME_KIND: 
            case CLASS_OR_PACKAGE_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                PsiElement target;
                JavaResolveResult[] results = PsiImplUtil.multiResolveImpl(containingFile.getProject(), containingFile, this, false, OurGenericsResolver.INSTANCE);
                PsiElement psiElement = target = results.length == 1 ? results[0].getElement() : null;
                if (target instanceof PsiClass) {
                    StringBuilder buffer = new StringBuilder();
                    PsiClass aClass = (PsiClass)target;
                    PsiElement qualifier = this.getQualifier();
                    String prefix = null;
                    if (qualifier instanceof PsiJavaCodeReferenceElementImpl) {
                        prefix = ((PsiJavaCodeReferenceElementImpl)qualifier).getCanonicalText(annotated, annotations2, containingFile);
                        annotations2 = null;
                    } else {
                        String fqn = aClass.getQualifiedName();
                        if (fqn != null) {
                            prefix = StringUtil.getPackageName((String)fqn);
                        }
                    }
                    if (!StringUtil.isEmpty((String)prefix)) {
                        buffer.append(prefix);
                        buffer.append('.');
                    }
                    if (annotated) {
                        List<PsiAnnotation> list = annotations2 != null ? Arrays.asList(annotations2) : this.getAnnotations();
                        PsiNameHelper.appendAnnotations((StringBuilder)buffer, list, (boolean)true);
                    }
                    buffer.append(aClass.getName());
                    PsiNameHelper.appendTypeArgs((StringBuilder)buffer, (PsiType[])this.getTypeParameters(), (boolean)true, (boolean)annotated);
                    String string = buffer.toString();
                    if (string == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(26);
                    }
                    return string;
                }
                if (target instanceof PsiPackage) {
                    String string = ((PsiPackage)target).getQualifiedName();
                    if (string == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(27);
                    }
                    return string;
                }
                LOG.assertTrue(target == null, (Object)target);
                String string = this.getNormalizedText();
                if (string == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(28);
                }
                return string;
            }
            case PACKAGE_NAME_KIND: 
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                String string = this.getNormalizedText();
                if (string == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(29);
                }
                return string;
            }
        }
        LOG.error((Object)kind2);
        if (null == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(30);
        }
        return null;
    }

    public PsiReference getReference() {
        return this;
    }

    public final PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @NotNull
    public static TextRange calcRangeInElement(CompositePsiElement refElement) {
        TreeElement nameChild = (TreeElement)refElement.findChildByRole(53);
        if (nameChild == null) {
            TreeElement dot = (TreeElement)refElement.findChildByRole(55);
            if (dot == null) {
                throw new IllegalStateException(refElement.toString());
            }
            TextRange textRange = TextRange.from((int)(dot.getStartOffsetInParent() + dot.getTextLength()), (int)0);
            if (textRange == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(31);
            }
            return textRange;
        }
        TextRange textRange = TextRange.from((int)nameChild.getStartOffsetInParent(), (int)nameChild.getTextLength());
        if (textRange == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(32);
        }
        return textRange;
    }

    public static JavaResolveResult[] tryClassResult(String qualifiedName, PsiJavaCodeReferenceElement referenceElement) {
        PsiElement qualifier = referenceElement.getQualifier();
        Project project = referenceElement.getProject();
        if (qualifier instanceof PsiJavaCodeReferenceElement) {
            PsiClass referencedClass = ResolveClassUtil.resolveClass((PsiJavaCodeReferenceElement)qualifier, referenceElement.getContainingFile());
            if (referencedClass != null) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, referenceElement.getResolveScope());
            if (aClass != null) {
                return new JavaResolveResult[]{new CandidateInfo((PsiElement)aClass, PsiSubstitutor.EMPTY, (PsiElement)referenceElement, false)};
            }
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(33);
        }
        return javaResolveResult;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, OurGenericsResolver.INSTANCE);
        if (javaResolveResultArray == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(34);
        }
        return javaResolveResultArray;
    }

    @NotNull
    private PsiSubstitutor updateSubstitutor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(35);
        }
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        PsiType[] parameters2 = this.getTypeParameters();
        PsiSubstitutor psiSubstitutor = subst = subst.putAll(psiClass, parameters2);
        if (psiSubstitutor == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(36);
        }
        return psiSubstitutor;
    }

    @NotNull
    private JavaResolveResult[] resolve(@NotNull Kind kind2, @NotNull PsiFile containingFile) {
        if (kind2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(37);
        }
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(38);
        }
        ProgressManager.checkCanceled();
        switch (kind2) {
            case CLASS_FQ_NAME_KIND: {
                PsiClass aClass;
                String text2 = this.getNormalizedText();
                if (!StringUtil.isEmptyOrSpaces((String)text2) && (aClass = JavaPsiFacade.getInstance((Project)containingFile.getProject()).findClass(text2, this.getResolveScope())) != null) {
                    JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo((PsiElement)aClass, this.updateSubstitutor(aClass), (PsiElement)this, false)};
                    if (javaResolveResultArray == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(39);
                    }
                    return javaResolveResultArray;
                }
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(40);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                PsiElement parent = this.getParent();
                if (parent instanceof JavaDummyHolder) {
                    parent = parent.getContext();
                }
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiNewExpression)) {
                    if (parent instanceof PsiJavaCodeReferenceElement) {
                        if (JavaResolveResult.EMPTY_ARRAY == null) {
                            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(41);
                        }
                        return JavaResolveResult.EMPTY_ARRAY;
                    }
                    LOG.error("Invalid java reference: " + parent);
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(42);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                LOG.assertTrue(qualifier != null);
                PsiType qualifierType = qualifier.getType();
                if (qualifierType == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(43);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!(qualifierType instanceof PsiClassType)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(44);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType((PsiType)qualifierType);
                PsiElement resultElement = result.getElement();
                if (resultElement == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(45);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(46);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, (PsiElement)this, containingFile);
                resultElement.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result.getSubstitutor()), (PsiElement)this, (PsiElement)this);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(47);
                }
                return javaResolveResultArray;
            }
            case CLASS_NAME_KIND: {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(48);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, (PsiElement)this, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, (PsiJavaCodeReferenceElement)this, null);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(49);
                }
                return javaResolveResultArray;
            }
            case PACKAGE_NAME_KIND: {
                String packageName = this.getNormalizedText();
                Project project = this.getManager().getProject();
                PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
                if (aPackage != null && aPackage.isValid()) {
                    JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo((PsiElement)aPackage, PsiSubstitutor.EMPTY, (PsiElement)this, false)};
                    if (javaResolveResultArray == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(50);
                    }
                    return javaResolveResultArray;
                }
                if (JavaPsiFacade.getInstance((Project)project).isPartOfPackagePrefix(packageName)) {
                    if (CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE == null) {
                        PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(51);
                    }
                    return CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE;
                }
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(52);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            case CLASS_OR_PACKAGE_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                JavaResolveResult[] result;
                Kind classKind = kind2 == Kind.CLASS_OR_PACKAGE_NAME_KIND ? Kind.CLASS_NAME_KIND : Kind.CLASS_FQ_NAME_KIND;
                PsiImportStatement importStatement = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PsiImportStatement.class);
                if (!(importStatement == null || importStatement.isOnDemand() && this.isQualified())) {
                    result = this.resolve(Kind.PACKAGE_NAME_KIND, containingFile);
                    if (result.length == 0) {
                        result = this.resolve(classKind, containingFile);
                    }
                } else {
                    result = this.resolve(classKind, containingFile);
                    if (result.length == 1 && !result[0].isAccessible()) {
                        JavaResolveResult[] packageResult = this.resolve(Kind.PACKAGE_NAME_KIND, containingFile);
                        if (packageResult.length != 0) {
                            result = packageResult;
                        }
                    } else if (result.length == 0) {
                        result = this.resolve(Kind.PACKAGE_NAME_KIND, containingFile);
                    }
                }
                if (result == null) {
                    PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(53);
                }
                return result;
            }
        }
        LOG.error((Object)this);
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(54);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public final PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier;
        if (newElementName == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(55);
        }
        if ((oldIdentifier = this.getReferenceNameElement()) == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory((Project)this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace((PsiElement)identifier);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(56);
        }
        PsiFile containingFile = this.getContainingFile();
        CheckUtil.checkWritable((PsiElement)containingFile);
        if (this.isReferenceTo(element)) {
            return this;
        }
        Kind kind2 = this.getKindEnum(containingFile);
        switch (kind2) {
            case CLASS_NAME_KIND: 
            case CLASS_FQ_NAME_KIND: {
                if (!(element instanceof PsiClass)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element, kind2);
                }
                return this.bindToClass((PsiClass)element, containingFile);
            }
            case PACKAGE_NAME_KIND: {
                if (!(element instanceof PsiPackage)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element, kind2);
                }
                return this.bindToPackage((PsiPackage)element);
            }
            case CLASS_OR_PACKAGE_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                if (element instanceof PsiClass) {
                    return this.bindToClass((PsiClass)element, containingFile);
                }
                if (element instanceof PsiPackage) {
                    return this.bindToPackage((PsiPackage)element);
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element, kind2);
            }
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                if (element instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)element;
                    String name = aClass.getName();
                    if (name == null) {
                        throw new IncorrectOperationException(aClass.toString());
                    }
                    PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)containingFile.getProject()).getParserFacade();
                    PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(name, this.getParent());
                    this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
                    return ref;
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element, kind2);
            }
        }
        LOG.error((Object)kind2);
        return null;
    }

    @NotNull
    private static IncorrectOperationException cannotBindError(@NotNull PsiElement element, @NotNull Kind kind2) {
        if (element == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(57);
        }
        if (kind2 == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(58);
        }
        IncorrectOperationException incorrectOperationException = new IncorrectOperationException("Cannot bind to " + element + " of kind: " + (Object)((Object)kind2));
        if (incorrectOperationException == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(59);
        }
        return incorrectOperationException;
    }

    private PsiElement bindToClass(@NotNull PsiClass aClass, @NotNull PsiFile containingFile) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        if (aClass == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(60);
        }
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(61);
        }
        String qName = aClass.getQualifiedName();
        Project project = containingFile.getProject();
        boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance((Project)project).useFQClassNames() && this.isFullyQualified(containingFile);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        if (qName == null) {
            qName = aClass.getName();
            assert (qName != null) : aClass;
            PsiClass psiClass = facade.getResolveHelper().resolveReferencedClass(qName, (PsiElement)this);
            if (!this.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)aClass)) {
                throw PsiJavaCodeReferenceElementImpl.cannotBindError((PsiElement)aClass, this.getKindEnum(containingFile));
            }
        } else {
            if (facade.findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
                return this;
            }
            if (facade.getResolveHelper().resolveReferencedClass(qName, (PsiElement)this) == null && facade.getResolveHelper().resolveReferencedClass(StringUtil.getPackageName((String)qName), (PsiElement)this) != null) {
                qName = aClass.getName();
                assert (qName != null) : aClass;
            }
        }
        StringBuilder text2 = new StringBuilder(qName);
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null) {
            for (PsiElement cur = this.getReferenceNameElement(); cur != parameterList; cur = cur.getNextSibling()) {
                assert (cur != null) : this.getText();
                text2.append(cur.getText());
            }
        }
        try {
            ref = facade.getParserFacade().createReferenceFromText(text2.toString(), this.getParent());
        }
        catch (IncorrectOperationException e) {
            throw new IncorrectOperationException(e.getMessage() + " [qname=" + qName + " class=" + aClass + ";" + aClass.getClass().getName() + "]");
        }
        PsiReferenceParameterList refParameterList = ref.getParameterList();
        if (parameterList != null && refParameterList != null) {
            refParameterList.replace((PsiElement)parameterList);
        }
        this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
        if (!preserveQualification) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            ref = (PsiJavaCodeReferenceElement)codeStyleManager.shortenClassReferences((PsiElement)ref, 8192);
        }
        return ref;
    }

    @NotNull
    private List<PsiAnnotation> getAnnotations() {
        PsiModifierList modifierList;
        ArrayList annotations2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiAnnotation.class);
        if (!this.isQualified() && (modifierList = PsiImplUtil.findNeighbourModifierList((PsiJavaCodeReferenceElement)this)) != null) {
            annotations2 = new ArrayList(annotations2);
            PsiImplUtil.collectTypeUseAnnotations(modifierList, annotations2);
        }
        ArrayList arrayList = annotations2;
        if (arrayList == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    private boolean isFullyQualified(@NotNull PsiFile containingFile) {
        ASTNode qualifier;
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(63);
        }
        Kind kind2 = this.getKindEnum(containingFile);
        switch (kind2) {
            case CLASS_OR_PACKAGE_NAME_KIND: {
                if (!(this.resolve() instanceof PsiPackage)) break;
                return true;
            }
            case CLASS_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                break;
            }
            case PACKAGE_NAME_KIND: 
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                return true;
            }
            default: {
                LOG.error((Object)kind2);
                return true;
            }
        }
        if ((qualifier = this.findChildByRole(54)) == null) {
            return false;
        }
        IElementType qualifierElementType = qualifier.getElementType();
        LOG.assertTrue(qualifierElementType == JavaElementType.JAVA_CODE_REFERENCE, (Object)qualifierElementType);
        PsiElement refElement = ((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)qualifier)).resolve();
        if (refElement instanceof PsiPackage) {
            return true;
        }
        return ((PsiJavaCodeReferenceElementImpl)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)qualifier)).isFullyQualified(containingFile);
    }

    private PsiElement bindToPackage(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        String qName;
        if (aPackage == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(64);
        }
        if ((qName = aPackage.getQualifiedName()).isEmpty()) {
            throw new IncorrectOperationException("Cannot bind to default package: " + aPackage);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade();
        PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(qName, this.getParent());
        this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
        return ref;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(65);
        }
        PsiFile containingFile = this.getContainingFile();
        return this.isReferenceTo(element, containingFile);
    }

    private boolean isReferenceTo(PsiElement element, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(66);
        }
        Kind kind2 = this.getKindEnum(containingFile);
        switch (kind2) {
            case CLASS_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                if (element instanceof PsiClass) break;
                return false;
            }
            case CLASS_FQ_NAME_KIND: {
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                String qName = ((PsiClass)element).getQualifiedName();
                return qName != null && qName.equals(this.getCanonicalText(false, null, containingFile));
            }
            case PACKAGE_NAME_KIND: {
                if (!(element instanceof PsiPackage)) {
                    return false;
                }
                String qName = ((PsiPackage)element).getQualifiedName();
                return qName.equals(this.getCanonicalText(false, null, containingFile));
            }
            case CLASS_OR_PACKAGE_NAME_KIND: {
                if (element instanceof PsiPackage) {
                    String qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText(false, null, containingFile));
                }
                if (element instanceof PsiClass) {
                    PsiElement nameElement = this.getReferenceNameElement();
                    if (nameElement == null) {
                        return false;
                    }
                    String name = ((PsiClass)element).getName();
                    if (name == null) {
                        return false;
                    }
                    return nameElement.textMatches((CharSequence)name) && containingFile.getManager().areElementsEquivalent(this.resolve(), element);
                }
                return false;
            }
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                String qName;
                if (element instanceof PsiClass && (qName = ((PsiClass)element).getQualifiedName()) != null && qName.equals(this.getCanonicalText(false, null, containingFile))) {
                    return !PsiUtil.isFromDefaultPackage((PsiClass)((PsiClass)element)) || PsiTreeUtil.getParentOfType((PsiElement)this, PsiImportStatementBase.class) == null;
                }
                if (element instanceof PsiPackage) {
                    qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText(false, null, containingFile));
                }
                return false;
            }
            default: {
                LOG.error((Object)kind2);
                return true;
            }
        }
        ASTNode referenceNameElement2 = this.getReferenceNameNode();
        if (referenceNameElement2 == null || referenceNameElement2.getElementType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        String name = ((PsiClass)element).getName();
        return name != null && referenceNameElement2.getText().equals(name) && containingFile.getManager().areElementsEquivalent(this.resolve(), element);
    }

    private String getNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = JavaSourceUtil.getReferenceText((PsiJavaCodeReferenceElement)this);
        }
        return whiteSpaceAndComments;
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName((String)this.getNormalizedText(), (boolean)false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(@NotNull PsiClass targetClass) {
        Kind kind2;
        if (targetClass == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(67);
        }
        if ((kind2 = this.getKindEnum(this.getContainingFile())) != Kind.CLASS_NAME_KIND && kind2 != Kind.CLASS_OR_PACKAGE_NAME_KIND && kind2 != Kind.CLASS_IN_QUALIFIED_NEW_KIND) {
            LOG.error("Wrong kind " + (Object)((Object)kind2));
            return;
        }
        JavaSourceUtil.fullyQualifyReference((CompositeElement)this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public PsiElement getQualifier() {
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)this.findChildByRole(54));
    }

    public void clearCaches() {
        super.clearCaches();
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
    }

    @NotNull
    public Object[] getVariants() {
        ElementClassFilter filter;
        switch (this.getKindEnum(this.getContainingFile())) {
            case CLASS_OR_PACKAGE_NAME_KIND: {
                filter = new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.PACKAGE});
                break;
            }
            case CLASS_NAME_KIND: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            case PACKAGE_NAME_KIND: {
                filter = ElementClassFilter.PACKAGE;
                break;
            }
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                filter = this.isQualified() ? new OrFilter(new ElementFilter[]{ElementClassFilter.CLASS, ElementClassFilter.PACKAGE}) : ElementClassFilter.PACKAGE;
                break;
            }
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        Object[] objectArray = PsiImplUtil.getReferenceVariantsByFilter((PsiJavaCodeReferenceElement)this, filter);
        if (objectArray == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(68);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(69);
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.isInCode() && !(this.getParent() instanceof PsiImportStatement) && !(this.getParent() instanceof PsiReferenceList)) {
            filters.add(new AndFilter((ElementFilter)ElementClassFilter.METHOD, (ElementFilter)new NotFilter((ElementFilter)new ConstructorFilter())));
            filters.add(ElementClassFilter.VARIABLE);
        }
        switch (this.getKindEnum(this.getContainingFile())) {
            case CLASS_OR_PACKAGE_NAME_KIND: {
                filters.add(ElementClassFilter.CLASS);
                filters.add(ElementClassFilter.PACKAGE);
                break;
            }
            case CLASS_NAME_KIND: {
                filters.add(ElementClassFilter.CLASS);
                if (!this.isQualified() && PsiTreeUtil.getParentOfType((PsiElement)this, PsiJavaModule.class) == null) break;
                filters.add(ElementClassFilter.PACKAGE);
                break;
            }
            case PACKAGE_NAME_KIND: {
                filters.add(ElementClassFilter.PACKAGE);
                break;
            }
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                filters.add(ElementClassFilter.PACKAGE);
                if (!this.isQualified() && !PsiJavaCodeReferenceElementImpl.isCodeFragmentType(this.getTreeParent().getElementType())) break;
                filters.add(ElementClassFilter.CLASS);
                break;
            }
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                PsiElement parent = this.getParent();
                if (parent instanceof PsiNewExpression) {
                    PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                    assert (qualifier != null) : parent;
                    PsiType type2 = qualifier.getType();
                    PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type2);
                    if (aClass != null) {
                        AndFilter filter = new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new ModifierFilter("static", false));
                        aClass.processDeclarations(new FilterScopeProcessor((ElementFilter)filter, processor), ResolveState.initial(), null, (PsiElement)this);
                    }
                }
                return;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        OrFilter filter = new OrFilter(filters.toArray(ElementFilter.EMPTY_ARRAY));
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)filter, processor);
        for (PsiTypeParameter typeParameter : this.getUnfinishedMethodTypeParameters()) {
            if (proc.execute((PsiElement)typeParameter, ResolveState.initial())) continue;
            return;
        }
        PsiScopesUtil.resolveAndWalk(proc, (PsiJavaCodeReferenceElement)this, null, true);
    }

    private PsiTypeParameter[] getUnfinishedMethodTypeParameters() {
        ProcessingContext context = new ProcessingContext();
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(">")).withParent((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiTypeParameterList.class).withParent(PsiErrorElement.class)).save("typeParameterList"))))).accepts((Object)this, context)) {
            PsiTypeParameterList list = (PsiTypeParameterList)context.get((Object)"typeParameterList");
            PsiElement current = list.getParent().getParent();
            if (current instanceof PsiField) {
                current = current.getParent();
            }
            if (current instanceof PsiClass) {
                return list.getTypeParameters();
            }
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    private boolean isInCode() {
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(this.getTreeParent().getElementType()) || this.getParent() instanceof PsiAnnotation) {
            return false;
        }
        for (PsiElement superParent = this.getParent(); superParent != null; superParent = superParent.getParent()) {
            if (superParent instanceof PsiCodeBlock || superParent instanceof PsiLocalVariable) {
                return true;
            }
            if (!(superParent instanceof PsiClass) && !(superParent instanceof PsiCatchSection)) continue;
            return false;
        }
        return false;
    }

    public PsiElement getReferenceNameElement() {
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)this.getReferenceNameNode());
    }

    @Nullable
    private ASTNode getReferenceNameNode() {
        return this.findChildByRole(53);
    }

    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
    }

    public String getQualifiedName() {
        Kind kind2 = this.getKindEnum(this.getContainingFile());
        switch (kind2) {
            case CLASS_NAME_KIND: 
            case CLASS_OR_PACKAGE_NAME_KIND: 
            case CLASS_IN_QUALIFIED_NEW_KIND: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    return name;
                }
                if (target instanceof PsiPackage) {
                    return ((PsiPackage)target).getQualifiedName();
                }
                LOG.assertTrue(target == null, (Object)target);
                return this.getClassNameText();
            }
            case PACKAGE_NAME_KIND: 
            case CLASS_FQ_NAME_KIND: 
            case CLASS_FQ_OR_PACKAGE_NAME_KIND: {
                return this.getNormalizedText();
            }
        }
        LOG.error((Object)kind2);
        return null;
    }

    public String getReferenceName() {
        ASTNode childByRole = this.getReferenceNameNode();
        if (childByRole == null) {
            return null;
        }
        return childByRole.getText();
    }

    @NotNull
    public final TextRange getRangeInElement() {
        TextRange textRange = PsiJavaCodeReferenceElementImpl.calcRangeInElement(this);
        if (textRange == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(70);
        }
        return textRange;
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            if (PsiType.EMPTY_ARRAY == null) {
                PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(71);
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] psiTypeArray = parameterList.getTypeArguments();
        if (psiTypeArray == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(72);
        }
        return psiTypeArray;
    }

    @NotNull
    public final PsiElement getElement() {
        PsiJavaCodeReferenceElementImpl psiJavaCodeReferenceElementImpl = this;
        if (psiJavaCodeReferenceElementImpl == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(73);
        }
        return psiJavaCodeReferenceElementImpl;
    }

    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiJavaCodeReferenceElementImpl.$$$reportNull$$$0(74);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public final String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 62: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 62: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 20: 
            case 25: 
            case 38: 
            case 61: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 62: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 56: 
            case 57: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindEnum";
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRangeInElement";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSubstitutor";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "cannotBindError";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setKindWhenDummy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKindEnum";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 62: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalText";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateSubstitutor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "cannotBindError";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "bindToClass";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isFullyQualified";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "bindToPackage";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "fullyQualify";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 62: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantContextResolver<PsiJavaReference> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            String qualifiedName;
            if (ref == null) {
                OurGenericsResolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                OurGenericsResolver.$$$reportNull$$$0(1);
            }
            PsiJavaCodeReferenceElementImpl referenceElement = (PsiJavaCodeReferenceElementImpl)ref;
            Kind kind2 = referenceElement.getKindEnum(containingFile);
            JavaResolveResult[] result = referenceElement.resolve(kind2, containingFile);
            if (incompleteCode && result.length == 0 && kind2 != Kind.CLASS_FQ_NAME_KIND && kind2 != Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND) {
                VariableResolverProcessor processor = new VariableResolverProcessor((PsiJavaCodeReferenceElement)referenceElement, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, (PsiJavaCodeReferenceElement)referenceElement, null, true);
                result = processor.getResult();
                if (result.length == 0 && kind2 == Kind.CLASS_NAME_KIND) {
                    result = referenceElement.resolve(Kind.PACKAGE_NAME_KIND, containingFile);
                }
            }
            if (result.length == 0 && (kind2 == Kind.CLASS_OR_PACKAGE_NAME_KIND || kind2 == Kind.CLASS_NAME_KIND) && (qualifiedName = referenceElement.getClassNameText()) != null) {
                result = PsiJavaCodeReferenceElementImpl.tryClassResult(qualifiedName, (PsiJavaCodeReferenceElement)referenceElement);
            }
            JavaResolveUtil.substituteResults((PsiJavaCodeReferenceElement)referenceElement, result);
            if (result == null) {
                OurGenericsResolver.$$$reportNull$$$0(2);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Kind {
        CLASS_NAME_KIND,
        PACKAGE_NAME_KIND,
        CLASS_OR_PACKAGE_NAME_KIND,
        CLASS_FQ_NAME_KIND,
        CLASS_FQ_OR_PACKAGE_NAME_KIND,
        CLASS_IN_QUALIFIED_NEW_KIND;

    }
}

