/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightReferenceListBuilder
extends LightElement
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private volatile PsiClassType[] myCachedTypes;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public LightReferenceListBuilder(PsiManager manager, PsiReferenceList.Role role) {
        this(manager, (Language)JavaLanguage.INSTANCE, role);
    }

    public LightReferenceListBuilder(PsiManager manager, Language language, PsiReferenceList.Role role) {
        super(manager, language);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
    }

    public String toString() {
        return "light reference list";
    }

    public void addReference(PsiClass aClass) {
        this.addReference(aClass.getQualifiedName());
    }

    public void addReference(String qualifiedName) {
        this.myRefs.add(this.myFactory.createReferenceElementByFQClassName(qualifiedName, this.getResolveScope()));
    }

    public void addReference(PsiClassType type2) {
        this.myRefs.add(this.myFactory.createReferenceElementByType(type2));
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = this.myRefs.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
        if (psiJavaCodeReferenceElementArray == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(0);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassType[] types = this.myCachedTypes;
        if (types == null) {
            int size = this.myRefs.size();
            types = size == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[size];
            for (int i = 0; i < size; ++i) {
                types[i] = this.myFactory.createType(this.myRefs.get(i));
            }
            this.myCachedTypes = types;
        }
        if (types == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(1);
        }
        return types;
    }

    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/light/LightReferenceListBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

