/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.EmptySubstitutorImpl;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UnmodifiableTHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiSubstitutorImpl");
    private static final TObjectHashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new TObjectHashingStrategy<PsiTypeParameter>(){

        public int computeHashCode(PsiTypeParameter parameter2) {
            return Comparing.hashcode((Object)parameter2.getName());
        }

        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            return element1.getManager().areElementsEquivalent((PsiElement)element1, (PsiElement)element2);
        }
    };
    private final Map<PsiTypeParameter, PsiType> mySubstitutionMap;
    private final SubstitutionVisitor mySimpleSubstitutionVisitor;
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"substituteGuard");

    private PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(0);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = new UnmodifiableTHashMap(PSI_EQUIVALENCE, map2);
    }

    private PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map2, @NotNull PsiTypeParameter additionalKey, @Nullable PsiType additionalValue) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(1);
        }
        if (additionalKey == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(2);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = new UnmodifiableTHashMap(PSI_EQUIVALENCE, map2, (Object)additionalKey, (Object)additionalValue);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(3);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = new UnmodifiableTHashMap(PSI_EQUIVALENCE, (Object)typeParameter, (Object)mapping);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(4);
        }
        this(PsiSubstitutorImpl.putAllInternal(Collections.emptyMap(), parentClass, mappings));
    }

    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(5);
        }
        return this.containsInMap(typeParameter) ? this.getFromMap(typeParameter) : JavaPsiFacade.getElementFactory((Project)typeParameter.getProject()).createType((PsiClass)typeParameter);
    }

    private boolean containsInMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(6);
        }
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.containsKey(typeParameter);
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(7);
        }
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.get(typeParameter);
    }

    public PsiType substitute(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        PsiUtil.ensureValidType((PsiType)type2);
        PsiType substituted = (PsiType)type2.accept((PsiTypeVisitor)this.mySimpleSubstitutionVisitor);
        return this.correctExternalSubstitution(substituted, type2);
    }

    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        PsiType substituted;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(8);
        }
        if ((substituted = this.substitute(typeParameter)) instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiWildcardType wildcard;
            PsiWildcardType wildcardType = (PsiWildcardType)substituted;
            PsiType glb = PsiCapturedWildcardType.captureUpperBound((PsiTypeParameter)typeParameter, (PsiWildcardType)wildcardType, (PsiSubstitutor)this);
            if (glb instanceof PsiWildcardType) {
                return glb;
            }
            if (glb instanceof PsiCapturedWildcardType && !(wildcard = ((PsiCapturedWildcardType)glb).getWildcard()).isSuper()) {
                return wildcard;
            }
            if (glb != null) {
                return PsiWildcardType.createExtends((PsiManager)typeParameter.getManager(), (PsiType)glb);
            }
        }
        return substituted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSubstitutorImpl)) {
            return false;
        }
        PsiSubstitutorImpl that = (PsiSubstitutorImpl)o;
        return !(this.mySubstitutionMap != null ? !this.mySubstitutionMap.equals(that.mySubstitutionMap) : that.mySubstitutionMap != null);
    }

    public int hashCode() {
        return this.mySubstitutionMap != null ? this.mySubstitutionMap.hashCode() : 0;
    }

    private PsiType rawTypeForTypeParameter(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType[] extendsTypes;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(9);
        }
        if ((extendsTypes = typeParameter.getExtendsListTypes()).length > 0) {
            return (PsiType)ourGuard.doPreventingRecursion((Object)extendsTypes[0], true, () -> this.substitute((PsiType)extendsTypes[0]));
        }
        return PsiType.getJavaLangObject((PsiManager)typeParameter.getManager(), (GlobalSearchScope)typeParameter.getResolveScope());
    }

    @NotNull
    private static TypeAnnotationProvider getMergedProvider(@NotNull PsiType type1, @NotNull PsiType type2) {
        if (type1 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(10);
        }
        if (type2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(11);
        }
        if (type1.getAnnotationProvider() == TypeAnnotationProvider.EMPTY && !(type1 instanceof PsiClassReferenceType)) {
            TypeAnnotationProvider typeAnnotationProvider = type2.getAnnotationProvider();
            if (typeAnnotationProvider == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(12);
            }
            return typeAnnotationProvider;
        }
        if (type2.getAnnotationProvider() == TypeAnnotationProvider.EMPTY && !(type2 instanceof PsiClassReferenceType)) {
            TypeAnnotationProvider typeAnnotationProvider = type1.getAnnotationProvider();
            if (typeAnnotationProvider == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(13);
            }
            return typeAnnotationProvider;
        }
        TypeAnnotationProvider typeAnnotationProvider = () -> (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])type1.getAnnotations(), (Object[])type2.getAnnotations());
        if (typeAnnotationProvider == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(14);
        }
        return typeAnnotationProvider;
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (original == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(15);
        }
        if (substituted != null) {
            return substituted;
        }
        return (PsiType)original.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            public PsiType visitArrayType(PsiArrayType arrayType) {
                return new PsiArrayType((PsiType)arrayType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return new PsiEllipsisType((PsiType)ellipsisType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass == null) {
                    return classType;
                }
                if (aClass instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass);
                }
                return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
            }

            public PsiType visitType(PsiType type2) {
                return null;
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(16);
        }
        if (mapping != null && !mapping.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping + "; " + mapping.getClass());
        }
        PsiSubstitutorImpl psiSubstitutorImpl = new PsiSubstitutorImpl(this.mySubstitutionMap, typeParameter, mapping);
        if (psiSubstitutorImpl == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(17);
        }
        return psiSubstitutorImpl;
    }

    private static Map<PsiTypeParameter, PsiType> putAllInternal(Map<PsiTypeParameter, PsiType> originalMap, @NotNull PsiClass parentClass, PsiType[] mappings) {
        PsiTypeParameter[] params;
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(18);
        }
        if ((params = parentClass.getTypeParameters()).length == 0) {
            return originalMap;
        }
        THashMap newMap = new THashMap(originalMap);
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping = mappings[i];
                newMap.put(param, mapping);
                if (mapping == null || mapping.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping);
                continue;
            }
            newMap.put(param, null);
        }
        return newMap;
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(19);
        }
        PsiSubstitutorImpl psiSubstitutorImpl = new PsiSubstitutorImpl(PsiSubstitutorImpl.putAllInternal(this.mySubstitutionMap, parentClass, mappings));
        if (psiSubstitutorImpl == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(20);
        }
        return psiSubstitutorImpl;
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(21);
        }
        if (another instanceof EmptySubstitutorImpl) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(22);
            }
            return psiSubstitutorImpl;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        THashMap newMap = new THashMap(this.mySubstitutionMap, PSI_EQUIVALENCE);
        newMap.putAll(anotherImpl.mySubstitutionMap);
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)newMap);
        if (psiSubstitutor == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(23);
        }
        return psiSubstitutor;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<PsiTypeParameter, PsiType>> set = this.mySubstitutionMap.entrySet();
        for (Map.Entry<PsiTypeParameter, PsiType> entry : set) {
            PsiTypeParameter typeParameter = entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner = typeParameter.getOwner();
            if (owner instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner).getQualifiedName());
            } else if (owner instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner).getName());
                buffer.append(" in ");
                PsiClass aClass = ((PsiMethod)owner).getContainingClass();
                buffer.append(aClass != null ? aClass.getQualifiedName() : "<no class>");
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(entry.getValue().getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    @NotNull
    public static PsiSubstitutor createSubstitutor(@Nullable Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null || map2.isEmpty()) {
            PsiSubstitutor psiSubstitutor = EMPTY;
            if (psiSubstitutor == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(24);
            }
            return psiSubstitutor;
        }
        PsiSubstitutorImpl psiSubstitutorImpl = new PsiSubstitutorImpl(map2);
        if (psiSubstitutorImpl == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(25);
        }
        return psiSubstitutorImpl;
    }

    public boolean isValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null || type2.isValid()) continue;
            return false;
        }
        return true;
    }

    public void ensureValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null) continue;
            PsiUtil.ensureValidType((PsiType)type2);
        }
    }

    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        Map<PsiTypeParameter, PsiType> map2 = this.mySubstitutionMap;
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(26);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalKey";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 4: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedProvider";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "put";
                break;
            }
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "putAll";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubstitutor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsInMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFromMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithBoundsPromotion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rawTypeForTypeParameter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMergedProvider";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "correctExternalSubstitution";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putAllInternal";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SubstitutionVisitor
    extends PsiTypeMapper {
        private SubstitutionVisitor() {
        }

        @Override
        public PsiType visitType(PsiType type2) {
            return null;
        }

        @Override
        public PsiType visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound == null) {
                return wildcardType;
            }
            PsiType newBound = (PsiType)bound.accept((PsiTypeVisitor)this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                PsiType newBoundBound = ((PsiWildcardType)newBound).getBound();
                return !((PsiWildcardType)newBound).isBounded() ? PsiWildcardType.createUnbounded((PsiManager)wildcardType.getManager()) : this.rebound(wildcardType, newBoundBound);
            }
            return newBound == PsiType.NULL ? newBound : this.rebound(wildcardType, newBound);
        }

        @NotNull
        private PsiWildcardType rebound(@NotNull PsiWildcardType type2, @NotNull PsiType newBound) {
            if (type2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(0);
            }
            if (newBound == null) {
                SubstitutionVisitor.$$$reportNull$$$0(1);
            }
            LOG.assertTrue(type2.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type2.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded((PsiManager)type2.getManager());
                    if (psiWildcardType == null) {
                        SubstitutionVisitor.$$$reportNull$$$0(2);
                    }
                    return psiWildcardType;
                }
                PsiWildcardType psiWildcardType = PsiWildcardType.createExtends((PsiManager)type2.getManager(), (PsiType)newBound);
                if (psiWildcardType == null) {
                    SubstitutionVisitor.$$$reportNull$$$0(3);
                }
                return psiWildcardType;
            }
            PsiWildcardType psiWildcardType = PsiWildcardType.createSuper((PsiManager)type2.getManager(), (PsiType)newBound);
            if (psiWildcardType == null) {
                SubstitutionVisitor.$$$reportNull$$$0(4);
            }
            return psiWildcardType;
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return classType;
            }
            PsiUtilCore.ensureValid((PsiElement)aClass);
            if (aClass instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                if (PsiSubstitutorImpl.this.containsInMap(typeParameter)) {
                    PsiType result = this.substituteTypeParameter(typeParameter);
                    if (result != null) {
                        PsiUtil.ensureValidType((PsiType)result);
                        if (result instanceof PsiClassType || result instanceof PsiArrayType || result instanceof PsiWildcardType) {
                            return result.annotate(PsiSubstitutorImpl.getMergedProvider((PsiType)classType, result));
                        }
                    }
                    return result;
                }
                return classType;
            }
            HashMap<PsiTypeParameter, PsiType> hashMap = new HashMap<PsiTypeParameter, PsiType>(2);
            if (!this.processClass(aClass, resolveResult.getSubstitutor(), hashMap)) {
                return null;
            }
            PsiClassType result = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, PsiSubstitutorImpl.createSubstitutor(hashMap), classType.getLanguageLevel());
            PsiUtil.ensureValidType((PsiType)result);
            return result.annotate(classType.getAnnotationProvider());
        }

        private PsiType substituteTypeParameter(@NotNull PsiTypeParameter typeParameter) {
            if (typeParameter == null) {
                SubstitutionVisitor.$$$reportNull$$$0(5);
            }
            return PsiSubstitutorImpl.this.getFromMap(typeParameter);
        }

        private PsiType substituteInternal(@NotNull PsiType type2) {
            if (type2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(6);
            }
            return (PsiType)type2.accept((PsiTypeVisitor)this);
        }

        private boolean processClass(@NotNull PsiClass resolve, @NotNull PsiSubstitutor originalSubstitutor, @NotNull Map<PsiTypeParameter, PsiType> substMap) {
            PsiTypeParameter[] params;
            if (resolve == null) {
                SubstitutionVisitor.$$$reportNull$$$0(7);
            }
            if (originalSubstitutor == null) {
                SubstitutionVisitor.$$$reportNull$$$0(8);
            }
            if (substMap == null) {
                SubstitutionVisitor.$$$reportNull$$$0(9);
            }
            for (PsiTypeParameter param : params = resolve.getTypeParameters()) {
                PsiType original = originalSubstitutor.substitute(param);
                if (original == null) {
                    substMap.put(param, null);
                    continue;
                }
                substMap.put(param, this.substituteInternal(original));
            }
            if (resolve.hasModifierProperty("static")) {
                return true;
            }
            PsiClass containingClass = resolve.getContainingClass();
            return containingClass == null || this.processClass(containingClass, originalSubstitutor, substMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBound";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeParameter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolve";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalSubstitutor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rebound";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rebound";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteTypeParameter";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteInternal";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "processClass";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

