/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.components.LegalNoticeDialog;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AcceptedLanguageLevels", storages={@Storage(value="acceptedLanguageLevels.xml")})
public class AcceptedLanguageLevelsSettings
implements PersistentStateComponent<AcceptedLanguageLevelsSettings>,
StartupActivity {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Accepted language levels", NotificationDisplayType.STICKY_BALLOON, true);
    @XCollection(propertyElementName="explicitly-accepted", elementName="name", valueAttributeName="")
    public List<String> acceptedNames = ContainerUtil.newArrayList();
    private static final String EXPERIMENTAL_FEATURE_ALERT = "Experimental Feature Alert";

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            AcceptedLanguageLevelsSettings.$$$reportNull$$$0(0);
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (!project.isDisposed()) {
                LanguageLevel level;
                MultiMap unacceptedLevels = new MultiMap();
                LanguageLevelProjectExtension projectExtension = LanguageLevelProjectExtension.getInstance((Project)project);
                if (projectExtension != null && !AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(level = projectExtension.getLanguageLevel())) {
                    unacceptedLevels.putValue((Object)level, null);
                }
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    LanguageLevel level2;
                    LanguageLevelModuleExtensionImpl moduleExtension = LanguageLevelModuleExtensionImpl.getInstance((Module)module);
                    if (moduleExtension == null || (level2 = moduleExtension.getLanguageLevel()) == null || AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(level2)) continue;
                    unacceptedLevels.putValue((Object)level2, (Object)module);
                }
                if (!unacceptedLevels.isEmpty()) {
                    AcceptedLanguageLevelsSettings.decreaseLanguageLevel(project);
                    for (LanguageLevel level3 : unacceptedLevels.keySet()) {
                        NOTIFICATION_GROUP.createNotification(EXPERIMENTAL_FEATURE_ALERT, AcceptedLanguageLevelsSettings.getLegalNotice(level3) + "<br/><a href='accept'>Accept</a>", NotificationType.WARNING, (notification, event) -> {
                            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                if (event.getDescription().equals("accept")) {
                                    AcceptedLanguageLevelsSettings.acceptAndRestore(project, unacceptedLevels.get((Object)level3), level3);
                                }
                                notification.expire();
                            }
                        }).notify(project);
                    }
                }
            }
        });
    }

    public static boolean isLanguageLevelAccepted(LanguageLevel languageLevel) {
        if (ApplicationManager.getApplication().isEAP()) {
            return true;
        }
        return LanguageLevel.HIGHEST.compareTo((Enum)languageLevel) >= 0 || AcceptedLanguageLevelsSettings.getSettings().acceptedNames.contains(languageLevel.name());
    }

    private static void acceptAndRestore(Project project, Collection<Module> modules, LanguageLevel languageLevel) {
        if (!AcceptedLanguageLevelsSettings.getSettings().acceptedNames.contains(languageLevel.name())) {
            AcceptedLanguageLevelsSettings.getSettings().acceptedNames.add(languageLevel.name());
        }
        if (modules != null) {
            JavaProjectModelModificationService service = JavaProjectModelModificationService.getInstance(project);
            WriteAction.run(() -> {
                for (Module module : modules) {
                    if (module != null) {
                        service.changeLanguageLevel(module, languageLevel);
                        continue;
                    }
                    LanguageLevelProjectExtension projectExtension = LanguageLevelProjectExtension.getInstance((Project)project);
                    projectExtension.setLanguageLevel(languageLevel);
                    projectExtension.setDefault(Boolean.valueOf(false));
                }
            });
        }
    }

    public static LanguageLevel getHighestAcceptedLevel() {
        LanguageLevel highest = LanguageLevel.HIGHEST;
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(level)) break;
            highest = level;
        }
        return highest;
    }

    private static AcceptedLanguageLevelsSettings getSettings() {
        return (AcceptedLanguageLevelsSettings)ServiceManager.getService(AcceptedLanguageLevelsSettings.class);
    }

    @Nullable
    public AcceptedLanguageLevelsSettings getState() {
        return this;
    }

    public void loadState(@NotNull AcceptedLanguageLevelsSettings state) {
        if (state == null) {
            AcceptedLanguageLevelsSettings.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static LanguageLevel checkAccepted(Component parent, LanguageLevel level) {
        return level == null || AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(level) || AcceptedLanguageLevelsSettings.showDialog(parent, level) ? level : null;
    }

    private static boolean showDialog(Component parent, LanguageLevel level) {
        int result = LegalNoticeDialog.build((String)EXPERIMENTAL_FEATURE_ALERT, (String)AcceptedLanguageLevelsSettings.getLegalNotice(level)).withParent(parent).show();
        if (result == 0) {
            AcceptedLanguageLevelsSettings.acceptAndRestore(null, null, level);
            return true;
        }
        return false;
    }

    private static void decreaseLanguageLevel(Project project) {
        WriteAction.run(() -> {
            LanguageLevel highestAcceptedLevel = AcceptedLanguageLevelsSettings.getHighestAcceptedLevel();
            JavaProjectModelModificationService service = JavaProjectModelModificationService.getInstance(project);
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                LanguageLevel languageLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
                if (languageLevel == null || AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(languageLevel)) continue;
                LanguageLevel newLanguageLevel = highestAcceptedLevel.isAtLeast(languageLevel) ? LanguageLevel.HIGHEST : highestAcceptedLevel;
                service.changeLanguageLevel(module, newLanguageLevel);
            }
            LanguageLevelProjectExtension projectExtension = LanguageLevelProjectExtension.getInstance((Project)project);
            if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(projectExtension.getLanguageLevel())) {
                projectExtension.setLanguageLevel(highestAcceptedLevel);
                projectExtension.setDefault(Boolean.valueOf(false));
            }
        });
    }

    private static String getLegalNotice(LanguageLevel level) {
        return "You must accept the terms of legal notice of the beta Java specification to enable support for \"" + level.getPresentableText() + "\".<br/><br/><b>The implementation of an early-draft specification developed under the Java Community Process (JCP) is made available for testing and evaluation purposes only and is not compatible with any specification of the JCP.</b>";
    }

    public static void allowLevel(@NotNull Disposable parentDisposable, @NotNull LanguageLevel level) {
        String name;
        List<String> acceptedNames;
        if (parentDisposable == null) {
            AcceptedLanguageLevelsSettings.$$$reportNull$$$0(2);
        }
        if (level == null) {
            AcceptedLanguageLevelsSettings.$$$reportNull$$$0(3);
        }
        if (!(acceptedNames = AcceptedLanguageLevelsSettings.getSettings().acceptedNames).contains(name = level.name())) {
            acceptedNames.add(name);
            Disposer.register((Disposable)parentDisposable, () -> AcceptedLanguageLevelsSettings.getSettings().acceptedNames.remove(name));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/intellij/pom/java/AcceptedLanguageLevelsSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "allowLevel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

