/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JavaModuleRenameListener
implements ProjectComponent,
ModuleListener {
    public JavaModuleRenameListener(@NotNull Project project) {
        if (project == null) {
            JavaModuleRenameListener.$$$reportNull$$$0(0);
        }
        project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)this);
    }

    public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
        if (project == null) {
            JavaModuleRenameListener.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            JavaModuleRenameListener.$$$reportNull$$$0(2);
        }
        if (oldNameProvider == null) {
            JavaModuleRenameListener.$$$reportNull$$$0(3);
        }
        ArrayList<Pair> suggestions = new ArrayList<Pair>();
        for (Module module : modules) {
            PsiJavaModule javaModule;
            if (ModuleType.get((Module)module) != JavaModuleType.getModuleType() || (javaModule = (PsiJavaModule)Stream.of(ModuleRootManager.getInstance((Module)module).getSourceRoots(false)).map(root -> JavaModuleGraphUtil.findDescriptorByFile(root, project)).filter(Objects::nonNull).findFirst().orElse(null)) == null || !javaModule.getName().equals(LightJavaModule.moduleName((String)oldNameProvider.fun((Object)module)))) continue;
            suggestions.add(Pair.pair((Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)javaModule), (Object)LightJavaModule.moduleName(module.getName())));
        }
        if (!suggestions.isEmpty()) {
            AppUIExecutor.onUiThread((ModalityState)ModalityState.NON_MODAL).later().inSmartMode(project).inTransaction((Disposable)project).execute(() -> JavaModuleRenameListener.renameModules(project, suggestions));
        }
    }

    private static void renameModules(Project project, List<Pair<SmartPsiElementPointer<PsiJavaModule>, String>> suggestions) {
        MyAutomaticRenamer renamer = new MyAutomaticRenamer();
        for (Pair<SmartPsiElementPointer<PsiJavaModule>, String> rename : suggestions) {
            PsiJavaModule javaModule = (PsiJavaModule)((SmartPsiElementPointer)rename.first).getElement();
            if (javaModule == null) continue;
            renamer.addElement(javaModule, (String)rename.second);
        }
        if (!renamer.getElements().isEmpty()) {
            AutomaticRenamingDialog dialog = new AutomaticRenamingDialog(project, (AutomaticRenamer)renamer);
            dialog.showOptionsPanel();
            if (dialog.showAndGet()) {
                RenameProcessor processor = null;
                for (Map.Entry entry : renamer.getRenames().entrySet()) {
                    String newName = (String)entry.getValue();
                    if (newName == null) continue;
                    if (processor == null) {
                        processor = new RenameProcessor(project, (PsiElement)entry.getKey(), newName, dialog.isSearchInComments(), dialog.isSearchTextOccurrences());
                        continue;
                    }
                    processor.addElement((PsiElement)entry.getKey(), newName);
                }
                if (processor != null) {
                    processor.run();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNameProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/java/JavaModuleRenameListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "modulesRenamed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyAutomaticRenamer
    extends AutomaticRenamer {
        private MyAutomaticRenamer() {
        }

        private void addElement(PsiJavaModule module, String newName) {
            this.myElements.add(module);
            this.suggestAllNames(module.getName(), newName);
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDialogTitle() {
            return RefactoringBundle.message((String)"auto.rename.module.dialog.title");
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDialogDescription() {
            return RefactoringBundle.message((String)"auto.rename.module.dialog.description");
        }

        public String entityName() {
            return RefactoringBundle.message((String)"auto.rename.module.entity");
        }
    }
}

