/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.ide.hierarchy.method.MethodHierarchyBrowser;
import com.intellij.ide.hierarchy.method.MethodHierarchyNodeDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.util.MethodSignature;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

abstract class OverrideImplementMethodAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.method.OverrideImplementMethodAction");

    OverrideImplementMethodAction() {
    }

    public final void actionPerformed(@NotNull AnActionEvent event) {
        DataContext dataContext;
        MethodHierarchyBrowser methodHierarchyBrowser;
        if (event == null) {
            OverrideImplementMethodAction.$$$reportNull$$$0(0);
        }
        if ((methodHierarchyBrowser = (MethodHierarchyBrowser)((Object)MethodHierarchyBrowserBase.DATA_KEY.getData(dataContext = event.getDataContext()))) == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        String commandName = event.getPresentation().getText();
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
            try {
                HierarchyNodeDescriptor[] selectedDescriptors = methodHierarchyBrowser.getSelectedDescriptors();
                if (selectedDescriptors.length > 0) {
                    ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(selectedDescriptors.length);
                    for (HierarchyNodeDescriptor selectedDescriptor : selectedDescriptors) {
                        VirtualFile vFile;
                        PsiFile containingFile = ((MethodHierarchyNodeDescriptor)selectedDescriptor).getPsiClass().getContainingFile();
                        if (containingFile == null || (vFile = containingFile.getVirtualFile()) == null) continue;
                        files.add(vFile);
                    }
                    ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files);
                    if (!status.hasReadonlyFiles()) {
                        for (HierarchyNodeDescriptor selectedDescriptor : selectedDescriptors) {
                            PsiElement aClass = ((MethodHierarchyNodeDescriptor)selectedDescriptor).getPsiClass();
                            if (!(aClass instanceof PsiClass)) continue;
                            OverrideImplementUtil.overrideOrImplement((PsiClass)aClass, methodHierarchyBrowser.getBaseMethod());
                        }
                        ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                    } else {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)status.getReadonlyFilesMessage(), (String)commandName));
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }, commandName, null));
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OverrideImplementMethodAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        MethodHierarchyBrowser methodHierarchyBrowser = (MethodHierarchyBrowser)((Object)MethodHierarchyBrowserBase.DATA_KEY.getData(dataContext));
        if (methodHierarchyBrowser == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        HierarchyNodeDescriptor[] selectedDescriptors = methodHierarchyBrowser.getSelectedDescriptors();
        int toImplement = 0;
        int toOverride = 0;
        for (HierarchyNodeDescriptor descriptor : selectedDescriptors) {
            if (OverrideImplementMethodAction.canImplementOverride((MethodHierarchyNodeDescriptor)descriptor, methodHierarchyBrowser, true)) {
                if (toOverride > 0) {
                    presentation.setEnabled(false);
                    presentation.setVisible(false);
                    return;
                }
                ++toImplement;
                continue;
            }
            if (OverrideImplementMethodAction.canImplementOverride((MethodHierarchyNodeDescriptor)descriptor, methodHierarchyBrowser, false)) {
                if (toImplement > 0) {
                    presentation.setEnabled(false);
                    presentation.setVisible(false);
                    return;
                }
                ++toOverride;
                continue;
            }
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(true);
        this.update(presentation, toImplement, toOverride);
    }

    protected abstract void update(Presentation var1, int var2, int var3);

    private static boolean canImplementOverride(MethodHierarchyNodeDescriptor descriptor, MethodHierarchyBrowser methodHierarchyBrowser, boolean toImplement) {
        PsiElement psiElement = descriptor.getPsiClass();
        if (!(psiElement instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass instanceof PsiSyntheticClass) {
            return false;
        }
        PsiMethod baseMethod = methodHierarchyBrowser.getBaseMethod();
        if (baseMethod == null) {
            return false;
        }
        MethodSignature signature = baseMethod.getSignature(PsiSubstitutor.EMPTY);
        Collection<MethodSignature> allOriginalSignatures = toImplement ? OverrideImplementUtil.getMethodSignaturesToImplement(psiClass) : OverrideImplementUtil.getMethodSignaturesToOverride(psiClass);
        for (MethodSignature originalSignature : allOriginalSignatures) {
            if (!originalSignature.equals(signature)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/hierarchy/method/OverrideImplementMethodAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

