/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.AbstractDependencyVisitor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java9GenerateModuleDescriptorsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(Java9GenerateModuleDescriptorsAction.class);
    private static final String TITLE = RefactoringBundle.message((String)"generate.module.descriptors.title");
    private static final String COMMAND_TITLE = RefactoringBundle.message((String)"generate.module.descriptors.command.title");

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !DumbService.isDumb((Project)project) && Java9GenerateModuleDescriptorsAction.isModularJdkAvailable());
    }

    private static boolean isModularJdkAvailable() {
        return Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).anyMatch(sdk -> JavaSdkUtil.isJdkAtLeast(sdk, JavaSdkVersion.JDK_1_9));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        CompileScope scope;
        Project project;
        if (e == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        if (!compilerManager.isUpToDate(scope = compilerManager.createProjectCompileScope(project))) {
            int result = Messages.showYesNoCancelDialog((Project)project, (String)RefactoringBundle.message((String)"generate.module.descriptors.rebuild.message"), (String)TITLE, null);
            if (result == 2) {
                return;
            }
            if (result == 0) {
                compilerManager.compile(scope, (aborted, errors, warnings, compileContext) -> {
                    if (!aborted && errors == 0) {
                        Java9GenerateModuleDescriptorsAction.generate(project);
                    }
                });
                return;
            }
        }
        Java9GenerateModuleDescriptorsAction.generate(project);
    }

    private static void generate(@NotNull Project project) {
        if (project == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(2);
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> Java9GenerateModuleDescriptorsAction.generateWhenSmart(project, new UniqueModuleNames(project)));
    }

    private static void generateWhenSmart(final @NotNull Project project, final @NotNull UniqueModuleNames uniqueModuleNames) {
        if (project == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(3);
        }
        if (uniqueModuleNames == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(4);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, TITLE, true){

            public void run(@NotNull ProgressIndicator indicator) {
                THashMap classFiles;
                int totalFiles;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((totalFiles = Java9GenerateModuleDescriptorsAction.collectClassFiles(project, (Map)(classFiles = new THashMap()))) != 0) {
                    new DescriptorsGenerator(project, uniqueModuleNames).generate((THashMap<Module, List<File>>)classFiles, indicator, totalFiles);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$1", "run"));
            }
        });
    }

    private static int collectClassFiles(@NotNull Project project, @NotNull Map<Module, List<File>> classFiles) {
        if (project == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(5);
        }
        if (classFiles == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(6);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(true);
        indicator.setText(RefactoringBundle.message((String)"generate.module.descriptors.scanning.message"));
        Module[] modules = (Module[])((StreamEx)StreamEx.of((Object[])ModuleManager.getInstance((Project)project).getModules()).filter(module -> Java9GenerateModuleDescriptorsAction.mayContainModuleInfo(module))).toArray((Object[])Module.EMPTY_ARRAY);
        if (modules.length == 0) {
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)RefactoringBundle.message((String)"generate.module.descriptors.no.suitable.modules.message"), (String)TITLE, null);
            return 0;
        }
        int totalFiles = 0;
        for (Module module2 : modules) {
            File productionRoot;
            ArrayList moduleClasses = new ArrayList();
            classFiles.put(module2, moduleClasses);
            String production = CompilerPaths.getModuleOutputPath((Module)module2, (boolean)false);
            File file = productionRoot = production != null ? new File(production) : null;
            if (productionRoot != null) {
                Java9GenerateModuleDescriptorsAction.collectClassFiles(productionRoot, moduleClasses);
            }
            totalFiles += moduleClasses.size();
        }
        if (totalFiles == 0) {
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)RefactoringBundle.message((String)"generate.module.descriptors.build.required.message"), (String)TITLE, null);
        }
        return totalFiles;
    }

    private static boolean mayContainModuleInfo(Module module) {
        return (Boolean)ReadAction.compute(() -> EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module).isAtLeast(LanguageLevel.JDK_1_9));
    }

    private static void collectClassFiles(@NotNull File file, @NotNull List<? super File> files) {
        File[] children;
        if (file == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(7);
        }
        if (files == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(8);
        }
        if ((children = file.listFiles()) != null) {
            for (File child : children) {
                Java9GenerateModuleDescriptorsAction.collectClassFiles(child, files);
            }
        } else if (file.getName().endsWith(".class")) {
            files.add(file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueModuleNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateWhenSmart";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "collectClassFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ModuleInfo {
        final PsiDirectory myRootDir;
        final String myName;
        final List<String> myRequires;
        final List<String> myExports;

        private ModuleInfo(@NotNull PsiDirectory rootDir, @NotNull String name, @NotNull List<String> requires, @NotNull List<String> exports) {
            if (rootDir == null) {
                ModuleInfo.$$$reportNull$$$0(0);
            }
            if (name == null) {
                ModuleInfo.$$$reportNull$$$0(1);
            }
            if (requires == null) {
                ModuleInfo.$$$reportNull$$$0(2);
            }
            if (exports == null) {
                ModuleInfo.$$$reportNull$$$0(3);
            }
            this.myRootDir = rootDir;
            this.myName = name;
            this.myRequires = requires;
            this.myExports = exports;
        }

        boolean fileAlreadyExists() {
            return StreamEx.of((Object[])this.myRootDir.getChildren()).select(PsiFile.class).map(PsiFileSystemItem::getName).anyMatch("module-info.java"::equals);
        }

        @NotNull
        CharSequence createModuleText() {
            StringBuilder text2 = new StringBuilder();
            text2.append("module ").append(this.myName).append(" {");
            for (String dependency : this.myRequires) {
                if ("java.base".equals(dependency)) continue;
                boolean isBadSyntax = StreamEx.of((Object[])NameConverter.splitByDots(dependency)).anyMatch(part -> JavaLexer.isKeyword(part, LanguageLevel.JDK_1_9));
                text2.append('\n').append(isBadSyntax ? "// " : " ").append("requires").append(' ').append(dependency).append(";");
            }
            if (!this.myRequires.isEmpty() && !this.myExports.isEmpty()) {
                text2.append('\n');
            }
            for (String packageName : this.myExports) {
                text2.append("\n ").append("exports").append(' ').append(packageName).append(";");
            }
            text2.append("\n}");
            StringBuilder stringBuilder = text2;
            if (stringBuilder == null) {
                ModuleInfo.$$$reportNull$$$0(4);
            }
            return stringBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootDir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requires";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exports";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$ModuleInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$ModuleInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createModuleText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ModuleVisitor
    extends AbstractDependencyVisitor {
        private final Set<String> myRequiredPackages = new THashSet();
        private final Set<String> myDeclaredPackages = new THashSet();
        private final PackageNamesCache myPackageNamesCache;

        ModuleVisitor(PackageNamesCache packageNamesCache) {
            this.myPackageNamesCache = packageNamesCache;
        }

        @Override
        protected void addClassName(String className) {
            String packageName = this.myPackageNamesCache.getPackageName(className);
            if (packageName != null) {
                this.myRequiredPackages.add(packageName);
            }
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            String packageName = this.myPackageNamesCache.getPackageName(this.getCurrentClassName());
            if (packageName != null) {
                this.myDeclaredPackages.add(packageName);
            }
        }

        public Set<String> getRequiredPackages() {
            return this.myRequiredPackages;
        }

        public Set<String> getDeclaredPackages() {
            return this.myDeclaredPackages;
        }
    }

    private static class PackageNamesCache {
        private final Map<String, Boolean> myPackages = new THashMap();
        private final JavaPsiFacade myPsiFacade;

        PackageNamesCache(Project project) {
            this.myPsiFacade = JavaPsiFacade.getInstance((Project)project);
        }

        private String getPackageName(String className) {
            int dotPos = className.lastIndexOf(46);
            while (dotPos > 0) {
                String packageName = className.substring(0, dotPos);
                Boolean isPackage = this.myPackages.computeIfAbsent(packageName, this::isExistingPackage);
                if (isPackage.booleanValue()) {
                    return packageName;
                }
                dotPos = className.lastIndexOf(46, dotPos - 1);
            }
            return null;
        }

        @NotNull
        private Boolean isExistingPackage(String packageName) {
            Boolean bl = (Boolean)ReadAction.compute(() -> this.myPsiFacade.findPackage(packageName) != null);
            if (bl == null) {
                PackageNamesCache.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$PackageNamesCache", "isExistingPackage"));
        }
    }

    private static class UniqueModuleNames {
        private final UniqueNameGenerator myNameGenerator;

        UniqueModuleNames(@NotNull Project project) {
            if (project == null) {
                UniqueModuleNames.$$$reportNull$$$0(0);
            }
            LOG.assertTrue(!DumbService.isDumb((Project)project), (Object)"Module name index should be ready");
            JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
            GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
            ArrayList<PsiJavaModule> modules = new ArrayList<PsiJavaModule>();
            for (String key2 : index.getAllKeys(project)) {
                modules.addAll(index.get(key2, project, scope));
            }
            this.myNameGenerator = new UniqueNameGenerator(modules, module -> (String)ReadAction.compute(() -> module.getName()));
        }

        @NotNull
        public String getUniqueName(@NotNull Module module) {
            if (module == null) {
                UniqueModuleNames.$$$reportNull$$$0(1);
            }
            String name = NameConverter.convertModuleName(module.getName());
            String string = this.myNameGenerator.generateUniqueName(name);
            if (string == null) {
                UniqueModuleNames.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$UniqueModuleNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$UniqueModuleNames";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUniqueName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUniqueName";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NameConverter {
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");
        private static final Pattern SINGLE_DOT = Pattern.compile("\\.");

        @NotNull
        public static String convertModuleName(@NotNull String name) {
            if (name == null) {
                NameConverter.$$$reportNull$$$0(0);
            }
            name = NON_NAME.matcher(name).replaceAll(".");
            name = DOT_SEQUENCE.matcher(name).replaceAll(".");
            name = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)name, (char)'.'), (char)'.');
            String[] parts = NameConverter.splitByDots(name);
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String part : parts) {
                if (part.length() == 0) continue;
                if (Character.isJavaIdentifierStart(part.charAt(0))) {
                    if (!first) {
                        builder.append('.');
                    }
                    builder.append(part);
                    if (JavaLexer.isKeyword(part, LanguageLevel.JDK_1_9)) {
                        builder.append('x');
                    }
                } else {
                    if (first) {
                        builder.append("module");
                    }
                    builder.append(part);
                }
                first = false;
            }
            String string = builder.toString();
            if (string == null) {
                NameConverter.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        static String[] splitByDots(@NotNull String text2) {
            if (text2 == null) {
                NameConverter.$$$reportNull$$$0(2);
            }
            String[] stringArray = SINGLE_DOT.split(text2);
            if (stringArray == null) {
                NameConverter.$$$reportNull$$$0(3);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$NameConverter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$NameConverter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertModuleName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitByDots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convertModuleName";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "splitByDots";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ModuleNode
    implements Comparable<ModuleNode> {
        private final Module myModule;
        private final Set<String> myDeclaredPackages;
        private final Set<String> myRequiredPackages;
        private final Set<ModuleNode> myDependencies;
        private final Set<String> myExports;
        private final PsiJavaModule myDescriptor;
        private final String myName;

        ModuleNode(@NotNull Module module, @NotNull Set<String> declaredPackages, @NotNull Set<String> requiredPackages, @NotNull UniqueModuleNames uniqueModuleNames) {
            if (module == null) {
                ModuleNode.$$$reportNull$$$0(0);
            }
            if (declaredPackages == null) {
                ModuleNode.$$$reportNull$$$0(1);
            }
            if (requiredPackages == null) {
                ModuleNode.$$$reportNull$$$0(2);
            }
            if (uniqueModuleNames == null) {
                ModuleNode.$$$reportNull$$$0(3);
            }
            this.myDependencies = new THashSet();
            this.myExports = new THashSet();
            this.myModule = module;
            this.myDeclaredPackages = declaredPackages;
            this.myRequiredPackages = requiredPackages;
            this.myDescriptor = (PsiJavaModule)ReadAction.compute(() -> {
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
                return sourceRoots.length != 0 ? ModuleNode.findDescriptor(module, sourceRoots[0]) : null;
            });
            this.myName = this.myDescriptor != null ? this.myDescriptor.getName() : uniqueModuleNames.getUniqueName(this.myModule);
        }

        @Nullable
        private static PsiJavaModule findDescriptor(@NotNull Module module, VirtualFile root) {
            if (module == null) {
                ModuleNode.$$$reportNull$$$0(4);
            }
            return JavaModuleGraphUtil.findDescriptorByFile(root, module.getProject());
        }

        ModuleNode(@NotNull PsiJavaModule descriptor) {
            if (descriptor == null) {
                ModuleNode.$$$reportNull$$$0(5);
            }
            this.myDependencies = new THashSet();
            this.myExports = new THashSet();
            this.myModule = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)descriptor));
            this.myDeclaredPackages = Collections.emptySet();
            this.myRequiredPackages = Collections.emptySet();
            this.myDescriptor = descriptor;
            this.myName = this.myDescriptor.getName();
        }

        public Set<String> getDeclaredPackages() {
            return this.myDeclaredPackages;
        }

        public Set<String> getRequiredPackages() {
            return this.myRequiredPackages;
        }

        public Set<ModuleNode> getDependencies() {
            return this.myDependencies;
        }

        public List<ModuleNode> getSortedDependencies() {
            ArrayList<ModuleNode> list = new ArrayList<ModuleNode>(this.myDependencies);
            list.sort(ModuleNode::compareTo);
            return list;
        }

        public Set<String> getExports() {
            return this.myExports;
        }

        public List<String> getSortedExports() {
            ArrayList<String> list = new ArrayList<String>(this.myExports);
            list.sort(String::compareTo);
            return list;
        }

        public PsiJavaModule getDescriptor() {
            return this.myDescriptor;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ModuleNode.$$$reportNull$$$0(6);
            }
            return string;
        }

        public String toString() {
            return this.myName;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ModuleNode && this.myName.equals(((ModuleNode)o).myName);
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        @Override
        public int compareTo(@NotNull ModuleNode o) {
            int j2;
            int m2;
            if (o == null) {
                ModuleNode.$$$reportNull$$$0(7);
            }
            int m1 = this.myModule == null ? 0 : 1;
            int n = m2 = o.myModule == null ? 0 : 1;
            if (m1 != m2) {
                return m1 - m2;
            }
            int j1 = this.myName.startsWith("java.") || this.myName.startsWith("javax.") ? 0 : 1;
            int n2 = j2 = o.myName.startsWith("java.") || o.myName.startsWith("javax.") ? 0 : 1;
            if (j1 != j2) {
                return j1 - j2;
            }
            return StringUtil.compare((String)this.myName, (String)o.myName, (boolean)false);
        }

        public PsiDirectory getRootDir() {
            if (this.myModule == null) {
                return null;
            }
            return (PsiDirectory)ReadAction.compute(() -> {
                ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)this.myModule);
                PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
                return ModuleNode.findJavaDirectory(psiManager, moduleManager.getSourceRoots(false));
            });
        }

        @Nullable
        private static PsiDirectory findJavaDirectory(PsiManager psiManager, VirtualFile[] roots) {
            return ((StreamEx)StreamEx.of((Object[])roots).sorted(Comparator.comparingInt(vFile -> "java".equals(vFile.getName()) ? 0 : 1).thenComparing(VirtualFile::getName))).map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).nonNull().findFirst().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaredPackages";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requiredPackages";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uniqueModuleNames";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$ModuleNode";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$ModuleNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findDescriptor";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DescriptorsGenerator {
        private final Project myProject;
        private final UniqueModuleNames myUniqueModuleNames;
        private final List<ModuleNode> myModuleNodes;
        private final Set<String> myUsedExternallyPackages;
        private final ProgressTracker myProgressTracker;

        DescriptorsGenerator(@NotNull Project project, @NotNull UniqueModuleNames uniqueModuleNames) {
            if (project == null) {
                DescriptorsGenerator.$$$reportNull$$$0(0);
            }
            if (uniqueModuleNames == null) {
                DescriptorsGenerator.$$$reportNull$$$0(1);
            }
            this.myModuleNodes = new ArrayList<ModuleNode>();
            this.myUsedExternallyPackages = new THashSet();
            this.myProgressTracker = new ProgressTracker(0.5, 0.3, 0.2);
            this.myProject = project;
            this.myUniqueModuleNames = uniqueModuleNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void generate(THashMap<Module, List<File>> classFiles, ProgressIndicator indicator, int totalFiles) {
            List<ModuleInfo> moduleInfos;
            this.myProgressTracker.init(indicator);
            try {
                this.myProgressTracker.startPhase(RefactoringBundle.message((String)"generate.module.descriptors.collecting.message"), totalFiles);
                Map<String, Set<ModuleNode>> packagesDeclaredInModules = this.collectDependencies(classFiles);
                this.myProgressTracker.nextPhase();
                this.myProgressTracker.startPhase(RefactoringBundle.message((String)"generate.module.descriptors.analysing.message"), this.myModuleNodes.size());
                this.analyseDependencies(packagesDeclaredInModules);
                this.myProgressTracker.nextPhase();
                this.myProgressTracker.startPhase(RefactoringBundle.message((String)"generate.module.descriptors.preparing.message"), this.myModuleNodes.size());
                moduleInfos = this.prepareModuleInfos();
                this.myProgressTracker.nextPhase();
            }
            finally {
                this.myProgressTracker.dispose();
            }
            this.createFilesLater(moduleInfos);
        }

        private void createFilesLater(List<ModuleInfo> moduleInfos) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    CommandProcessor.getInstance().executeCommand(this.myProject, () -> ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(COMMAND_TITLE, this.myProject, null, indicator -> DescriptorsGenerator.createFiles(this.myProject, moduleInfos, indicator)), COMMAND_TITLE, null);
                }
            });
        }

        private Map<String, Set<ModuleNode>> collectDependencies(THashMap<Module, List<File>> classFiles) {
            PackageNamesCache packageNamesCache = new PackageNamesCache(this.myProject);
            THashMap packagesDeclaredInModules = new THashMap();
            for (Map.Entry entry : classFiles.entrySet()) {
                Module module = (Module)entry.getKey();
                ModuleVisitor visitor = new ModuleVisitor(packageNamesCache);
                List files = (List)entry.getValue();
                if (files.isEmpty()) {
                    LOG.info("Output directory for module " + module.getName() + " doesn't contain .class files");
                    continue;
                }
                for (File file : files) {
                    visitor.processFile(file);
                    this.myProgressTracker.increment();
                }
                Set<String> declaredPackages = visitor.getDeclaredPackages();
                Set<String> requiredPackages = visitor.getRequiredPackages();
                requiredPackages.removeAll(declaredPackages);
                this.myUsedExternallyPackages.addAll(requiredPackages);
                ModuleNode moduleNode = new ModuleNode(module, declaredPackages, requiredPackages, this.myUniqueModuleNames);
                this.myModuleNodes.add(moduleNode);
                for (String declaredPackage : declaredPackages) {
                    packagesDeclaredInModules.computeIfAbsent(declaredPackage, __ -> new THashSet()).add(moduleNode);
                }
            }
            return packagesDeclaredInModules;
        }

        private void analyseDependencies(Map<String, Set<ModuleNode>> packagesDeclaredInModules) {
            THashMap nodesByDescriptor = new THashMap();
            for (ModuleNode moduleNode : this.myModuleNodes) {
                if (moduleNode.getDescriptor() != null) {
                    nodesByDescriptor.put(moduleNode.getDescriptor(), moduleNode);
                }
                for (String packageName : moduleNode.getRequiredPackages()) {
                    Set<ModuleNode> set = packagesDeclaredInModules.get(packageName);
                    if (set == null) {
                        PsiJavaModule descriptor;
                        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
                        if (psiPackage == null || (descriptor = (PsiJavaModule)ReadAction.compute(() -> DescriptorsGenerator.findDescriptor(psiPackage))) == null) continue;
                        ModuleNode dependencyNode = nodesByDescriptor.computeIfAbsent(descriptor, ModuleNode::new);
                        moduleNode.getDependencies().add(dependencyNode);
                        continue;
                    }
                    if (set.size() != 1) {
                        LOG.info("Split package " + packageName + " found in " + set);
                    }
                    moduleNode.getDependencies().addAll(set);
                }
                this.myProgressTracker.increment();
            }
        }

        private List<ModuleInfo> prepareModuleInfos() {
            ArrayList<ModuleInfo> moduleInfo = new ArrayList<ModuleInfo>();
            for (ModuleNode moduleNode : this.myModuleNodes) {
                if (moduleNode.getDescriptor() != null) {
                    LOG.info("Module descriptor already exists in " + moduleNode);
                    continue;
                }
                for (String packageName : moduleNode.getDeclaredPackages()) {
                    if (!this.myUsedExternallyPackages.contains(packageName)) continue;
                    moduleNode.getExports().add(packageName);
                }
                PsiDirectory rootDir = moduleNode.getRootDir();
                if (rootDir != null) {
                    List dependencies = ((StreamEx)StreamEx.of(moduleNode.getSortedDependencies()).map(ModuleNode::getName).filter(name -> !"java.base".equals(name))).toList();
                    List<String> exports = moduleNode.getSortedExports();
                    moduleInfo.add(new ModuleInfo(rootDir, moduleNode.getName(), dependencies, exports));
                } else {
                    LOG.info("Skipped module " + moduleNode + " because it doesn't have production source root");
                }
                this.myProgressTracker.increment();
            }
            return moduleInfo;
        }

        private static void createFiles(Project project, List<? extends ModuleInfo> moduleInfos, ProgressIndicator indicator) {
            indicator.setIndeterminate(false);
            int count = 0;
            double total = moduleInfos.size();
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate("module-info");
            for (ModuleInfo moduleInfo : moduleInfos) {
                ProgressManager.getInstance().executeNonCancelableSection(() -> DescriptorsGenerator.createFile(template, moduleInfo));
                indicator.setFraction((double)(++count) / total);
            }
        }

        private static void createFile(FileTemplate template, ModuleInfo moduleInfo) {
            if (moduleInfo.fileAlreadyExists()) {
                return;
            }
            Project project = moduleInfo.myRootDir.getProject();
            Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            FileTemplateUtil.fillDefaultProperties((Properties)properties, (PsiDirectory)moduleInfo.myRootDir);
            properties.setProperty("NAME", "module-info");
            try {
                PsiJavaFile moduleInfoFile = (PsiJavaFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)"module-info.java", (Properties)properties, (PsiDirectory)moduleInfo.myRootDir);
                PsiJavaModule javaModule = moduleInfoFile.getModuleDeclaration();
                LOG.assertTrue(javaModule != null, (Object)"module-info file should contain module declaration");
                CharSequence moduleText = moduleInfo.createModuleText();
                PsiJavaFile dummyFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText("module-info.java", (Language)JavaLanguage.INSTANCE, moduleText);
                PsiJavaModule actualModule = dummyFile.getModuleDeclaration();
                LOG.assertTrue(actualModule != null, (Object)"module declaration wasn't created");
                javaModule.replace((PsiElement)actualModule);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)moduleInfoFile);
            }
            catch (Exception e) {
                LOG.error("Failed to create module-info.java in " + moduleInfo.myRootDir.getVirtualFile().getPath() + ": " + e.getMessage());
            }
        }

        @Nullable
        private static PsiJavaModule findDescriptor(PsiPackage psiPackage) {
            PsiManager psiManager = psiPackage.getManager();
            return StreamEx.of((Object[])psiPackage.getDirectories()).map(PsiDirectory::getVirtualFile).nonNull().map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).nonNull().findAny().map(JavaModuleGraphUtil::findDescriptorByElement).orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "uniqueModuleNames";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$DescriptorsGenerator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProgressTracker {
        ProgressIndicator myIndicator;
        int myCount;
        int mySize;
        int myPhase;
        double myUpToNow;
        private final double[] myPhases;

        ProgressTracker(double ... phases) {
            this.myPhases = phases;
        }

        void startPhase(String text2, int size) {
            this.myIndicator.setText(text2);
            this.myCount = 0;
            this.mySize = Math.min(size, 1);
        }

        public void nextPhase() {
            this.myUpToNow += this.myPhases[this.myPhase++];
        }

        public void increment() {
            this.myIndicator.setFraction(this.myUpToNow + this.myPhases[this.myPhase] * (double)(++this.myCount) / (double)this.mySize);
        }

        public void init(ProgressIndicator indicator) {
            this.myIndicator = indicator;
            this.myIndicator.setFraction(0.0);
            this.myIndicator.setIndeterminate(false);
        }

        public void dispose() {
            this.myIndicator = null;
        }
    }
}

