/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;

public class BinopInstruction
extends BranchingInstruction
implements ExpressionPushingInstruction {
    private static final TokenSet ourSignificantOperations = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.INSTANCEOF_KEYWORD, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.AND, JavaTokenType.OR, JavaTokenType.PERC, JavaTokenType.DIV, JavaTokenType.ASTERISK, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.LTLT});
    private final IElementType myOperationSign;
    @Nullable
    private final PsiType myResultType;
    private final int myLastOperand;

    public BinopInstruction(IElementType opSign, @Nullable PsiExpression psiAnchor, @Nullable PsiType resultType) {
        this(opSign, psiAnchor, resultType, -1);
    }

    public BinopInstruction(IElementType opSign, @Nullable PsiExpression psiAnchor, @Nullable PsiType resultType, int lastOperand) {
        super((PsiElement)psiAnchor);
        this.myResultType = resultType;
        this.myOperationSign = ourSignificantOperations.contains(opSign) ? opSign : null;
        this.myLastOperand = lastOperand;
    }

    @Override
    @Nullable
    public TextRange getExpressionRange() {
        PsiPolyadicExpression anchor;
        PsiExpression[] operands2;
        if (this.myLastOperand != -1 && this.getPsiAnchor() instanceof PsiPolyadicExpression && (operands2 = (anchor = (PsiPolyadicExpression)this.getPsiAnchor()).getOperands()).length > this.myLastOperand + 1) {
            return new TextRange(0, operands2[this.myLastOperand].getStartOffsetInParent() + operands2[this.myLastOperand].getTextLength());
        }
        return null;
    }

    @Override
    @Nullable
    public PsiExpression getExpression() {
        return (PsiExpression)this.getPsiAnchor();
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitBinop(this, runner, stateBefore);
    }

    @Nullable
    public PsiType getResultType() {
        return this.myResultType;
    }

    public String toString() {
        return "BINOP " + this.myOperationSign;
    }

    public IElementType getOperationSign() {
        return this.myOperationSign;
    }
}

