/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class CollectionMethodInliner
implements CallInliner {
    private static final CallMatcher CLEAR = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "clear").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "clear").parameterCount(0));

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        PsiExpression qualifier;
        if (builder == null) {
            CollectionMethodInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            CollectionMethodInliner.$$$reportNull$$$0(1);
        }
        if ((qualifier = call.getMethodExpression().getQualifierExpression()) == null) {
            return false;
        }
        if (CLEAR.matches((PsiExpression)call)) {
            CollectionMethodInliner.inlineClear(builder, qualifier);
            return true;
        }
        return false;
    }

    private static void inlineClear(@NotNull CFGBuilder builder, @NotNull PsiExpression qualifier) {
        if (builder == null) {
            CollectionMethodInliner.$$$reportNull$$$0(2);
        }
        if (qualifier == null) {
            CollectionMethodInliner.$$$reportNull$$$0(3);
        }
        DfaValueFactory factory = builder.getFactory();
        builder.pushExpression(qualifier).unwrap(SpecialField.COLLECTION_SIZE).push(factory.getInt(0)).assign().pop().pushUnknown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inliner/CollectionMethodInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineClear";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

