/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.SpecialFieldValue;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class CollectionFactoryInliner
implements CallInliner {
    private static final CallMapper<FactoryInfo> STATIC_FACTORIES = new CallMapper<FactoryInfo>().register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet").parameterCount(0), new FactoryInfo(0)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "singletonList", "singleton").parameterCount(1), new FactoryInfo(1)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "emptyMap").parameterCount(0), new FactoryInfo(0)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "singletonMap").parameterCount(2), new FactoryInfo(1));
    private static final CallMatcher JDK9_MAP_FACTORIES = CallMatcher.staticCall("java.util.Map", "of", "ofEntries");
    private static final CallMatcher JDK9_FACTORIES = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("java.util.Set", "of"));
    private static final CallMatcher JDK9_ARRAY_FACTORIES = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of").parameterTypes("E..."), CallMatcher.staticCall("java.util.Set", "of").parameterTypes("E..."));

    private static FactoryInfo getFactoryInfo(@NotNull PsiMethodCallExpression call) {
        FactoryInfo info;
        if (call == null) {
            CollectionFactoryInliner.$$$reportNull$$$0(0);
        }
        if ((info = STATIC_FACTORIES.mapFirst(call)) != null) {
            return info;
        }
        if (JDK9_FACTORIES.test(call)) {
            int size = JDK9_ARRAY_FACTORIES.test(call) && !MethodCallUtils.isVarArgCall((PsiCall)call) ? -1 : call.getArgumentList().getExpressionCount();
            return new FactoryInfo(size, true);
        }
        if (JDK9_MAP_FACTORIES.test(call)) {
            boolean ofEntries = "ofEntries".equals(call.getMethodExpression().getReferenceName());
            int size = ofEntries && !MethodCallUtils.isVarArgCall((PsiCall)call) ? -1 : call.getArgumentList().getExpressionCount() / (ofEntries ? 1 : 2);
            return new FactoryInfo(size, true);
        }
        return null;
    }

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        PsiExpression[] args;
        PsiType callType;
        if (builder == null) {
            CollectionFactoryInliner.$$$reportNull$$$0(1);
        }
        if (call == null) {
            CollectionFactoryInliner.$$$reportNull$$$0(2);
        }
        if ((callType = call.getType()) == null) {
            return false;
        }
        FactoryInfo factoryInfo = CollectionFactoryInliner.getFactoryInfo(call);
        if (factoryInfo == null) {
            return false;
        }
        for (PsiExpression arg : args = call.getArgumentList().getExpressions()) {
            builder.pushExpression(arg, factoryInfo.myNotNull ? NullabilityProblemKind.passingToNotNullParameter : null);
            builder.pop();
        }
        DfaValueFactory factory = builder.getFactory();
        SpecialFieldValue sizeConstraint = factoryInfo.mySize == -1 ? null : SpecialField.COLLECTION_SIZE.withValue(factory.getInt(factoryInfo.mySize));
        DfaFactMap facts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, factory.createDfaType(callType).asConstraint()).with(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL).with(DfaFactType.MUTABILITY, Mutability.UNMODIFIABLE).with(DfaFactType.SPECIAL_FIELD_VALUE, sizeConstraint);
        builder.push(factory.getFactFactory().createValue(facts), (PsiExpression)call);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inliner/CollectionFactoryInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFactoryInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class FactoryInfo {
        final boolean myNotNull;
        final int mySize;

        FactoryInfo(int size) {
            this(size, false);
        }

        FactoryInfo(int size, boolean notNull) {
            this.mySize = size;
            this.myNotNull = notNull;
        }
    }
}

