/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EscapeInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PrimitiveConversionInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.StandardInstructionVisitor");
    private final Set<InstanceofInstruction> myReachable = new THashSet();
    private final Set<InstanceofInstruction> myCanBeNullInInstanceof = new THashSet();
    private final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (!(dfaDest instanceof DfaVariableValue) && instruction.getAssignedValue() != null) {
            dfaDest = instruction.getAssignedValue();
        }
        if (dfaSource == dfaDest) {
            memState.push(dfaDest);
            this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dfaDest, memState);
            return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
        }
        if (!(dfaDest instanceof DfaVariableValue && ((DfaVariableValue)dfaDest).getPsiVariable() instanceof PsiLocalVariable && dfaSource instanceof DfaVariableValue && ControlFlowAnalyzer.isTempVariable((DfaVariableValue)dfaSource))) {
            StandardInstructionVisitor.dropLocality(dfaSource, memState);
        }
        PsiExpression lValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)instruction.getLExpression());
        PsiExpression rValue = instruction.getRExpression();
        if (lValue instanceof PsiArrayAccessExpression) {
            this.checkArrayElementAssignability(runner, memState, dfaSource, lValue, rValue);
        }
        if (dfaDest instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiModifierListOwner psi = var.getPsiVariable();
            if (dfaSource instanceof DfaFactMapValue && var.getQualifier() != null && !Boolean.TRUE.equals(memState.getValueFact(var.getQualifier(), DfaFactType.LOCALITY))) {
                dfaSource = ((DfaFactMapValue)dfaSource).withFact(DfaFactType.LOCALITY, null);
            }
            if (!(psi instanceof PsiField) || !psi.hasModifierProperty("volatile")) {
                memState.setVarValue(var, dfaSource);
            }
            if (var.getInherentNullability() == Nullability.NULLABLE && !memState.isNotNull(dfaSource) && instruction.isVariableInitializer()) {
                DfaMemoryStateImpl stateImpl = (DfaMemoryStateImpl)memState;
                stateImpl.setVariableState(var, stateImpl.getVariableState(var).withFact(DfaFactType.NULLABILITY, DfaNullability.NULLABLE));
            }
        }
        this.pushExpressionResult(dfaDest, instruction, memState);
        this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dfaDest, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void checkArrayElementAssignability(DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaSource, PsiExpression lValue, PsiExpression rValue) {
        DfaValue arrayValue;
        if (rValue == null) {
            return;
        }
        PsiType rCodeType = rValue.getType();
        PsiType lCodeType = lValue.getType();
        if (rCodeType == null || lCodeType == null || !TypeConversionUtil.areTypesConvertible((PsiType)rCodeType, (PsiType)lCodeType)) {
            return;
        }
        PsiExpression array = ((PsiArrayAccessExpression)lValue).getArrayExpression();
        PsiType arrayType = StandardInstructionVisitor.getType(array, arrayValue = runner.getFactory().createValue(array), memState);
        if (!(arrayType instanceof PsiArrayType)) {
            return;
        }
        PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
        PsiType sourceType = StandardInstructionVisitor.getType(rValue, dfaSource, memState);
        if (sourceType == null || TypeConversionUtil.areTypesConvertible((PsiType)sourceType, (PsiType)componentType)) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)rValue, PsiAssignmentExpression.class);
        this.processArrayStoreTypeMismatch(assignmentExpression, sourceType, componentType);
    }

    @Nullable
    private static PsiType getType(@Nullable PsiExpression expression2, @Nullable DfaValue value2, @NotNull DfaMemoryState memState) {
        PsiType type2;
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(0);
        }
        TypeConstraint fact = value2 == null ? null : memState.getValueFact(value2, DfaFactType.TYPE_CONSTRAINT);
        PsiType psiType = type2 = fact == null ? null : fact.getPsiType();
        if (type2 != null) {
            return type2;
        }
        return expression2 == null ? null : expression2.getType();
    }

    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
    }

    @Override
    public DfaInstructionState[] visitEscapeInstruction(EscapeInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        instruction.getEscapedVars().forEach(var -> StandardInstructionVisitor.dropLocality(var, state));
        return super.visitEscapeInstruction(instruction, runner, state);
    }

    private static void dropLocality(DfaValue value2, DfaMemoryState state) {
        if (!(value2 instanceof DfaVariableValue)) {
            return;
        }
        DfaVariableValue var = (DfaVariableValue)value2;
        state.dropFact(var, DfaFactType.LOCALITY);
        for (DfaVariableValue v : new ArrayList<DfaVariableValue>(var.getDependentVariables())) {
            state.dropFact(v, DfaFactType.LOCALITY);
        }
    }

    @Override
    public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiArrayAccessExpression arrayExpression = instruction.getExpression();
        DfaValue index = memState.pop();
        DfaValue array = memState.pop();
        boolean alwaysOutOfBounds = false;
        DfaValueFactory factory = runner.getFactory();
        if (index != DfaUnknownValue.getInstance()) {
            DfaValue dfaLength;
            DfaValue indexLessThanLength;
            DfaValue indexNonNegative = factory.createCondition(index, DfaRelationValue.RelationType.GE, factory.getInt(0));
            if (!memState.applyCondition(indexNonNegative)) {
                alwaysOutOfBounds = true;
            }
            if (!memState.applyCondition(indexLessThanLength = factory.createCondition(index, DfaRelationValue.RelationType.LT, dfaLength = SpecialField.ARRAY_LENGTH.createValue(factory, array)))) {
                alwaysOutOfBounds = true;
            }
        }
        this.processArrayAccess(arrayExpression, alwaysOutOfBounds);
        DfaValue result = instruction.getValue();
        LongRangeSet rangeSet = memState.getValueFact(index, DfaFactType.RANGE);
        DfaValue arrayElementValue = runner.getFactory().getExpressionFactory().getArrayElementValue(array, rangeSet == null ? LongRangeSet.all() : rangeSet);
        if (arrayElementValue != DfaUnknownValue.getInstance()) {
            result = arrayElementValue;
        }
        this.pushExpressionResult(result, instruction, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
    }

    @Override
    public DfaInstructionState[] visitMethodReference(MethodReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiMethodReferenceExpression expression2 = instruction.getExpression();
        DfaValue qualifier = memState.pop();
        StandardInstructionVisitor.dropLocality(qualifier, memState);
        this.handleMethodReference(qualifier, expression2, runner, memState);
        this.pushExpressionResult(runner.getFactory().createTypeValue(expression2.getFunctionalInterfaceType(), Nullability.NOT_NULL), instruction, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void handleMethodReference(DfaValue qualifier, PsiMethodReferenceExpression methodRef, DataFlowRunner runner, DfaMemoryState state) {
        PsiType functionalInterfaceType = methodRef.getFunctionalInterfaceType();
        if (functionalInterfaceType == null) {
            return;
        }
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (sam2 == null || PsiType.VOID.equals((Object)sam2.getReturnType())) {
            return;
        }
        JavaResolveResult resolveResult = methodRef.advancedResolve(false);
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
        if (method == null || !JavaMethodContractUtil.isPure(method)) {
            return;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, null);
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        DfaCallArguments callArguments = StandardInstructionVisitor.getMethodReferenceCallArguments(methodRef, qualifier, runner, sam2, method, substitutor);
        this.dereference(state, callArguments.myQualifier, NullabilityProblemKind.callMethodRefNPE.problem(methodRef, null));
        if (contracts2.isEmpty()) {
            return;
        }
        PsiType returnType = substitutor.substitute(method.getReturnType());
        DfaValue defaultResult = runner.getFactory().createTypeValue(returnType, DfaPsiUtil.getElementNullability(returnType, (PsiModifierListOwner)method));
        Set<DfaCallState> currentStates = Collections.singleton(new DfaCallState(state.createClosureState(), callArguments));
        for (MethodContract methodContract : contracts2) {
            currentStates = this.addContractResults(methodContract, currentStates, runner.getFactory(), new HashSet<DfaMemoryState>(), defaultResult, (PsiExpression)methodRef);
        }
        for (DfaCallState dfaCallState : currentStates) {
            this.pushExpressionResult(defaultResult, () -> methodRef, dfaCallState.myMemoryState);
        }
    }

    @NotNull
    private static DfaCallArguments getMethodReferenceCallArguments(PsiMethodReferenceExpression methodRef, DfaValue qualifier, DataFlowRunner runner, PsiMethod sam2, PsiMethod method, PsiSubstitutor substitutor) {
        PsiParameter[] samParameters = sam2.getParameterList().getParameters();
        boolean isStatic = method.hasModifierProperty("static");
        boolean instanceBound = !isStatic && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        Object[] arguments = new DfaValue[parameters2.length];
        Arrays.fill(arguments, DfaUnknownValue.getInstance());
        for (int i = 0; i < samParameters.length; ++i) {
            DfaValue value2 = runner.getFactory().createTypeValue(substitutor.substitute(samParameters[i].getType()), DfaPsiUtil.getFunctionalParameterNullability((PsiFunctionalExpression)methodRef, i));
            if (i == 0 && !isStatic && !instanceBound) {
                qualifier = value2;
                continue;
            }
            int idx = i - (isStatic || instanceBound ? 0 : 1);
            if (idx >= arguments.length) break;
            if (parameters2[idx].getType() instanceof PsiEllipsisType) continue;
            arguments[idx] = value2;
        }
        DfaCallArguments dfaCallArguments = new DfaCallArguments(qualifier, (DfaValue[])arguments, JavaMethodContractUtil.isPure(method));
        if (dfaCallArguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(1);
        }
        return dfaCallArguments;
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiType type2 = instruction.getCastTo();
        DfaValueFactory factory = runner.getFactory();
        PsiType fromType = instruction.getCasted().getType();
        if (fromType != null && type2.isConvertibleFrom(fromType) && !memState.castTopOfStack(factory.createDfaType(type2))) {
            this.onInstructionProducesCCE(instruction);
        }
        DfaValue value2 = memState.pop();
        if (type2 instanceof PsiPrimitiveType) {
            value2 = DfaUtil.boxUnbox(value2, type2);
        }
        this.pushExpressionResult(value2, instruction, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
    }

    protected void beforeMethodCall(@NotNull PsiExpression expression2, @NotNull DfaCallArguments arguments, @NotNull DataFlowRunner runner, @NotNull DfaMemoryState memState) {
        if (expression2 == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(2);
        }
        if (arguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(3);
        }
        if (runner == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(4);
        }
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(5);
        }
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValueFactory factory = runner.getFactory();
        DfaCallArguments callArguments = this.popCall(instruction, factory, memState);
        if (callArguments.myArguments != null && instruction.getExpression() != null) {
            this.beforeMethodCall(instruction.getExpression(), callArguments, runner, memState);
        }
        LinkedHashSet finalStates = ContainerUtil.newLinkedHashSet();
        finalStates.addAll(this.handleKnownMethods(instruction, runner, memState, callArguments));
        if (finalStates.isEmpty()) {
            Set<DfaCallState> currentStates = Collections.singleton(new DfaCallState(memState, callArguments));
            DfaValue defaultResult = StandardInstructionVisitor.getMethodResultValue(instruction, callArguments.myQualifier, memState, factory);
            if (callArguments.myArguments != null) {
                for (MethodContract contract : instruction.getContracts()) {
                    currentStates = this.addContractResults(contract, currentStates, factory, finalStates, defaultResult, instruction.getExpression());
                    if (currentStates.size() + finalStates.size() <= 300) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Too complex contract on " + instruction.getContext() + ", skipping contract processing");
                    }
                    finalStates.clear();
                    currentStates = Collections.singleton(new DfaCallState(memState, callArguments));
                    break;
                }
            }
            for (DfaCallState callState : currentStates) {
                this.pushExpressionResult(defaultResult, instruction, callState.myMemoryState);
                finalStates.add(callState.myMemoryState);
            }
        }
        DfaInstructionState[] result = new DfaInstructionState[finalStates.size()];
        int i = 0;
        for (DfaMemoryState state : finalStates) {
            if (instruction.shouldFlushFields()) {
                state.flushFields();
            }
            result[i++] = new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), state);
        }
        return result;
    }

    @NotNull
    private List<DfaMemoryState> handleKnownMethods(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaCallArguments callArguments) {
        if (callArguments.myArguments == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(6);
            }
            return list;
        }
        PsiMethod method = instruction.getTargetMethod();
        if (method == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(7);
            }
            return list;
        }
        CustomMethodHandlers.CustomMethodHandler handler = CustomMethodHandlers.find(method);
        if (handler == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(8);
            }
            return list;
        }
        DfaValue result = handler.getMethodResult(callArguments, memState, runner.getFactory());
        if (result == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(9);
            }
            return list;
        }
        this.pushExpressionResult(result, instruction, memState);
        List<DfaMemoryState> list = Collections.singletonList(memState);
        if (list == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    protected DfaCallArguments popCall(MethodCallInstruction instruction, DfaValueFactory factory, DfaMemoryState memState) {
        PsiMethod method = instruction.getTargetMethod();
        MutationSignature sig = MutationSignature.fromMethod(method);
        DfaValue[] argValues = this.popCallArguments(instruction, factory, memState, sig);
        DfaValue qualifier = this.popQualifier(instruction, memState, sig);
        DfaCallArguments dfaCallArguments = new DfaCallArguments(qualifier, argValues, !instruction.shouldFlushFields());
        if (dfaCallArguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(11);
        }
        return dfaCallArguments;
    }

    @Nullable
    private DfaValue[] popCallArguments(MethodCallInstruction instruction, DfaValueFactory factory, DfaMemoryState memState, MutationSignature sig) {
        PsiParameterList paramList;
        int paramCount;
        int argCount = instruction.getArgCount();
        PsiMethod method = instruction.getTargetMethod();
        boolean varargCall = instruction.isVarArgCall();
        DfaValue[] argValues = null;
        if (method != null && ((paramCount = (paramList = method.getParameterList()).getParametersCount()) == argCount || method.isVarArgs() && argCount >= paramCount - 1)) {
            argValues = new DfaValue[paramCount];
            if (varargCall) {
                argValues[paramCount - 1] = factory.createTypeValue(paramList.getParameters()[paramCount - 1].getType(), Nullability.NOT_NULL);
            }
        }
        for (int i = 0; i < argCount; ++i) {
            DfaValue arg = memState.pop();
            int paramIndex = argCount - i - 1;
            StandardInstructionVisitor.dropLocality(arg, memState);
            PsiElement anchor = instruction.getArgumentAnchor(paramIndex);
            if (instruction.getContext() instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)instruction.getContext();
                Nullability nullability = instruction.getArgRequiredNullability(paramIndex);
                if (nullability == Nullability.NOT_NULL) {
                    arg = this.dereference(memState, arg, NullabilityProblemKind.passingToNotNullMethodRefParameter.problem(methodRef, null));
                } else if (nullability == Nullability.UNKNOWN) {
                    this.checkNotNullable(memState, arg, NullabilityProblemKind.passingToNonAnnotatedMethodRefParameter.problem(methodRef, null));
                }
            }
            if (sig.mutatesArg(paramIndex) && !memState.applyFact(arg, DfaFactType.MUTABILITY, Mutability.MUTABLE)) {
                this.reportMutabilityViolation(false, anchor);
                if (arg instanceof DfaVariableValue) {
                    memState.forceVariableFact((DfaVariableValue)arg, DfaFactType.MUTABILITY, Mutability.MUTABLE);
                }
            }
            if (argValues == null || paramIndex >= argValues.length - 1 && varargCall) continue;
            argValues[paramIndex] = arg;
        }
        return argValues;
    }

    protected void reportMutabilityViolation(boolean receiver2, @NotNull PsiElement anchor) {
        if (anchor == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(12);
        }
    }

    private DfaValue popQualifier(MethodCallInstruction instruction, DfaMemoryState memState, MutationSignature sig) {
        DfaValue value2 = memState.pop();
        if (instruction.getContext() instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression context = (PsiMethodReferenceExpression)instruction.getContext();
            value2 = this.dereference(memState, value2, NullabilityProblemKind.callMethodRefNPE.problem(context, null));
        }
        if (sig.mutatesThis() && !memState.applyFact(value2, DfaFactType.MUTABILITY, Mutability.MUTABLE)) {
            this.reportMutabilityViolation(true, instruction.getContext());
            if (value2 instanceof DfaVariableValue) {
                memState.forceVariableFact((DfaVariableValue)value2, DfaFactType.MUTABILITY, Mutability.MUTABLE);
            }
        }
        if (value2 instanceof DfaVariableValue && !(value2.getType() instanceof PsiArrayType) && (instruction.shouldFlushFields() || !(instruction.getResultType() instanceof PsiPrimitiveType))) {
            StandardInstructionVisitor.dropLocality(value2, memState);
        }
        return value2;
    }

    private Set<DfaCallState> addContractResults(MethodContract contract, Set<DfaCallState> states, DfaValueFactory factory, Set<DfaMemoryState> finalStates, DfaValue defaultResult, PsiExpression expression2) {
        if (contract.isTrivial()) {
            for (DfaCallState callState : states) {
                DfaValue result = contract.getReturnValue().getDfaValue(factory, defaultResult, callState);
                this.pushExpressionResult(result, () -> expression2, callState.myMemoryState);
                finalStates.add(callState.myMemoryState);
            }
            return Collections.emptySet();
        }
        LinkedHashSet<DfaCallState> falseStates = new LinkedHashSet<DfaCallState>();
        for (DfaCallState callState : states) {
            DfaMemoryState state = callState.myMemoryState;
            DfaCallArguments arguments = callState.myCallArguments;
            for (ContractValue contractValue : contract.getConditions()) {
                DfaValue condition2 = contractValue.makeDfaValue(factory, callState.myCallArguments);
                if (condition2 == null) {
                    condition2 = DfaUnknownValue.getInstance();
                }
                DfaMemoryState falseState = state.createCopy();
                DfaValue falseCondition = condition2.createNegated();
                if (contract.getReturnValue().isFail() ? falseState.applyCondition(falseCondition) : falseState.applyContractCondition(falseCondition)) {
                    DfaCallArguments falseArguments = contractValue.updateArguments(arguments, true);
                    falseStates.add(new DfaCallState(falseState, falseArguments));
                }
                if (!state.applyContractCondition(condition2)) {
                    state = null;
                    break;
                }
                arguments = contractValue.updateArguments(arguments, false);
            }
            if (state == null) continue;
            DfaValue result = contract.getReturnValue().getDfaValue(factory, defaultResult, new DfaCallState(state, arguments));
            this.pushExpressionResult(result, () -> expression2, state);
            finalStates.add(state);
        }
        return falseStates;
    }

    private <T extends PsiElement> DfaValue dereference(DfaMemoryState memState, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<T> problem) {
        boolean ok = this.checkNotNullable(memState, value2, problem);
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).withFact(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
        }
        if (ok) {
            return value2;
        }
        if (memState.isNull(value2) && problem != null && problem.getKind() == NullabilityProblemKind.nullableFunctionReturn) {
            return value2.getFactory().getFactValue(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
        }
        if (value2 instanceof DfaVariableValue) {
            memState.forceVariableFact((DfaVariableValue)value2, DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
        }
        return value2;
    }

    @NotNull
    private static PsiMethod findSpecificMethod(@NotNull PsiMethod method, @NotNull DfaMemoryState state, @Nullable DfaValue qualifier) {
        if (method == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(13);
        }
        if (state == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(14);
        }
        if (qualifier == null || !PsiUtil.canBeOverridden((PsiMethod)method)) {
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(15);
            }
            return psiMethod;
        }
        TypeConstraint constraint = state.getValueFact(qualifier, DfaFactType.TYPE_CONSTRAINT);
        PsiType type2 = constraint == null ? null : constraint.getPsiType();
        PsiMethod psiMethod = MethodUtils.findSpecificMethod(method, type2);
        if (psiMethod == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(16);
        }
        return psiMethod;
    }

    @NotNull
    private static DfaValue getMethodResultValue(MethodCallInstruction instruction, @Nullable DfaValue qualifierValue, DfaMemoryState state, DfaValueFactory factory) {
        PsiMethod method;
        VariableDescriptor descriptor;
        DfaValue precalculated = instruction.getPrecalculatedReturnValue();
        if (precalculated != null) {
            DfaValue dfaValue = precalculated;
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(17);
            }
            return dfaValue;
        }
        PsiType type2 = instruction.getResultType();
        if (instruction.getContext() instanceof PsiMethodReferenceExpression && qualifierValue instanceof DfaVariableValue && (descriptor = DfaExpressionFactory.getAccessedVariableOrGetter((PsiElement)(method = instruction.getTargetMethod()))) != null) {
            DfaValue dfaValue = descriptor.createValue(factory, qualifierValue, true);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(18);
            }
            return dfaValue;
        }
        if (type2 != null && !(type2 instanceof PsiPrimitiveType)) {
            DfaValue value2;
            Nullability nullability = instruction.getReturnNullability();
            PsiMethod targetMethod = instruction.getTargetMethod();
            Mutability mutable = Mutability.UNKNOWN;
            if (targetMethod != null) {
                mutable = Mutability.getMutability((PsiModifierListOwner)targetMethod);
                PsiMethod realMethod = StandardInstructionVisitor.findSpecificMethod(targetMethod, state, qualifierValue);
                if (realMethod != targetMethod) {
                    nullability = DfaPsiUtil.getElementNullability(type2, (PsiModifierListOwner)realMethod);
                    mutable = Mutability.getMutability((PsiModifierListOwner)realMethod);
                    PsiType returnType = realMethod.getReturnType();
                    if (returnType != null && TypeConversionUtil.erasure((PsiType)type2).isAssignableFrom(returnType)) {
                        type2 = returnType;
                    }
                }
                if (nullability == Nullability.UNKNOWN) {
                    nullability = factory.suggestNullabilityForNonAnnotatedMember((PsiModifierListOwner)targetMethod);
                }
            }
            DfaValue dfaValue = value2 = instruction.getContext() instanceof PsiNewExpression ? factory.createExactTypeValue(type2) : factory.createTypeValue(type2, nullability);
            if (!instruction.shouldFlushFields() && instruction.getContext() instanceof PsiNewExpression) {
                value2 = factory.withFact(value2, DfaFactType.LOCALITY, true);
            }
            DfaValue dfaValue2 = factory.withFact(value2, DfaFactType.MUTABILITY, mutable);
            if (dfaValue2 == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(19);
            }
            return dfaValue2;
        }
        LongRangeSet range = LongRangeSet.fromType(type2);
        if (range != null) {
            PsiCall call = instruction.getCallExpression();
            if (call instanceof PsiMethodCallExpression) {
                range = range.intersect(LongRangeSet.fromPsiElement((PsiModifierListOwner)call.resolveMethod()));
            }
            DfaValue dfaValue = factory.getFactValue(DfaFactType.RANGE, range);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(20);
            }
            return dfaValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(21);
        }
        return dfaUnknownValue;
    }

    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        boolean notNullable = state.checkNotNullable(value2);
        if (notNullable && problem != null && problem.thrownException() != null) {
            DfaValueFactory factory = ((DfaMemoryStateImpl)state).getFactory();
            state.applyCondition(factory.createCondition(value2, DfaRelationValue.RelationType.NE, factory.getConstFactory().getNull()));
        }
        return notNullable;
    }

    @Override
    public DfaInstructionState[] visitConvertPrimitive(PrimitiveConversionInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        DfaValue value2 = state.pop();
        DfaValue result = StandardInstructionVisitor.getConversionResult(value2, instruction.getTargetType(), runner.getFactory(), state);
        this.pushExpressionResult(result, instruction, state);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, state);
    }

    private static DfaValue getConversionResult(DfaValue value2, PsiPrimitiveType type2, DfaValueFactory factory, DfaMemoryState state) {
        if (value2 instanceof DfaVariableValue && TypeConversionUtil.isSafeConversion((PsiType)type2, (PsiType)value2.getType())) {
            return value2;
        }
        DfaConstValue constValue = state.getConstantValue(value2);
        if (constValue != null && type2 != null) {
            Object casted = TypeConversionUtil.computeCastTo((Object)constValue.getValue(), (PsiType)type2);
            return factory.getConstFactory().createFromValue(casted, (PsiType)type2);
        }
        if (TypeConversionUtil.isIntegralNumberType((PsiType)type2)) {
            LongRangeSet range = state.getValueFact(value2, DfaFactType.RANGE);
            if (range == null) {
                range = LongRangeSet.all();
            }
            return factory.getFactValue(DfaFactType.RANGE, range.castTo(type2));
        }
        return DfaUnknownValue.getInstance();
    }

    @Override
    public DfaInstructionState[] visitCheckNotNull(CheckNotNullInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        NullabilityProblemKind.NullabilityProblem<?> problem = instruction.getProblem();
        if (problem.thrownException() == null) {
            this.checkNotNullable(memState, memState.peek(), problem);
        } else {
            DfaControlTransferValue transfer = instruction.getOnNullTransfer();
            if (transfer == null) {
                memState.push(this.dereference(memState, memState.pop(), problem));
            } else {
                DfaValue value2 = memState.pop();
                ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>();
                DfaMemoryState nullState = memState.createCopy();
                memState.push(this.dereference(memState, value2, problem));
                result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState));
                DfaValueFactory factory = runner.getFactory();
                if (nullState.applyCondition(factory.createCondition(value2, DfaRelationValue.RelationType.EQ, factory.getConstFactory().getNull()))) {
                    List<DfaInstructionState> dispatched = transfer.dispatch(nullState, runner);
                    for (DfaInstructionState npeState : dispatched) {
                        npeState.getMemoryState().markEphemeral();
                    }
                    result.addAll(dispatched);
                }
                return result.toArray(DfaInstructionState.EMPTY_ARRAY);
            }
        }
        return super.visitCheckNotNull(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitNot(NotInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue = memState.pop();
        DfaMemoryState falseState = memState.createCopy();
        DfaValueFactory factory = runner.getFactory();
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>(2);
        if (memState.applyCondition(dfaValue.createNegated())) {
            this.pushExpressionResult(factory.getBoolean(true), instruction, memState);
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState));
        }
        if (falseState.applyCondition(dfaValue)) {
            this.pushExpressionResult(factory.getBoolean(false), instruction, falseState);
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), falseState));
        }
        return result.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaInstructionState[] states;
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        IElementType opSign = instruction.getOperationSign();
        DfaRelationValue.RelationType relationType = DfaRelationValue.RelationType.fromElementType(opSign);
        if (relationType != null && (states = this.handleRelationBinop(instruction, runner, memState, dfaRight, dfaLeft, relationType)) != null) {
            return states;
        }
        DfaValue result = DfaUnknownValue.getInstance();
        PsiType type2 = instruction.getResultType();
        if (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2)) {
            boolean isLong = PsiType.LONG.equals((Object)type2);
            result = runner.getFactory().getBinOpFactory().create(dfaLeft, dfaRight, memState, isLong, opSign);
        }
        if (result == DfaUnknownValue.getInstance() && JavaTokenType.PLUS == opSign && TypeUtils.isJavaLangString(type2)) {
            result = runner.getFactory().createTypeValue(type2, Nullability.NOT_NULL);
        }
        this.pushExpressionResult(result, instruction, memState);
        instruction.setTrueReachable();
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Nullable
    private DfaInstructionState[] handleRelationBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, DfaRelationValue.RelationType relationType) {
        DfaValueFactory factory = runner.getFactory();
        if (!(relationType != DfaRelationValue.RelationType.EQ && relationType != DfaRelationValue.RelationType.NE || dfaLeft == dfaRight && !(dfaLeft instanceof DfaBoxedValue) && !(dfaLeft instanceof DfaConstValue) || !StandardInstructionVisitor.isComparedByEquals(instruction.getExpression()) || memState.isNull(dfaLeft) || memState.isNull(dfaRight))) {
            ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
            DfaMemoryState equality = memState.createCopy();
            if (equality.applyCondition(factory.createCondition(dfaLeft, DfaRelationValue.RelationType.EQ, dfaRight))) {
                states.add(this.makeBooleanResult(instruction, runner, equality, ThreeState.UNSURE));
            }
            if (memState.applyCondition(factory.createCondition(dfaLeft, DfaRelationValue.RelationType.NE, dfaRight))) {
                states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.fromBoolean((relationType == DfaRelationValue.RelationType.NE ? 1 : 0) != 0)));
            }
            return states.toArray(DfaInstructionState.EMPTY_ARRAY);
        }
        DfaRelationValue.RelationType[] relations = StandardInstructionVisitor.splitRelation(relationType);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(relations.length);
        for (int i = 0; i < relations.length; ++i) {
            DfaMemoryState copy;
            DfaRelationValue.RelationType relation = relations[i];
            DfaValue condition2 = factory.createCondition(dfaLeft, relation, dfaRight);
            if (condition2 instanceof DfaUnknownValue) {
                return null;
            }
            if (condition2 instanceof DfaConstValue) {
                Object value2 = ((DfaConstValue)condition2).getValue();
                if (Boolean.FALSE.equals(value2)) continue;
                if (Boolean.TRUE.equals(value2)) {
                    DfaInstructionState state = this.makeBooleanResult(instruction, runner, memState, ThreeState.fromBoolean((boolean)relationType.isSubRelation(relation)));
                    return new DfaInstructionState[]{state};
                }
            }
            DfaMemoryState dfaMemoryState = copy = i == relations.length - 1 && !states.isEmpty() ? memState : memState.createCopy();
            if (!copy.applyCondition(condition2)) continue;
            boolean isTrue = relationType.isSubRelation(relation);
            states.add(this.makeBooleanResult(instruction, runner, copy, ThreeState.fromBoolean((boolean)isTrue)));
        }
        if (states.isEmpty()) {
            memState.push(factory.getConstFactory().getFalse());
            return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
        }
        return states.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    private static boolean isComparedByEquals(PsiExpression expression2) {
        if (expression2 instanceof PsiBinaryExpression) {
            PsiExpression left = ((PsiBinaryExpression)expression2).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)expression2).getROperand();
            return right != null && DfaUtil.isComparedByEquals(left.getType()) && DfaUtil.isComparedByEquals(right.getType());
        }
        return false;
    }

    @NotNull
    private static DfaRelationValue.RelationType[] splitRelation(DfaRelationValue.RelationType relationType) {
        switch (relationType) {
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                DfaRelationValue.RelationType[] relationTypeArray = new DfaRelationValue.RelationType[]{DfaRelationValue.RelationType.LT, DfaRelationValue.RelationType.GT, DfaRelationValue.RelationType.EQ};
                if (relationTypeArray == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(22);
                }
                return relationTypeArray;
            }
        }
        DfaRelationValue.RelationType[] relationTypeArray = new DfaRelationValue.RelationType[]{relationType, relationType.getNegated()};
        if (relationTypeArray == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(23);
        }
        return relationTypeArray;
    }

    @Override
    public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        boolean useful;
        this.myReachable.add(instruction);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        DfaValueFactory factory = runner.getFactory();
        if (!memState.isNotNull(dfaLeft)) {
            this.myCanBeNullInInstanceof.add(instruction);
        }
        boolean unknownTargetType = false;
        DfaValue condition2 = null;
        if (instruction.isClassObjectCheck()) {
            PsiType type2;
            DfaConstValue constant = memState.getConstantValue(dfaRight);
            PsiType psiType = type2 = constant == null ? null : (PsiType)ObjectUtils.tryCast((Object)constant.getValue(), PsiType.class);
            if (type2 == null || type2 instanceof PsiPrimitiveType) {
                DfaConstValue aNull = factory.getConstFactory().getNull();
                condition2 = factory.createCondition(dfaLeft, DfaRelationValue.RelationType.NE, aNull);
                unknownTargetType = true;
            } else {
                dfaRight = factory.createTypeValue(type2, Nullability.NOT_NULL);
            }
        }
        if (condition2 == null) {
            condition2 = factory.createCondition(dfaLeft, DfaRelationValue.RelationType.IS, dfaRight);
        }
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
        if (condition2 instanceof DfaUnknownValue) {
            if (dfaLeft instanceof DfaFactMapValue && dfaRight instanceof DfaFactMapValue) {
                DfaFactMapValue left = (DfaFactMapValue)dfaLeft;
                DfaFactMapValue right = (DfaFactMapValue)dfaRight;
                useful = !right.getFacts().with(DfaFactType.NULLABILITY, null).isSuperStateOf(left.getFacts());
            } else {
                useful = true;
            }
            states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.UNSURE));
        } else {
            DfaMemoryState trueState = memState.createCopy();
            useful = unknownTargetType;
            if (trueState.applyCondition(condition2)) {
                states.add(this.makeBooleanResult(instruction, runner, trueState, unknownTargetType ? ThreeState.UNSURE : ThreeState.YES));
            }
            if (memState.applyCondition(condition2.createNegated())) {
                if (unknownTargetType) {
                    memState.markEphemeral();
                }
                states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.NO));
                useful |= !memState.isNull(dfaLeft);
            }
        }
        if (useful) {
            this.myUsefulInstanceofs.add(instruction);
        }
        return states.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    private DfaInstructionState makeBooleanResult(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, @NotNull ThreeState result) {
        if (result == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(24);
        }
        DfaUnknownValue value2 = result == ThreeState.UNSURE ? DfaUnknownValue.getInstance() : runner.getFactory().getBoolean(result.toBoolean());
        this.pushExpressionResult(value2, instruction, memState);
        if (result != ThreeState.NO) {
            instruction.setTrueReachable();
        }
        if (result != ThreeState.YES) {
            instruction.setFalseReachable();
        }
        return new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        return !this.myUsefulInstanceofs.contains(instruction) && !instruction.isConditionConst() && this.myReachable.contains(instruction);
    }

    public boolean canBeNull(InstanceofInstruction instruction) {
        return this.myCanBeNullInInstanceof.contains(instruction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodReferenceCallArguments";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "handleKnownMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "popCall";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findSpecificMethod";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodResultValue";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "splitRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeMethodCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportMutabilityViolation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSpecificMethod";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "makeBooleanResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

