/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.dataFlow.DataFlowInstructionVisitor;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class NullabilityProblemKind<T extends PsiElement> {
    private static final String NPE = "java.lang.NullPointerException";
    private static final String RE = "java.lang.RuntimeException";
    private final String myName;
    private final String myAlwaysNullMessage;
    private final String myNormalMessage;
    @Nullable
    private final String myException;
    public static final NullabilityProblemKind<PsiMethodCallExpression> callNPE = new NullabilityProblemKind("java.lang.NullPointerException", "callNPE", "dataflow.message.npe.method.invocation.sure", "dataflow.message.npe.method.invocation");
    public static final NullabilityProblemKind<PsiMethodReferenceExpression> callMethodRefNPE = new NullabilityProblemKind("java.lang.NullPointerException", "callMethodRefNPE", "dataflow.message.npe.methodref.invocation");
    public static final NullabilityProblemKind<PsiNewExpression> innerClassNPE = new NullabilityProblemKind("java.lang.NullPointerException", "innerClassNPE", "dataflow.message.npe.inner.class.construction.sure", "dataflow.message.npe.inner.class.construction");
    public static final NullabilityProblemKind<PsiExpression> fieldAccessNPE = new NullabilityProblemKind("java.lang.NullPointerException", "fieldAccessNPE", "dataflow.message.npe.field.access.sure", "dataflow.message.npe.field.access");
    public static final NullabilityProblemKind<PsiArrayAccessExpression> arrayAccessNPE = new NullabilityProblemKind("java.lang.NullPointerException", "arrayAccessNPE", "dataflow.message.npe.array.access.sure", "dataflow.message.npe.array.access");
    public static final NullabilityProblemKind<PsiElement> unboxingNullable = new NullabilityProblemKind("java.lang.NullPointerException", "unboxingNullable", "dataflow.message.unboxing");
    public static final NullabilityProblemKind<PsiExpression> assigningToNotNull = new NullabilityProblemKind(null, "assigningToNotNull", "dataflow.message.assigning.null", "dataflow.message.assigning.nullable");
    public static final NullabilityProblemKind<PsiExpression> assigningToNonAnnotatedField = new NullabilityProblemKind(null, "assigningToNonAnnotatedField", "dataflow.message.assigning.null.notannotated", "dataflow.message.assigning.nullable.notannotated");
    public static final NullabilityProblemKind<PsiExpression> storingToNotNullArray = new NullabilityProblemKind(null, "storingToNotNullArray", "dataflow.message.storing.array.null", "dataflow.message.storing.array.nullable");
    public static final NullabilityProblemKind<PsiExpression> nullableReturn = new NullabilityProblemKind(null, "nullableReturn");
    public static final NullabilityProblemKind<PsiExpression> nullableFunctionReturn = new NullabilityProblemKind("java.lang.RuntimeException", "nullableFunctionReturn", "dataflow.message.return.nullable.from.notnull.function", "dataflow.message.return.nullable.from.notnull.function");
    public static final NullabilityProblemKind<PsiExpression> passingToNotNullParameter = new NullabilityProblemKind("java.lang.RuntimeException", "passingToNotNullParameter", "dataflow.message.passing.null.argument", "dataflow.message.passing.nullable.argument");
    public static final NullabilityProblemKind<PsiMethodReferenceExpression> passingToNotNullMethodRefParameter = new NullabilityProblemKind("java.lang.RuntimeException", "passingToNotNullMethodRefParameter", "dataflow.message.passing.nullable.argument.methodref");
    public static final NullabilityProblemKind<PsiExpression> passingToNonAnnotatedParameter = new NullabilityProblemKind(null, "passingToNonAnnotatedParameter", "dataflow.message.passing.null.argument.nonannotated", "dataflow.message.passing.nullable.argument.nonannotated");
    public static final NullabilityProblemKind<PsiMethodReferenceExpression> passingToNonAnnotatedMethodRefParameter = new NullabilityProblemKind(null, "passingToNonAnnotatedMethodRefParameter", "dataflow.message.passing.nullable.argument.methodref.nonannotated");
    public static final NullabilityProblemKind<PsiExpression> assumeNotNull = new NullabilityProblemKind("java.lang.RuntimeException", "assumeNotNull");
    public static final NullabilityProblemKind<PsiExpression> noProblem = new NullabilityProblemKind(null, "noProblem");

    private NullabilityProblemKind(@Nullable String exception, @NotNull String name) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(0);
        }
        this.myException = exception;
        this.myName = name;
        this.myAlwaysNullMessage = null;
        this.myNormalMessage = null;
    }

    private NullabilityProblemKind(@Nullable String exception, @NotNull String name, @NotNull @PropertyKey(resourceBundle="messages.InspectionsBundle") String message2) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(1);
        }
        if (message2 == null) {
            NullabilityProblemKind.$$$reportNull$$$0(2);
        }
        this(exception, name, message2, message2);
    }

    private NullabilityProblemKind(@Nullable String exception, @NotNull String name, @NotNull @PropertyKey(resourceBundle="messages.InspectionsBundle") String alwaysNullMessage, @NotNull @PropertyKey(resourceBundle="messages.InspectionsBundle") String normalMessage) {
        if (name == null) {
            NullabilityProblemKind.$$$reportNull$$$0(3);
        }
        if (alwaysNullMessage == null) {
            NullabilityProblemKind.$$$reportNull$$$0(4);
        }
        if (normalMessage == null) {
            NullabilityProblemKind.$$$reportNull$$$0(5);
        }
        this.myException = exception;
        this.myName = name;
        this.myAlwaysNullMessage = InspectionsBundle.message((String)alwaysNullMessage, (Object[])new Object[0]);
        this.myNormalMessage = InspectionsBundle.message((String)normalMessage, (Object[])new Object[0]);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public final NullabilityProblem<T> problem(@Nullable T anchor, @Nullable PsiExpression expression2) {
        return anchor == null || this == noProblem ? null : new NullabilityProblem<T>(this, anchor, expression2);
    }

    @Nullable
    public final NullabilityProblem<T> asMyProblem(NullabilityProblem<?> problem) {
        return problem != null && ((NullabilityProblem)problem).myKind == this ? problem : null;
    }

    public void ifMyProblem(NullabilityProblem<?> problem, Consumer<? super T> consumer) {
        NullabilityProblem<T> myProblem = this.asMyProblem(problem);
        if (myProblem != null) {
            consumer.accept(myProblem.getAnchor());
        }
    }

    public String toString() {
        return this.myName;
    }

    @Nullable
    static NullabilityProblem<?> fromContext(@NotNull PsiExpression expression2, Map<PsiExpression, NullabilityProblemKind<? super PsiExpression>> customNullabilityProblems) {
        if (expression2 == null) {
            NullabilityProblemKind.$$$reportNull$$$0(6);
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expression2.getType()) || expression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).resolve() instanceof PsiClass) {
            return null;
        }
        PsiExpression context = NullabilityProblemKind.findTopExpression(expression2);
        NullabilityProblemKind<? super PsiExpression> kind2 = customNullabilityProblems.get(context);
        if (kind2 != null) {
            return kind2.problem((PsiExpression)context, expression2);
        }
        PsiElement parent = context.getParent();
        if (parent instanceof PsiReferenceExpression) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                return callNPE.problem((PsiMethodCallExpression)grandParent, expression2);
            }
            return fieldAccessNPE.problem(context, expression2);
        }
        PsiType targetType = null;
        if (parent instanceof PsiLambdaExpression) {
            targetType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)parent));
        } else if (parent instanceof PsiReturnStatement) {
            targetType = PsiTypesUtil.getMethodReturnType((PsiElement)parent);
        }
        if (targetType != null && !PsiType.VOID.equals((Object)targetType)) {
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)targetType)) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression2);
            }
            return nullableReturn.problem(context, expression2);
        }
        if (parent instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)parent;
            if (var.getType() instanceof PsiPrimitiveType) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression2);
            }
            Nullability nullability = DfaPsiUtil.getElementNullability(var.getType(), (PsiModifierListOwner)var);
            if (nullability == Nullability.NOT_NULL) {
                return assigningToNotNull.problem(context, expression2);
            }
        }
        if (parent instanceof PsiAssignmentExpression) {
            return NullabilityProblemKind.getAssignmentProblem((PsiAssignmentExpression)parent, expression2, context);
        }
        if (parent instanceof PsiExpressionList) {
            return NullabilityProblemKind.getExpressionListProblem((PsiExpressionList)parent, expression2, context);
        }
        if (parent instanceof PsiArrayInitializerExpression) {
            return NullabilityProblemKind.getArrayInitializerProblem((PsiArrayInitializerExpression)parent, expression2, context);
        }
        if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiDoWhileStatement || parent instanceof PsiUnaryExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiTypeCastExpression || parent instanceof PsiForStatement && ((PsiForStatement)parent).getCondition() == context || parent instanceof PsiAssertStatement && ((PsiAssertStatement)parent).getAssertCondition() == context) {
            return NullabilityProblemKind.createUnboxingProblem(context, expression2);
        }
        if (parent instanceof PsiSwitchBlock) {
            NullabilityProblem<PsiElement> problem = NullabilityProblemKind.createUnboxingProblem(context, expression2);
            return problem == null ? fieldAccessNPE.problem(context, expression2) : problem;
        }
        if (parent instanceof PsiForeachStatement || parent instanceof PsiThrowStatement || parent instanceof PsiSynchronizedStatement) {
            return fieldAccessNPE.problem(context, expression2);
        }
        if (parent instanceof PsiNewExpression) {
            return innerClassNPE.problem((PsiNewExpression)parent, expression2);
        }
        if (parent instanceof PsiPolyadicExpression) {
            boolean noUnboxing;
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            IElementType type2 = polyadic.getOperationTokenType();
            boolean bl = noUnboxing = type2 == JavaTokenType.PLUS && TypeUtils.isJavaLangString(polyadic.getType()) || (type2 == JavaTokenType.EQEQ || type2 == JavaTokenType.NE) && StreamEx.of((Object[])polyadic.getOperands()).noneMatch(op -> TypeConversionUtil.isPrimitiveAndNotNull((PsiType)op.getType()));
            if (!noUnboxing) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression2);
            }
        }
        if (parent instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
            if (arrayAccessExpression.getArrayExpression() == context) {
                return arrayAccessNPE.problem(arrayAccessExpression, expression2);
            }
            return NullabilityProblemKind.createUnboxingProblem(context, expression2);
        }
        return null;
    }

    @Nullable
    private static NullabilityProblem<?> getExpressionListProblem(@NotNull PsiExpressionList expressionList, @NotNull PsiExpression expression2, @NotNull PsiExpression context) {
        if (expressionList == null) {
            NullabilityProblemKind.$$$reportNull$$$0(7);
        }
        if (expression2 == null) {
            NullabilityProblemKind.$$$reportNull$$$0(8);
        }
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(9);
        }
        if (expressionList.getParent() instanceof PsiSwitchLabelStatementBase) {
            return fieldAccessNPE.problem(context, expression2);
        }
        PsiParameter parameter2 = MethodCallUtils.getParameterForArgument(context);
        if (parameter2 != null) {
            if (parameter2.getType() instanceof PsiPrimitiveType) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression2);
            }
            PsiElement grandParent = expressionList.getParent();
            if (grandParent instanceof PsiAnonymousClass) {
                grandParent = grandParent.getParent();
            }
            if (grandParent instanceof PsiCall) {
                PsiSubstitutor substitutor = ((PsiCall)grandParent).resolveMethodGenerics().getSubstitutor();
                Nullability nullability = DfaPsiUtil.getElementNullability(substitutor.substitute(parameter2.getType()), (PsiModifierListOwner)parameter2);
                if (nullability == Nullability.NOT_NULL) {
                    return passingToNotNullParameter.problem(context, expression2);
                }
                if (nullability == Nullability.UNKNOWN) {
                    return passingToNonAnnotatedParameter.problem(context, expression2);
                }
            }
        }
        return null;
    }

    @Nullable
    private static NullabilityProblem<?> getArrayInitializerProblem(@NotNull PsiArrayInitializerExpression initializer, @NotNull PsiExpression expression2, @NotNull PsiExpression context) {
        PsiType type2;
        if (initializer == null) {
            NullabilityProblemKind.$$$reportNull$$$0(10);
        }
        if (expression2 == null) {
            NullabilityProblemKind.$$$reportNull$$$0(11);
        }
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(12);
        }
        if ((type2 = initializer.getType()) instanceof PsiArrayType) {
            PsiType expectedType;
            PsiType componentType = ((PsiArrayType)type2).getComponentType();
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)componentType)) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression2);
            }
            Nullability nullability = DfaPsiUtil.getTypeNullability(componentType);
            if (nullability == Nullability.UNKNOWN && initializer.getParent() instanceof PsiNewExpression && (expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)initializer.getParent(), false)) instanceof PsiArrayType) {
                nullability = DfaPsiUtil.getTypeNullability(((PsiArrayType)expectedType).getComponentType());
            }
            if (nullability == Nullability.NOT_NULL) {
                return storingToNotNullArray.problem(context, expression2);
            }
        }
        return null;
    }

    @Nullable
    private static NullabilityProblem<?> getAssignmentProblem(@NotNull PsiAssignmentExpression assignment, @NotNull PsiExpression expression2, @NotNull PsiExpression context) {
        PsiExpression lho;
        if (assignment == null) {
            NullabilityProblemKind.$$$reportNull$$$0(13);
        }
        if (expression2 == null) {
            NullabilityProblemKind.$$$reportNull$$$0(14);
        }
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(15);
        }
        IElementType tokenType = assignment.getOperationTokenType();
        if (assignment.getRExpression() == context && (lho = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression())) != null) {
            PsiField field;
            boolean forceDeclaredNullity;
            PsiType type2 = lho.getType();
            if (tokenType.equals(JavaTokenType.PLUSEQ) && TypeUtils.isJavaLangString(type2)) {
                return null;
            }
            if (type2 instanceof PsiPrimitiveType) {
                return NullabilityProblemKind.createUnboxingProblem(context, expression2);
            }
            Nullability nullability = Nullability.UNKNOWN;
            PsiVariable target = null;
            if (lho instanceof PsiReferenceExpression) {
                target = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)lho).resolve(), PsiVariable.class);
                if (target != null) {
                    nullability = DfaPsiUtil.getElementNullability(type2, (PsiModifierListOwner)target);
                }
            } else {
                nullability = DfaPsiUtil.getTypeNullability(type2);
            }
            boolean bl = forceDeclaredNullity = !(target instanceof PsiParameter) || !(target.getParent() instanceof PsiParameterList);
            if (forceDeclaredNullity && nullability == Nullability.NOT_NULL) {
                return (lho instanceof PsiArrayAccessExpression ? storingToNotNullArray : assigningToNotNull).problem(context, expression2);
            }
            if (nullability == Nullability.UNKNOWN && lho instanceof PsiReferenceExpression && (field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)lho).resolve(), PsiField.class)) != null && !field.hasModifierProperty("final")) {
                return assigningToNonAnnotatedField.problem(context, expression2);
            }
        }
        return null;
    }

    @NotNull
    static PsiExpression findTopExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            NullabilityProblemKind.$$$reportNull$$$0(16);
        }
        PsiExpression context = expression2;
        while (true) {
            PsiElement exitedElement;
            PsiSwitchBlock block;
            PsiElement grandParent;
            PsiElement parent;
            if ((parent = context.getParent()) instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != context) {
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)((PsiExpression)parent).getType())) {
                    PsiExpression psiExpression = context;
                    if (psiExpression == null) {
                        NullabilityProblemKind.$$$reportNull$$$0(17);
                    }
                    return psiExpression;
                }
                context = (PsiExpression)parent;
                continue;
            }
            if (parent instanceof PsiExpressionStatement && (grandParent = parent.getParent()) instanceof PsiSwitchLabeledRuleStatement && (block = ((PsiSwitchLabeledRuleStatement)grandParent).getEnclosingSwitchBlock()) instanceof PsiSwitchExpression) {
                context = (PsiExpression)block;
                continue;
            }
            if (!(parent instanceof PsiBreakStatement) || !((exitedElement = ((PsiBreakStatement)parent).findExitedElement()) instanceof PsiSwitchExpression)) break;
            context = (PsiExpression)exitedElement;
        }
        PsiExpression psiExpression = context;
        if (psiExpression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(18);
        }
        return psiExpression;
    }

    private static NullabilityProblem<PsiElement> createUnboxingProblem(@NotNull PsiExpression context, @NotNull PsiExpression expression2) {
        if (context == null) {
            NullabilityProblemKind.$$$reportNull$$$0(19);
        }
        if (expression2 == null) {
            NullabilityProblemKind.$$$reportNull$$$0(20);
        }
        if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)context.getType())) {
            return null;
        }
        return unboxingNullable.problem((PsiElement)context, expression2);
    }

    static List<NullabilityProblem<?>> postprocessNullabilityProblems(Collection<NullabilityProblem<?>> problems) {
        ArrayList unchanged = new ArrayList();
        HashMap expressionToProblem = new HashMap();
        for (NullabilityProblem<?> problem : problems) {
            PsiExpression top;
            PsiConditionalExpression ternary;
            PsiExpression expression2 = problem.getDereferencedExpression();
            NullabilityProblemKind<?> kind2 = problem.getKind();
            if (expression2 == null) {
                unchanged.add(problem);
                continue;
            }
            if (innerClassNPE == kind2 || callNPE == kind2 || arrayAccessNPE == kind2 || fieldAccessNPE == kind2) {
                unchanged.add(problem.withExpression(NullabilityProblemKind.findTopExpression(expression2)));
                continue;
            }
            while ((ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)(top = NullabilityProblemKind.skipParenthesesAndObjectCastsUp(expression2)).getParent(), PsiConditionalExpression.class)) != null) {
                NullabilityProblem otherBranchProblem;
                PsiExpression otherBranch = null;
                if (ternary.getThenExpression() == top) {
                    otherBranch = ternary.getElseExpression();
                } else if (ternary.getElseExpression() == top) {
                    otherBranch = ternary.getThenExpression();
                }
                if (otherBranch == null || (otherBranchProblem = (NullabilityProblem)expressionToProblem.remove(otherBranch = NullabilityProblemKind.skipParenthesesAndObjectCastsDown(otherBranch))) == null) break;
                expression2 = ternary;
                problem = problem.withExpression((PsiExpression)ternary);
            }
            expressionToProblem.put(expression2, problem);
        }
        return StreamEx.of((Object[])new Collection[]{unchanged, expressionToProblem.values()}).toFlatList(Function.identity());
    }

    private static PsiExpression skipParenthesesAndObjectCastsDown(PsiExpression expression2) {
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiTypeCastExpression) || expression2.getType() instanceof PsiPrimitiveType) break;
            expression2 = ((PsiTypeCastExpression)expression2).getOperand();
        }
        return expression2;
    }

    @NotNull
    private static PsiExpression skipParenthesesAndObjectCastsUp(PsiExpression expression2) {
        PsiElement parent;
        PsiExpression top = expression2;
        while ((parent = top.getParent()) instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression && !(((PsiTypeCastExpression)parent).getType() instanceof PsiPrimitiveType)) {
            top = (PsiExpression)parent;
        }
        PsiExpression psiExpression = top;
        if (psiExpression == null) {
            NullabilityProblemKind.$$$reportNull$$$0(21);
        }
        return psiExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alwaysNullMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalMessage";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopExpression";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "skipParenthesesAndObjectCastsUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionListProblem";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getArrayInitializerProblem";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentProblem";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findTopExpression";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createUnboxingProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class NullabilityProblem<T extends PsiElement> {
        @NotNull
        private final NullabilityProblemKind<T> myKind;
        @NotNull
        private final T myAnchor;
        @Nullable
        private final PsiExpression myDereferencedExpression;

        NullabilityProblem(@NotNull NullabilityProblemKind<T> kind2, @NotNull T anchor, @Nullable PsiExpression dereferencedExpression) {
            if (kind2 == null) {
                NullabilityProblem.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                NullabilityProblem.$$$reportNull$$$0(1);
            }
            this.myKind = kind2;
            this.myAnchor = anchor;
            this.myDereferencedExpression = dereferencedExpression;
        }

        @NotNull
        public T getAnchor() {
            T t = this.myAnchor;
            if (t == null) {
                NullabilityProblem.$$$reportNull$$$0(2);
            }
            return t;
        }

        @Nullable
        public String thrownException() {
            return ((NullabilityProblemKind)this.myKind).myException;
        }

        @Nullable
        public PsiExpression getDereferencedExpression() {
            return this.myDereferencedExpression;
        }

        @NotNull
        public String getMessage(Map<PsiExpression, DataFlowInstructionVisitor.ConstantResult> expressions2) {
            if (((NullabilityProblemKind)this.myKind).myAlwaysNullMessage == null || ((NullabilityProblemKind)this.myKind).myNormalMessage == null) {
                throw new IllegalStateException("This problem kind has no message associated: " + this.myKind);
            }
            PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)this.getDereferencedExpression());
            if (expression2 != null && (ExpressionUtils.isNullLiteral(expression2) || expressions2.get(expression2) == DataFlowInstructionVisitor.ConstantResult.NULL)) {
                String string = ((NullabilityProblemKind)this.myKind).myAlwaysNullMessage;
                if (string == null) {
                    NullabilityProblem.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = ((NullabilityProblemKind)this.myKind).myNormalMessage;
            if (string == null) {
                NullabilityProblem.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public NullabilityProblemKind<T> getKind() {
            NullabilityProblemKind<T> nullabilityProblemKind = this.myKind;
            if (nullabilityProblemKind == null) {
                NullabilityProblem.$$$reportNull$$$0(5);
            }
            return nullabilityProblemKind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NullabilityProblem)) {
                return false;
            }
            NullabilityProblem problem = (NullabilityProblem)o;
            return this.myKind.equals(problem.myKind) && this.myAnchor.equals(problem.myAnchor) && Objects.equals(this.myDereferencedExpression, problem.myDereferencedExpression);
        }

        public int hashCode() {
            return Objects.hash(this.myKind, this.myAnchor, this.myDereferencedExpression);
        }

        public String toString() {
            return "[" + this.myKind + "] " + this.myAnchor.getText();
        }

        public NullabilityProblem<T> withExpression(PsiExpression expression2) {
            return expression2 == this.myDereferencedExpression ? this : new NullabilityProblem<T>(this.myKind, this.myAnchor, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind$NullabilityProblem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullabilityProblemKind$NullabilityProblem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

