/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DfaNullability {
    NULL("Null", "null", Nullability.NULLABLE),
    NULLABLE("Nullable", "nullable", Nullability.NULLABLE),
    NOT_NULL("Not-null", "non-null", Nullability.NOT_NULL),
    UNKNOWN("Unknown", "", Nullability.UNKNOWN),
    FLUSHED("Flushed", "", Nullability.UNKNOWN);

    @NotNull
    private final String myInternalName;
    @NotNull
    private final String myPresentationalName;
    @NotNull
    private final Nullability myNullability;

    private DfaNullability(@NotNull String internalName, String presentationalName, Nullability nullability) {
        if (internalName == null) {
            DfaNullability.$$$reportNull$$$0(0);
        }
        if (presentationalName == null) {
            DfaNullability.$$$reportNull$$$0(1);
        }
        if (nullability == null) {
            DfaNullability.$$$reportNull$$$0(2);
        }
        this.myInternalName = internalName;
        this.myPresentationalName = presentationalName;
        this.myNullability = nullability;
    }

    @NotNull
    public String getInternalName() {
        String string = this.myInternalName;
        if (string == null) {
            DfaNullability.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentationName() {
        String string = this.myPresentationalName;
        if (string == null) {
            DfaNullability.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isNullable(DfaFactMap map2) {
        return DfaNullability.toNullability(map2.get(DfaFactType.NULLABILITY)) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(DfaFactMap map2) {
        return map2.get(DfaFactType.NULLABILITY) == NOT_NULL;
    }

    @NotNull
    public static Nullability toNullability(@Nullable DfaNullability dfaNullability) {
        Nullability nullability = dfaNullability == null ? Nullability.UNKNOWN : dfaNullability.myNullability;
        if (nullability == null) {
            DfaNullability.$$$reportNull$$$0(5);
        }
        return nullability;
    }

    @NotNull
    public static DfaNullability fromNullability(@NotNull Nullability nullability) {
        if (nullability == null) {
            DfaNullability.$$$reportNull$$$0(6);
        }
        switch (nullability) {
            case NOT_NULL: {
                DfaNullability dfaNullability = NOT_NULL;
                if (dfaNullability == null) {
                    DfaNullability.$$$reportNull$$$0(7);
                }
                return dfaNullability;
            }
            case NULLABLE: {
                DfaNullability dfaNullability = NULLABLE;
                if (dfaNullability == null) {
                    DfaNullability.$$$reportNull$$$0(8);
                }
                return dfaNullability;
            }
            case UNKNOWN: {
                DfaNullability dfaNullability = UNKNOWN;
                if (dfaNullability == null) {
                    DfaNullability.$$$reportNull$$$0(9);
                }
                return dfaNullability;
            }
        }
        throw new IllegalStateException("Unknown nullability: " + nullability);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationalName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaNullability";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toNullability";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromNullability";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

