/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.SpecialFieldValue;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaFactType<T>
extends Key<T> {
    private static final List<DfaFactType<?>> ourFactTypes = new ArrayList();
    public static final DfaFactType<DfaNullability> NULLABILITY = new DfaFactType<DfaNullability>("Nullability"){

        @Override
        @NotNull
        public String toString(@NotNull DfaNullability fact) {
            if (fact == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = fact.getInternalName();
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        boolean isUnknown(@NotNull DfaNullability fact) {
            if (fact == null) {
                1.$$$reportNull$$$0(2);
            }
            return fact == DfaNullability.UNKNOWN;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull DfaNullability fact, @Nullable PsiType type2) {
            if (fact == null) {
                1.$$$reportNull$$$0(3);
            }
            if (type2 instanceof PsiPrimitiveType) {
                if ("" == null) {
                    1.$$$reportNull$$$0(4);
                }
                return "";
            }
            String string = fact.getPresentationName();
            if (string == null) {
                1.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        boolean isSuper(@Nullable DfaNullability superFact, @Nullable DfaNullability subFact) {
            return superFact == null && (subFact == DfaNullability.NOT_NULL || subFact == DfaNullability.FLUSHED) || super.isSuper(superFact, subFact);
        }

        @Override
        @NotNull
        DfaNullability uniteFacts(@NotNull DfaNullability left, @NotNull DfaNullability right) {
            if (left == null) {
                1.$$$reportNull$$$0(6);
            }
            if (right == null) {
                1.$$$reportNull$$$0(7);
            }
            if (left == right) {
                DfaNullability dfaNullability = left;
                if (dfaNullability == null) {
                    1.$$$reportNull$$$0(8);
                }
                return dfaNullability;
            }
            if (left == DfaNullability.NULL || right == DfaNullability.NULL) {
                DfaNullability dfaNullability = DfaNullability.UNKNOWN;
                if (dfaNullability == null) {
                    1.$$$reportNull$$$0(9);
                }
                return dfaNullability;
            }
            DfaNullability dfaNullability = DfaNullability.FLUSHED;
            if (dfaNullability == null) {
                1.$$$reportNull$$$0(10);
            }
            return dfaNullability;
        }

        @Override
        @Nullable
        DfaNullability intersectFacts(@NotNull DfaNullability left, @NotNull DfaNullability right) {
            if (left == null) {
                1.$$$reportNull$$$0(11);
            }
            if (right == null) {
                1.$$$reportNull$$$0(12);
            }
            if (left == DfaNullability.NOT_NULL || right == DfaNullability.NOT_NULL) {
                return DfaNullability.NOT_NULL;
            }
            if (left == DfaNullability.FLUSHED && DfaNullability.toNullability(right) == Nullability.NULLABLE || right == DfaNullability.FLUSHED && DfaNullability.toNullability(left) == Nullability.NULLABLE) {
                return DfaNullability.NULLABLE;
            }
            return super.intersectFacts(left, right);
        }

        @Override
        @Nullable
        public DfaNullability fromDfaValue(DfaValue value2) {
            if (value2 instanceof DfaConstValue) {
                return ((DfaConstValue)value2).getValue() == null ? DfaNullability.NULL : DfaNullability.NOT_NULL;
            }
            if (value2 instanceof DfaBoxedValue) {
                return DfaNullability.NOT_NULL;
            }
            if (value2 instanceof DfaFactMapValue && ((DfaFactMapValue)value2).get(RANGE) != null) {
                return DfaNullability.NOT_NULL;
            }
            return (DfaNullability)((Object)super.fromDfaValue(value2));
        }

        @Override
        @Nullable
        DfaNullability calcFromVariable(@NotNull DfaVariableValue value2) {
            if (value2 == null) {
                1.$$$reportNull$$$0(13);
            }
            return NullabilityUtil.calcCanBeNull(value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$1";
                    break;
                }
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteFacts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteFacts";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectFacts";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "calcFromVariable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<Mutability> MUTABILITY = new DfaFactType<Mutability>("Mutability"){

        @Override
        boolean isUnknown(@NotNull Mutability fact) {
            if (fact == null) {
                2.$$$reportNull$$$0(0);
            }
            return fact == Mutability.UNKNOWN;
        }

        @Override
        @NotNull
        Mutability uniteFacts(@NotNull Mutability left, @NotNull Mutability right) {
            if (left == null) {
                2.$$$reportNull$$$0(1);
            }
            if (right == null) {
                2.$$$reportNull$$$0(2);
            }
            Mutability mutability = left.unite(right);
            if (mutability == null) {
                2.$$$reportNull$$$0(3);
            }
            return mutability;
        }

        @Override
        @NotNull
        Mutability calcFromVariable(@NotNull DfaVariableValue value2) {
            PsiModifierListOwner variable;
            if (value2 == null) {
                2.$$$reportNull$$$0(4);
            }
            Mutability mutability = (variable = value2.getPsiVariable()) == null ? Mutability.UNKNOWN : Mutability.getMutability(variable);
            if (mutability == null) {
                2.$$$reportNull$$$0(5);
            }
            return mutability;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteFacts";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcFromVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteFacts";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcFromVariable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<LongRangeSet> RANGE = new DfaFactType<LongRangeSet>("Range"){

        @Override
        boolean isSuper(@Nullable LongRangeSet superFact, @Nullable LongRangeSet subFact) {
            return superFact == null || subFact != null && superFact.contains(subFact);
        }

        @Override
        boolean isUnknown(@NotNull LongRangeSet fact) {
            if (fact == null) {
                3.$$$reportNull$$$0(0);
            }
            return LongRangeSet.all().equals(fact);
        }

        @Override
        @Nullable
        public LongRangeSet fromDfaValue(DfaValue value2) {
            if (value2 instanceof DfaVariableValue) {
                return this.calcFromVariable((DfaVariableValue)value2);
            }
            if (value2 instanceof DfaBinOpValue) {
                DfaBinOpValue binOp = (DfaBinOpValue)value2;
                LongRangeSet left = this.fromDfaValue(binOp.getLeft());
                LongRangeSet right = this.fromDfaValue(binOp.getRight());
                if (left != null && right != null) {
                    return left.binOpFromToken(binOp.getTokenType(), right, PsiType.LONG.equals((Object)binOp.getType()));
                }
            }
            return LongRangeSet.fromDfaValue(value2);
        }

        @Override
        @Nullable
        LongRangeSet calcFromVariable(@NotNull DfaVariableValue var) {
            DfaValue defaultValue;
            LongRangeSet fromSpecialField;
            VariableDescriptor descriptor;
            if (var == null) {
                3.$$$reportNull$$$0(1);
            }
            if ((descriptor = var.getDescriptor()) instanceof SpecialField && (fromSpecialField = LongRangeSet.fromDfaValue(defaultValue = ((SpecialField)descriptor).getDefaultValue(var.getFactory(), false))) != null) {
                return fromSpecialField;
            }
            LongRangeSet fromType = LongRangeSet.fromType(var.getType());
            return fromType == null ? null : LongRangeSet.fromPsiElement(var.getPsiVariable()).intersect(fromType);
        }

        @Override
        @Nullable
        LongRangeSet uniteFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            if (left == null) {
                3.$$$reportNull$$$0(2);
            }
            if (right == null) {
                3.$$$reportNull$$$0(3);
            }
            return left.unite(right);
        }

        @Override
        @Nullable
        LongRangeSet intersectFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            LongRangeSet intersection;
            if (left == null) {
                3.$$$reportNull$$$0(4);
            }
            if (right == null) {
                3.$$$reportNull$$$0(5);
            }
            return (intersection = left.intersect(right)).isEmpty() ? null : intersection;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull LongRangeSet fact, @Nullable PsiType type2) {
            LongRangeSet fromType;
            if (fact == null) {
                3.$$$reportNull$$$0(6);
            }
            if (fact.equals(fromType = LongRangeSet.fromType(type2))) {
                if ("" == null) {
                    3.$$$reportNull$$$0(7);
                }
                return "";
            }
            String string = fact.toString();
            if (string == null) {
                3.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$3";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "calcFromVariable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteFacts";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectFacts";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<TypeConstraint> TYPE_CONSTRAINT = new DfaFactType<TypeConstraint>("Constraints"){

        @Override
        boolean isSuper(@Nullable TypeConstraint superFact, @Nullable TypeConstraint subFact) {
            return superFact == null || subFact != null && superFact.isSuperStateOf(subFact);
        }

        @Override
        @Nullable
        TypeConstraint calcFromVariable(@NotNull DfaVariableValue value2) {
            PsiType psiType;
            if (value2 == null) {
                4.$$$reportNull$$$0(0);
            }
            DfaPsiType type2 = (psiType = value2.getType()) == null ? null : value2.getFactory().createDfaType(psiType);
            return type2 == null ? null : TypeConstraint.empty().withInstanceofValue(type2);
        }

        @Override
        boolean isUnknown(@NotNull TypeConstraint fact) {
            if (fact == null) {
                4.$$$reportNull$$$0(1);
            }
            return fact.isEmpty();
        }

        @Override
        @Nullable
        TypeConstraint intersectFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            if (left == null) {
                4.$$$reportNull$$$0(2);
            }
            if (right == null) {
                4.$$$reportNull$$$0(3);
            }
            return left.intersect(right);
        }

        @Override
        @Nullable
        TypeConstraint uniteFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            if (left == null) {
                4.$$$reportNull$$$0(4);
            }
            if (right == null) {
                4.$$$reportNull$$$0(5);
            }
            return left.unite(right);
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull TypeConstraint fact, @Nullable PsiType type2) {
            if (fact == null) {
                4.$$$reportNull$$$0(6);
            }
            String string = fact.getPresentationText(type2);
            if (string == null) {
                4.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$4";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "calcFromVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectFacts";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteFacts";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<Boolean> LOCALITY = new DfaFactType<Boolean>("Locality"){

        @Override
        boolean isUnknown(@NotNull Boolean fact) {
            if (fact == null) {
                5.$$$reportNull$$$0(0);
            }
            return fact == false;
        }

        @Override
        @NotNull
        public String toString(@NotNull Boolean fact) {
            if (fact == null) {
                5.$$$reportNull$$$0(1);
            }
            String string = fact != false ? "local object" : "";
            if (string == null) {
                5.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$5";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<SpecialFieldValue> SPECIAL_FIELD_VALUE = new DfaFactType<SpecialFieldValue>("Special field value"){

        @Override
        @NotNull
        public String getName(SpecialFieldValue fact) {
            String string = fact == null ? super.getName(null) : StringUtil.wordsToBeginFromUpperCase((String)fact.getField().toString());
            if (string == null) {
                6.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        SpecialFieldValue uniteFacts(@NotNull SpecialFieldValue left, @NotNull SpecialFieldValue right) {
            if (left == null) {
                6.$$$reportNull$$$0(1);
            }
            if (right == null) {
                6.$$$reportNull$$$0(2);
            }
            return left.unite(right);
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull SpecialFieldValue fact, @Nullable PsiType type2) {
            if (fact == null) {
                6.$$$reportNull$$$0(3);
            }
            String string = fact.getPresentationText(type2);
            if (string == null) {
                6.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$6";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$6";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteFacts";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    private final String myName;

    private DfaFactType(@NotNull String name) {
        if (name == null) {
            DfaFactType.$$$reportNull$$$0(0);
        }
        super("DfaFactType: " + name);
        this.myName = name;
        ourFactTypes.add(this);
    }

    @NotNull
    public String getName(T fact) {
        String string = this.myName;
        if (string == null) {
            DfaFactType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public T fromDfaValue(DfaValue value2) {
        return value2 instanceof DfaFactMapValue ? (T)((DfaFactMapValue)value2).get(this) : null;
    }

    @Nullable
    T calcFromVariable(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            DfaFactType.$$$reportNull$$$0(2);
        }
        return null;
    }

    boolean isSuper(@Nullable T superFact, @Nullable T subFact) {
        return Objects.equals(superFact, subFact);
    }

    boolean isUnknown(@NotNull T fact) {
        if (fact == null) {
            DfaFactType.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Nullable
    T intersectFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(4);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(5);
        }
        return (T)(left.equals(right) ? left : null);
    }

    @Nullable
    T uniteFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(6);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(7);
        }
        return (T)(left.equals(right) ? left : null);
    }

    @NotNull
    public String toString(@NotNull T fact) {
        if (fact == null) {
            DfaFactType.$$$reportNull$$$0(8);
        }
        String string = fact.toString();
        if (string == null) {
            DfaFactType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getPresentationText(@NotNull T fact, @Nullable PsiType type2) {
        if (fact == null) {
            DfaFactType.$$$reportNull$$$0(10);
        }
        String string = this.toString(fact);
        if (string == null) {
            DfaFactType.$$$reportNull$$$0(11);
        }
        return string;
    }

    static List<DfaFactType<?>> getTypes() {
        return Collections.unmodifiableList(ourFactTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fact";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcFromVariable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intersectFacts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "uniteFacts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

