/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.apiUsage;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.apiUsage.ApiUsageDetector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInspection/apiUsage/ApiUsageVisitorBase;", "Lcom/intellij/psi/PsiElementVisitor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageDetector;", "()V", "checkImplicitCallToSuper", "", "constructor", "Lcom/intellij/psi/PsiMethod;", "checkMethodOverriding", "method", "processReferences", "element", "Lcom/intellij/psi/PsiElement;", "visitClass", "aClass", "Lcom/intellij/psi/PsiClass;", "visitElement", "visitMethod", "visitNewExpression", "expression", "Lcom/intellij/psi/PsiNewExpression;", "intellij.java.analysis.impl"})
public abstract class ApiUsageVisitorBase
extends PsiElementVisitor
implements ApiUsageDetector {
    public final void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.visitElement(element);
        if (element instanceof PsiLanguageInjectionHost || element instanceof LeafPsiElement) {
            return;
        }
        PsiElement psiElement = element;
        if (psiElement instanceof PsiClass) {
            this.visitClass((PsiClass)element);
        } else if (psiElement instanceof PsiMethod) {
            this.visitMethod((PsiMethod)element);
        } else if (psiElement instanceof PsiNewExpression) {
            this.visitNewExpression((PsiNewExpression)element);
        } else {
            this.processReferences(element);
        }
    }

    private final void processReferences(PsiElement element) {
        if (this.shouldProcessReferences(element)) {
            for (PsiReference reference : element.getReferences()) {
                this.processReference(reference);
            }
        }
    }

    private final void visitClass(PsiClass aClass) {
        block7: {
            PsiClass superClass;
            block8: {
                boolean bl;
                block6: {
                    PsiMethod[] $receiver$iv;
                    PsiMethod[] superConstructors;
                    if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                        return;
                    }
                    PsiMethod[] psiMethodArray = aClass.getConstructors();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"aClass.constructors");
                    PsiMethod[] psiMethodArray2 = psiMethodArray;
                    if (!(psiMethodArray2.length == 0)) break block7;
                    PsiClass psiClass = aClass.getSuperClass();
                    if (psiClass == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"aClass.superClass ?: return");
                    superClass = psiClass;
                    PsiMethod[] psiMethodArray3 = superClass.getConstructors();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray3, (String)"superClass.constructors");
                    PsiMethod[] psiMethodArray4 = superConstructors = psiMethodArray3;
                    if (psiMethodArray4.length == 0) break block8;
                    PsiMethod[] psiMethodArray5 = $receiver$iv = superConstructors;
                    int n = psiMethodArray5.length;
                    for (int i = 0; i < n; ++i) {
                        PsiMethod element$iv;
                        PsiMethod it = element$iv = psiMethodArray5[i];
                        boolean bl2 = false;
                        PsiMethod psiMethod = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
                        PsiParameterList psiParameterList = psiMethod.getParameterList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"it.parameterList");
                        if (!psiParameterList.isEmpty()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (!bl) break block7;
            }
            this.processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassDeclaration(aClass, superClass);
        }
    }

    private final void visitMethod(PsiMethod method) {
        if (method.isConstructor()) {
            this.checkImplicitCallToSuper(method);
        } else {
            this.checkMethodOverriding(method);
        }
    }

    private final void visitNewExpression(PsiNewExpression expression2) {
        PsiType psiType = expression2.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        if (psiClassType == null) {
            return;
        }
        PsiClassType classType = psiClassType;
        PsiExpressionList psiExpressionList = expression2.getArgumentList();
        if (psiExpressionList == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiExpressionList, (String)"expression.argumentList ?: return");
        PsiExpressionList argumentList = psiExpressionList;
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = expression2.getClassOrAnonymousClassReference();
        if (psiJavaCodeReferenceElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiJavaCodeReferenceElement, (String)"expression.classOrAnonym\u2026sClassReference ?: return");
        PsiJavaCodeReferenceElement classReference2 = psiJavaCodeReferenceElement;
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        Intrinsics.checkExpressionValueIsNotNull((Object)classResolveResult, (String)"classType.resolveGenerics()");
        PsiClassType.ClassResolveResult typeResult = classResolveResult;
        PsiClass psiClass = typeResult.getElement();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"typeResult.element ?: return");
        PsiClass aClass = psiClass;
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType psiClassType2 = ((PsiAnonymousClass)aClass).getBaseClassType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType2, (String)"aClass.baseClassType");
            classType = psiClassType2;
            PsiClassType.ClassResolveResult classResolveResult2 = classType.resolveGenerics();
            Intrinsics.checkExpressionValueIsNotNull((Object)classResolveResult2, (String)"classType.resolveGenerics()");
            typeResult = classResolveResult2;
            PsiClass psiClass2 = typeResult.getElement();
            if (psiClass2 == null) {
                return;
            }
            aClass = psiClass2;
        }
        PsiMethod[] psiMethodArray = aClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"aClass.constructors");
        PsiMethod[] psiMethodArray2 = psiMethodArray;
        if (psiMethodArray2.length == 0) {
            this.processDefaultConstructorInvocation(classReference2);
        } else {
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)expression2.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)javaPsiFacade, (String)"JavaPsiFacade\n        .g\u2026tance(expression.project)");
            Object[] objectArray = javaPsiFacade.getResolveHelper().multiResolveConstructor(classType, argumentList, (PsiElement)argumentList);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"JavaPsiFacade\n        .g\u2026gumentList, argumentList)");
            Object[] results = objectArray;
            Object object = ArraysKt.singleOrNull((Object[])results);
            if (!(object instanceof MethodCandidateInfo)) {
                object = null;
            }
            MethodCandidateInfo methodCandidateInfo = (MethodCandidateInfo)object;
            if (methodCandidateInfo == null) {
                return;
            }
            MethodCandidateInfo result = methodCandidateInfo;
            PsiMethod psiMethod = result.getElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"result.element");
            PsiMethod constructor = psiMethod;
            this.processConstructorInvocation(classReference2, constructor);
        }
    }

    private final void checkImplicitCallToSuper(PsiMethod constructor) {
        Object[] statements;
        PsiClass psiClass = constructor.getContainingClass();
        if (psiClass == null || (psiClass = psiClass.getSuperClass()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"constructor.containingClass?.superClass ?: return");
        PsiClass superClass = psiClass;
        Object[] objectArray = constructor.getBody();
        if (objectArray == null || (objectArray = objectArray.getStatements()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"constructor.body?.statements ?: return");
        Object[] objectArray2 = statements = objectArray;
        if (objectArray2.length == 0 || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)ArraysKt.first((Object[])statements), true, true)) {
            this.processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassConstructor(superClass, constructor);
        }
    }

    private final void checkMethodOverriding(PsiMethod method) {
        List list = method.findSuperMethodSignaturesIncludingStatic(true);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"method.findSuperMethodSi\u2026uresIncludingStatic(true)");
        List superSignatures = list;
        Iterator iterator = superSignatures.iterator();
        while (iterator.hasNext()) {
            PsiMethod superMethod;
            MethodSignatureBackedByPsiMethod superSignature;
            MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = superSignature = (MethodSignatureBackedByPsiMethod)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodSignatureBackedByPsiMethod, (String)"superSignature");
            Intrinsics.checkExpressionValueIsNotNull((Object)methodSignatureBackedByPsiMethod.getMethod(), (String)"superSignature.method");
            this.processMethodOverriding(method, superMethod);
        }
    }
}

