/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class VariableTypeCanBeExplicitInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            VariableTypeCanBeExplicitInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel10OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                VariableTypeCanBeExplicitInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                ArrayList<PsiTypeElement> typeElements = new ArrayList<PsiTypeElement>();
                for (PsiParameter parameter2 : expression2.getParameterList().getParameters()) {
                    PsiTypeElement typeElement = this.getTypeElementToExpand((PsiVariable)parameter2);
                    if (typeElement == null) {
                        return;
                    }
                    typeElements.add(typeElement);
                }
                for (PsiTypeElement typeElement : typeElements) {
                    this.registerTypeElementProblem(typeElement);
                }
            }

            public void visitVariable(PsiVariable variable) {
                if (variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() instanceof PsiLambdaExpression) {
                    return;
                }
                PsiTypeElement typeElement = this.getTypeElementToExpand(variable);
                if (typeElement != null) {
                    this.registerTypeElementProblem(typeElement);
                }
            }

            private void registerTypeElementProblem(PsiTypeElement typeElement) {
                holder.registerProblem((PsiElement)typeElement, "'var' can be replaced with explicit type", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceVarWithExplicitTypeFix()});
            }

            private PsiTypeElement getTypeElementToExpand(PsiVariable variable) {
                PsiType type2;
                PsiTypeElement typeElement = variable.getTypeElement();
                if (typeElement != null && typeElement.isInferredType() && PsiTypesUtil.isDenotableType((PsiType)(type2 = variable.getType()), (PsiElement)variable)) {
                    return typeElement;
                }
                return null;
            }
        };
        if (javaElementVisitor == null) {
            VariableTypeCanBeExplicitInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/VariableTypeCanBeExplicitInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/VariableTypeCanBeExplicitInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceVarWithExplicitTypeFix
    implements LocalQuickFix {
        private ReplaceVarWithExplicitTypeFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace 'var' with explicit type" == null) {
                ReplaceVarWithExplicitTypeFix.$$$reportNull$$$0(0);
            }
            return "Replace 'var' with explicit type";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReplaceVarWithExplicitTypeFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceVarWithExplicitTypeFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof PsiTypeElement) {
                PsiElement declarationScope;
                PsiElement parent = element.getParent();
                if (parent instanceof PsiParameter && (declarationScope = ((PsiParameter)parent).getDeclarationScope()) instanceof PsiLambdaExpression) {
                    for (PsiParameter parameter2 : ((PsiLambdaExpression)declarationScope).getParameterList().getParameters()) {
                        PsiTypeElement typeElement = parameter2.getTypeElement();
                        if (typeElement == null) continue;
                        PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement);
                    }
                    return;
                }
                PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)((PsiTypeElement)element));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/VariableTypeCanBeExplicitInspection$ReplaceVarWithExplicitTypeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/VariableTypeCanBeExplicitInspection$ReplaceVarWithExplicitTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

