/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SuspiciousListRemoveInLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher LIST_REMOVE = CallMatcher.instanceCall("java.util.List", "remove").parameterTypes("int");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousListRemoveInLoopInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!LIST_REMOVE.test(call)) {
                    return;
                }
                PsiReferenceExpression arg = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiReferenceExpression.class);
                if (arg == null) {
                    return;
                }
                PsiExpressionStatement parentStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)call.getParent(), PsiExpressionStatement.class);
                if (parentStatement == null) {
                    return;
                }
                PsiElement parent = parentStatement.getParent();
                while (parent instanceof PsiLabeledStatement || parent instanceof PsiIfStatement || parent instanceof PsiSwitchLabelStatementBase || parent instanceof PsiSwitchStatement || parent instanceof PsiBlockStatement || parent instanceof PsiCodeBlock) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiForStatement)) {
                    return;
                }
                CountingLoop loop = CountingLoop.from((PsiForStatement)parent);
                if (loop == null || loop.isDescending()) {
                    return;
                }
                if (!arg.isReferenceTo((PsiElement)loop.getCounter())) {
                    return;
                }
                if (ControlFlowUtils.isExecutedOnceInLoop((PsiStatement)parentStatement, (PsiLoopStatement)parent)) {
                    return;
                }
                holder.registerProblem(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), InspectionsBundle.message((String)"inspection.suspicious.list.remove.display.name", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        };
        if (javaElementVisitor == null) {
            SuspiciousListRemoveInLoopInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SuspiciousListRemoveInLoopInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SuspiciousListRemoveInLoopInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

