/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantBackticksAroundRawStringLiteralInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantBackticksAroundRawStringLiteralInspection.$$$reportNull$$$0(0);
        }
        if (!HighlightUtil.Feature.RAW_LITERALS.isAvailable((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantBackticksAroundRawStringLiteralInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression2) {
                if (((PsiLiteralExpressionImpl)expression2).getLiteralElementType() == JavaTokenType.RAW_STRING_LITERAL) {
                    String text2 = expression2.getText();
                    final String rawString = ((PsiLiteralExpressionImpl)expression2).getRawString();
                    int reducedNumberOfBackTicks = PsiRawStringLiteralUtil.getReducedNumberOfBackticks((String)text2);
                    if (reducedNumberOfBackTicks > 0) {
                        final String newBackticksSequence = StringUtil.repeat((String)"`", (int)reducedNumberOfBackTicks);
                        int redundantTicksLength = (text2.length() - rawString.length()) / 2 - reducedNumberOfBackTicks;
                        holder.registerProblem((PsiElement)expression2, "Number of backticks may be reduced by " + redundantTicksLength, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new TextRange(0, redundantTicksLength), new LocalQuickFix[]{new LocalQuickFix(){

                            @Nls
                            @NotNull
                            public String getFamilyName() {
                                if ("Reduce number of backticks" == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return "Reduce number of backticks";
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                if (project == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (descriptor == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                PsiElement element = descriptor.getPsiElement();
                                PsiExpression newRawStringLiteral = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newBackticksSequence + rawString + newBackticksSequence, element);
                                element.replace((PsiElement)newRawStringLiteral);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 2;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n2 = 3;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/codeInspection/RedundantBackticksAroundRawStringLiteralInspection$1$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "project";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "descriptor";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getFamilyName";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/codeInspection/RedundantBackticksAroundRawStringLiteralInspection$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray;
                                        objectArray[2] = "applyFix";
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        }});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            RedundantBackticksAroundRawStringLiteralInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantBackticksAroundRawStringLiteralInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantBackticksAroundRawStringLiteralInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

