/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyBooleanExpressionFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpression");
    public static final String FAMILY_NAME = QuickFixBundle.message("simplify.boolean.expression.family", new Object[0]);
    private final boolean mySubExpressionValue;

    public SimplifyBooleanExpressionFix(@NotNull PsiExpression subExpression, boolean subExpressionValue) {
        if (subExpression == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)subExpression);
        this.mySubExpressionValue = subExpressionValue;
    }

    @NotNull
    public String getText() {
        PsiExpression subExpression = this.getSubExpression();
        if (subExpression == null) {
            String string = this.getFamilyName();
            if (string == null) {
                SimplifyBooleanExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = SimplifyBooleanExpressionFix.getIntentionText(subExpression, this.mySubExpressionValue) + (this.shouldExtractSideEffect() ? " extracting side effects" : "");
        if (string == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private boolean shouldExtractSideEffect() {
        PsiExpression subExpression = this.getSubExpression();
        if (subExpression != null && SideEffectChecker.mayHaveSideEffects(subExpression)) {
            if (ControlFlowUtils.canExtractStatement(subExpression)) {
                return true;
            }
            if (!this.mySubExpressionValue) {
                PsiPolyadicExpression polyadic;
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)subExpression.getParent());
                if (parent instanceof PsiWhileStatement || parent instanceof PsiForStatement) {
                    return true;
                }
                if (parent instanceof PsiPolyadicExpression && (polyadic = (PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.OROR) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ArrayUtil.getLastElement((Object[])polyadic.getOperands())), (PsiElement)subExpression, (boolean)false) && PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent()) instanceof PsiIfStatement) {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public static String getIntentionText(@NotNull PsiExpression expression2, boolean constantValue) {
        PsiElement parent;
        if (expression2 == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(3);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiIfStatement) {
            String string = constantValue ? CommonQuickFixBundle.message((String)"fix.unwrap.statement", (Object[])new Object[]{"if"}) : CommonQuickFixBundle.message((String)"fix.remove.statement", (Object[])new Object[]{"if"});
            if (string == null) {
                SimplifyBooleanExpressionFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (!constantValue) {
            if (parent instanceof PsiWhileStatement) {
                String string = CommonQuickFixBundle.message((String)"fix.remove.statement", (Object[])new Object[]{"while"});
                if (string == null) {
                    SimplifyBooleanExpressionFix.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (parent instanceof PsiDoWhileStatement) {
                String string = CommonQuickFixBundle.message((String)"fix.unwrap.statement", (Object[])new Object[]{"do-while"});
                if (string == null) {
                    SimplifyBooleanExpressionFix.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (parent instanceof PsiForStatement) {
                String string = CommonQuickFixBundle.message((String)"fix.remove.statement", (Object[])new Object[]{"for"});
                if (string == null) {
                    SimplifyBooleanExpressionFix.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        String string = QuickFixBundle.message("simplify.boolean.expression.text", PsiExpressionTrimRenderer.render((PsiExpression)expression2), constantValue);
        if (string == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = FAMILY_NAME;
        if (string == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isAvailable() {
        PsiElement parent;
        PsiExpression expression2 = this.getSubExpression();
        if (!super.isAvailable() || expression2 == null || !BaseIntentionAction.canModify((PsiElement)expression2) || PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
            return false;
        }
        PsiElement element = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2);
        PsiElement psiElement = parent = element == null ? null : element.getParent();
        return !(parent instanceof PsiDoWhileStatement) || !SimplifyBooleanExpressionFix.containsBreakOrContinue((PsiDoWhileStatement)parent);
    }

    private static boolean containsBreakOrContinue(PsiDoWhileStatement doWhileLoop) {
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)doWhileLoop).filter(e -> SimplifyBooleanExpressionFix.isBreakOrContinue(e, doWhileLoop))).iterator().hasNext();
    }

    private static boolean isBreakOrContinue(PsiElement e, PsiDoWhileStatement doWhileLoop) {
        return e instanceof PsiBreakStatement && doWhileLoop == ((PsiBreakStatement)e).findExitedStatement() || e instanceof PsiContinueStatement && doWhileLoop == ((PsiContinueStatement)e).findContinuedStatement();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(10);
        }
        if (file == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(11);
        }
        if (startElement == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(12);
        }
        if (endElement == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(13);
        }
        if (!this.isAvailable()) {
            return;
        }
        PsiExpression subExpression = this.getSubExpression();
        if (subExpression == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        if (this.shouldExtractSideEffect()) {
            if ((subExpression = this.ensureCodeBlock(project, subExpression)) == null) {
                LOG.error("ensureCodeBlock returned null", new Attachment[]{new Attachment("subExpression.txt", this.getSubExpression().getText())});
                return;
            }
            PsiStatement anchor = (PsiStatement)ObjectUtils.tryCast((Object)RefactoringUtil.getParentStatement((PsiElement)subExpression, false), PsiStatement.class);
            if (anchor == null) {
                LOG.error("anchor is null", new Attachment[]{new Attachment("subExpression.txt", subExpression.getText())});
                return;
            }
            List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(subExpression);
            sideEffects.forEach(ct::markUnchanged);
            PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, subExpression);
            if (statements.length > 0) {
                BlockUtils.addBefore(anchor, statements);
            }
            if (!subExpression.isValid()) {
                LOG.error("subExpression became invalid", new Attachment[]{new Attachment("subExpression.txt", subExpression.getText())});
                return;
            }
        }
        PsiExpression expression2 = (PsiExpression)ct.replaceAndRestoreComments((PsiElement)subExpression, Boolean.toString(this.mySubExpressionValue));
        while (expression2.getParent() instanceof PsiExpression) {
            expression2 = (PsiExpression)expression2.getParent();
        }
        SimplifyBooleanExpressionFix.simplifyExpression(expression2);
    }

    public PsiExpression ensureCodeBlock(@NotNull Project project, PsiExpression subExpression) {
        if (project == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(14);
        }
        if (!this.mySubExpressionValue) {
            PsiExpression expression2;
            PsiPolyadicExpression polyadicExpression;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)subExpression.getParent());
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (parent instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)parent;
                if (whileStatement.getCondition() != null) {
                    PsiStatement replacement = factory.createStatementFromText("if(" + whileStatement.getCondition().getText() + ");", (PsiElement)whileStatement);
                    PsiIfStatement ifStatement = (PsiIfStatement)whileStatement.replace((PsiElement)replacement);
                    subExpression = Objects.requireNonNull(ifStatement.getCondition());
                }
            } else if (parent instanceof PsiPolyadicExpression && JavaTokenType.OROR.equals((polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType()) && (expression2 = SimplifyBooleanExpressionFix.expandLastIfDisjunct(polyadicExpression, subExpression, factory)) != null) {
                return expression2;
            }
        }
        return RefactoringUtil.ensureCodeBlock(subExpression);
    }

    @Nullable
    private static PsiExpression expandLastIfDisjunct(PsiPolyadicExpression orChain, PsiExpression subExpression, PsiElementFactory factory) {
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)orChain.getParent()), PsiIfStatement.class);
        if (ifStatement == null) {
            return null;
        }
        PsiExpression lastOperand = (PsiExpression)ArrayUtil.getLastElement((Object[])orChain.getOperands());
        if (!PsiTreeUtil.isAncestor((PsiElement)lastOperand, (PsiElement)subExpression, (boolean)false)) {
            return null;
        }
        orChain.replace((PsiElement)SplitConditionUtil.getLOperands(orChain, orChain.getTokenBeforeOperand(lastOperand)));
        ControlFlowUtils.ensureElseBranch(ifStatement);
        PsiBlockStatement elseBranch = (PsiBlockStatement)Objects.requireNonNull(ifStatement.getElseBranch());
        PsiCodeBlock codeBlock = elseBranch.getCodeBlock();
        PsiStatement replacement = factory.createStatementFromText("if(" + subExpression.getText() + ");", (PsiElement)ifStatement);
        PsiIfStatement alwaysFalseIf = (PsiIfStatement)codeBlock.addAfter((PsiElement)replacement, (PsiElement)codeBlock.getLBrace());
        return Objects.requireNonNull(alwaysFalseIf.getCondition());
    }

    private static boolean simplifyIfOrLoopStatement(PsiExpression expression2) throws IncorrectOperationException {
        boolean condition2 = Boolean.parseBoolean(expression2.getText());
        if (!(expression2 instanceof PsiLiteralExpression) || !PsiType.BOOLEAN.equals((Object)expression2.getType())) {
            return false;
        }
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() == expression2) {
            SimplifyBooleanExpressionFix.simplifyIfStatement(condition2, (PsiIfStatement)parent);
            return true;
        }
        if (parent instanceof PsiWhileStatement && !condition2) {
            parent.delete();
            return true;
        }
        if (parent instanceof PsiDoWhileStatement && !condition2) {
            SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)((PsiDoWhileStatement)parent), ((PsiDoWhileStatement)parent).getBody());
            return true;
        }
        if (parent instanceof PsiForStatement && !condition2) {
            SimplifyBooleanExpressionFix.simplifyForStatement(parent);
            return true;
        }
        return false;
    }

    private static void simplifyForStatement(PsiElement parent) {
        PsiStatement initialization = ((PsiForStatement)parent).getInitialization();
        if (initialization != null && !SyntaxTraverser.psiTraverser((PsiElement)initialization).filter(PsiExpression.class).filter(SideEffectChecker::mayHaveSideEffects).isEmpty()) {
            SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)((PsiForStatement)parent), initialization);
        } else {
            parent.delete();
        }
    }

    private static void simplifyIfStatement(boolean conditionAlwaysTrue, PsiIfStatement ifStatement) {
        if (conditionAlwaysTrue) {
            SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)ifStatement, ifStatement.getThenBranch());
        } else {
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                ifStatement.delete();
            } else {
                SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)ifStatement, elseBranch);
            }
        }
    }

    private static void replaceWithStatements(@NotNull PsiStatement orig, @Nullable PsiStatement statement) throws IncorrectOperationException {
        PsiIfStatement ifStmt;
        if (orig == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(15);
        }
        if (statement == null) {
            orig.delete();
            return;
        }
        PsiElement parent = orig.getParent();
        if (parent == null) {
            return;
        }
        PsiElement grandParent = parent.getParent();
        if (parent instanceof PsiCodeBlock && SimplifyBooleanExpressionFix.blockAlwaysReturns(statement)) {
            SimplifyBooleanExpressionFix.removeFollowingStatements(orig, (PsiCodeBlock)parent);
        } else if (grandParent instanceof PsiCodeBlock && parent instanceof PsiIfStatement && (ifStmt = (PsiIfStatement)parent).getElseBranch() == orig && SimplifyBooleanExpressionFix.blockAlwaysReturns(ifStmt.getThenBranch()) && SimplifyBooleanExpressionFix.blockAlwaysReturns(statement)) {
            SimplifyBooleanExpressionFix.removeFollowingStatements((PsiStatement)ifStmt, (PsiCodeBlock)grandParent);
        }
        if (parent instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock;
            if (statement instanceof PsiBlockStatement && !BlockUtils.containsConflictingDeclarations(codeBlock = ((PsiBlockStatement)statement).getCodeBlock(), (PsiCodeBlock)parent)) {
                BlockUtils.inlineCodeBlock(orig, codeBlock);
                return;
            }
            if (SimplifyBooleanExpressionFix.hasConflictingDeclarations(statement, (PsiCodeBlock)parent)) {
                orig.replace((PsiElement)SimplifyBooleanExpressionFix.wrapWithCodeBlock(statement));
                return;
            }
        }
        orig.replace((PsiElement)statement);
    }

    private static boolean hasConflictingDeclarations(@Nullable PsiStatement statement, PsiCodeBlock parent) {
        return statement instanceof PsiDeclarationStatement && ContainerUtil.exists((Object[])((PsiDeclarationStatement)statement).getDeclaredElements(), e -> SimplifyBooleanExpressionFix.isConflictingLocalVariable(parent, e));
    }

    private static boolean isConflictingLocalVariable(PsiCodeBlock parent, PsiElement declaration2) {
        if (!(declaration2 instanceof PsiLocalVariable)) {
            return false;
        }
        String name = ((PsiLocalVariable)declaration2).getName();
        return name != null && PsiResolveHelper.SERVICE.getInstance((Project)declaration2.getProject()).resolveAccessibleReferencedVariable(name, (PsiElement)parent) != null;
    }

    private static PsiBlockStatement wrapWithCodeBlock(PsiStatement replacement) {
        PsiBlockStatement newBlock = BlockUtils.createBlockStatement(replacement.getProject());
        newBlock.getCodeBlock().add((PsiElement)replacement);
        return newBlock;
    }

    private static boolean blockAlwaysReturns(@Nullable PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        try {
            return ControlFlowUtil.returnPresent(HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)statement));
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    private static void removeFollowingStatements(@NotNull PsiStatement anchor, @NotNull PsiCodeBlock parentBlock) {
        PsiStatement[] siblingStatements;
        int ifIndex;
        if (anchor == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(16);
        }
        if (parentBlock == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(17);
        }
        if ((ifIndex = Arrays.asList(siblingStatements = parentBlock.getStatements()).indexOf(anchor)) >= 0 && ifIndex < siblingStatements.length - 1) {
            parentBlock.deleteChildRange((PsiElement)siblingStatements[ifIndex + 1], (PsiElement)siblingStatements[siblingStatements.length - 1]);
        }
    }

    public static void simplifyExpression(PsiExpression expression2) throws IncorrectOperationException {
        PsiElement parent;
        PsiExpression result = SimplifyBooleanExpressionFix.createSimplifiedReplacement(expression2);
        PsiExpression newExpression = (PsiExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)expression2, (PsiElement)result);
        if (newExpression instanceof PsiLiteralExpression && (parent = newExpression.getParent()) instanceof PsiAssertStatement && ((PsiLiteralExpression)newExpression).getValue() == Boolean.TRUE) {
            parent.delete();
            return;
        }
        if (!SimplifyBooleanExpressionFix.simplifyIfOrLoopStatement(newExpression)) {
            ParenthesesUtils.removeParentheses(newExpression, false);
        }
    }

    private static PsiExpression createSimplifiedReplacement(PsiExpression expression2) {
        final PsiExpression[] result = new PsiExpression[]{(PsiExpression)expression2.copy()};
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression2.getManager(), true);
        final IncorrectOperationException[] exception = new IncorrectOperationException[]{null};
        result[0].accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement[] children;
                for (PsiElement child : children = element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                expressionVisitor.clear();
                expression2.accept((PsiElementVisitor)expressionVisitor);
                if (expressionVisitor.resultExpression != null) {
                    LOG.assertTrue(expressionVisitor.resultExpression.isValid());
                    try {
                        if (expression2 != result[0]) {
                            expression2.replace((PsiElement)expressionVisitor.resultExpression);
                        } else {
                            result[0] = expressionVisitor.resultExpression;
                        }
                    }
                    catch (IncorrectOperationException e) {
                        exception[0] = e;
                    }
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }

    public static boolean canBeSimplified(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(18);
        }
        if (!(expression2 instanceof PsiConditionalExpression) && !PsiType.BOOLEAN.equals((Object)expression2.getType())) {
            return false;
        }
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiLambdaExpression && !LambdaUtil.isSafeLambdaBodyReplacement((PsiLambdaExpression)((PsiLambdaExpression)parent), () -> SimplifyBooleanExpressionFix.createSimplifiedReplacement(expression2))) {
            return false;
        }
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression2.getManager(), false);
        final Ref canBeSimplified = new Ref((Object)Boolean.FALSE);
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)canBeSimplified.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                expressionVisitor.clear();
                expression2.accept((PsiElementVisitor)expressionVisitor);
                if (expressionVisitor.canBeSimplifiedFlag) {
                    canBeSimplified.set((Object)Boolean.TRUE);
                }
            }
        });
        return (Boolean)canBeSimplified.get();
    }

    private PsiExpression getSubExpression() {
        PsiElement element = this.getStartElement();
        return element instanceof PsiExpression ? (PsiExpression)element : null;
    }

    public static Boolean getConstBoolean(PsiExpression operand2) {
        if (operand2 == null) {
            return null;
        }
        if ((operand2 = PsiUtil.deparenthesizeExpression((PsiExpression)operand2)) == null) {
            return null;
        }
        String text2 = operand2.getText();
        return "true".equals(text2) ? Boolean.TRUE : ("false".equals(text2) ? Boolean.FALSE : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subExpression";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orig";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntentionText";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ensureCodeBlock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithStatements";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeFollowingStatements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canBeSimplified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExpressionVisitor
    extends JavaElementVisitor {
        private PsiExpression resultExpression;
        private final PsiExpression trueExpression;
        private final PsiExpression falseExpression;
        private final boolean isCreateResult;
        boolean canBeSimplifiedFlag;

        private ExpressionVisitor(PsiManager psiManager, boolean createResult) {
            this.isCreateResult = createResult;
            this.trueExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(true)) : null;
            this.falseExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(false)) : null;
        }

        private static PsiExpression createExpression(PsiManager psiManager, @NonNls String text2) {
            try {
                return JavaPsiFacade.getElementFactory((Project)psiManager.getProject()).createExpressionFromText(text2, null);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        private boolean markAndCheckCreateResult() {
            this.canBeSimplifiedFlag = true;
            return this.isCreateResult;
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2 = expression2.getOperands();
            PsiExpression lExpr = operands2[0];
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.XOR == tokenType) {
                boolean negate = false;
                ArrayList<PsiExpression> expressions2 = new ArrayList<PsiExpression>();
                for (PsiExpression operand2 : operands2) {
                    Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand2);
                    if (constBoolean != null) {
                        this.markAndCheckCreateResult();
                        if (constBoolean != Boolean.TRUE) continue;
                        negate = !negate;
                        continue;
                    }
                    expressions2.add(operand2);
                }
                if (expressions2.isEmpty()) {
                    this.resultExpression = negate ? this.trueExpression : this.falseExpression;
                } else {
                    String simplifiedText = StringUtil.join(expressions2, PsiElement::getText, (String)" ^ ");
                    if (negate) {
                        simplifiedText = expressions2.size() > 1 ? "!(" + simplifiedText + ")" : "!" + simplifiedText;
                    }
                    this.resultExpression = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(simplifiedText, (PsiElement)expression2);
                }
            } else {
                for (int i = 1; i < operands2.length; ++i) {
                    Boolean l = SimplifyBooleanExpressionFix.getConstBoolean(lExpr);
                    PsiExpression operand3 = operands2[i];
                    Boolean r = SimplifyBooleanExpressionFix.getConstBoolean(operand3);
                    if (l != null) {
                        this.simplifyBinary(tokenType, l, operand3);
                    } else if (r != null) {
                        this.simplifyBinary(tokenType, r, lExpr);
                    } else {
                        PsiJavaToken javaToken = expression2.getTokenBeforeOperand(operand3);
                        if (javaToken != null && !PsiTreeUtil.hasErrorElements((PsiElement)operand3) && !PsiTreeUtil.hasErrorElements((PsiElement)lExpr)) {
                            try {
                                this.resultExpression = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(lExpr.getText() + javaToken.getText() + operand3.getText(), (PsiElement)expression2);
                            }
                            catch (IncorrectOperationException e) {
                                this.resultExpression = null;
                            }
                        } else {
                            this.resultExpression = null;
                        }
                    }
                    if (this.resultExpression == null) continue;
                    lExpr = this.resultExpression;
                }
            }
        }

        private void simplifyBinary(IElementType tokenType, Boolean lConstBoolean, PsiExpression rOperand) {
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            if (JavaTokenType.ANDAND == tokenType || JavaTokenType.AND == tokenType) {
                this.resultExpression = lConstBoolean != false ? rOperand : this.falseExpression;
            } else if (JavaTokenType.OROR == tokenType || JavaTokenType.OR == tokenType) {
                this.resultExpression = lConstBoolean != false ? this.trueExpression : rOperand;
            } else if (JavaTokenType.EQEQ == tokenType) {
                this.simplifyEquation(lConstBoolean, rOperand);
            } else if (JavaTokenType.NE == tokenType) {
                PsiPrefixExpression negatedExpression = ExpressionVisitor.createNegatedExpression(rOperand);
                this.resultExpression = negatedExpression;
                this.visitPrefixExpression(negatedExpression);
                this.simplifyEquation(lConstBoolean, this.resultExpression);
            }
        }

        private void simplifyEquation(Boolean constBoolean, PsiExpression otherOperand) {
            if (constBoolean.booleanValue()) {
                this.resultExpression = otherOperand;
            } else {
                PsiPrefixExpression negated = ExpressionVisitor.createNegatedExpression(otherOperand);
                this.resultExpression = negated;
                this.visitPrefixExpression(negated);
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            Boolean condition2 = SimplifyBooleanExpressionFix.getConstBoolean(expression2.getCondition());
            if (condition2 == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = condition2 != false ? expression2.getThenExpression() : expression2.getElseExpression();
        }

        private static PsiPrefixExpression createNegatedExpression(PsiExpression otherOperand) {
            PsiPrefixExpression expression2 = (PsiPrefixExpression)ExpressionVisitor.createExpression(otherOperand.getManager(), "!(xxx)");
            assert (expression2 != null);
            PsiExpression operand2 = expression2.getOperand();
            assert (operand2 != null);
            try {
                operand2.replace((PsiElement)otherOperand);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return expression2;
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            PsiExpression operand2 = expression2.getOperand();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand2);
            if (constBoolean == null) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.EXCL == tokenType) {
                if (!this.markAndCheckCreateResult()) {
                    return;
                }
                this.resultExpression = constBoolean != false ? this.falseExpression : this.trueExpression;
            }
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            PsiExpression subExpr = expression2.getExpression();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(subExpr);
            if (constBoolean == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = constBoolean != false ? this.trueExpression : this.falseExpression;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }

        public void clear() {
            this.resultExpression = null;
        }
    }
}

