/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteSideEffectsAwareFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements LowPriorityAction {
    private final SmartPsiElementPointer<PsiStatement> myStatementPtr;
    private final SmartPsiElementPointer<PsiExpression> myExpressionPtr;
    private final String myMessage;
    private final boolean myIsAvailable;

    public DeleteSideEffectsAwareFix(@NotNull PsiStatement statement, PsiExpression expression2) {
        if (statement == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(0);
        }
        this(statement, expression2, false);
    }

    public DeleteSideEffectsAwareFix(@NotNull PsiStatement statement, PsiExpression expression2, boolean alwaysAvailable) {
        PsiStatement[] statements;
        if (statement == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)statement);
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)statement.getProject());
        this.myStatementPtr = manager.createSmartPsiElementPointer((PsiElement)statement);
        this.myExpressionPtr = manager.createSmartPsiElementPointer((PsiElement)expression2);
        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(expression2);
        this.myMessage = sideEffects.isEmpty() ? QuickFixBundle.message("delete.element.fix.text", new Object[0]) : ((statements = StatementExtractor.generateStatements(sideEffects, expression2)).length == 1 && statements[0] instanceof PsiIfStatement ? QuickFixBundle.message("extract.side.effects.convert.to.if", new Object[0]) : QuickFixBundle.message("extract.side.effects", statements.length));
        this.myIsAvailable = alwaysAvailable || sideEffects.size() != 1 || !(statement instanceof PsiExpressionStatement) || sideEffects.get(0) != PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.myMessage;
        if (string == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("extract.side.effects.family.name", new Object[0]);
        if (string == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(7);
        }
        return this.myIsAvailable;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiElement parent;
        PsiStatement statement;
        if (project == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            DeleteSideEffectsAwareFix.$$$reportNull$$$0(11);
        }
        if ((statement = (PsiStatement)this.myStatementPtr.getElement()) == null) {
            return;
        }
        PsiExpression expression2 = (PsiExpression)this.myExpressionPtr.getElement();
        if (expression2 == null) {
            return;
        }
        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(expression2);
        CommentTracker ct = new CommentTracker();
        sideEffects.forEach(ct::markUnchanged);
        PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, expression2);
        if (statements.length > 0) {
            PsiStatement lastAdded = BlockUtils.addBefore(statement, statements);
            statement = (PsiStatement)Objects.requireNonNull(PsiTreeUtil.getNextSiblingOfType((PsiElement)lastAdded, PsiStatement.class));
        }
        if ((parent = statement.getParent()) instanceof PsiStatement && (!(parent instanceof PsiIfStatement) || ((PsiIfStatement)parent).getElseBranch() != statement)) {
            ct.replaceAndRestoreComments((PsiElement)statement, "{}");
        } else {
            ct.deleteAndRestoreComments((PsiElement)statement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteSideEffectsAwareFix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteSideEffectsAwareFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

