/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodMergingContributor;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.codeInsight.hint.api.impls.MethodParameterInfoHandler;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.impl.JavaElementLookupRenderer;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodCallElement
extends LookupItem<PsiMethod>
implements TypedLookupItem,
StaticallyImportable {
    public static final ClassConditionKey<JavaMethodCallElement> CLASS_CONDITION_KEY = ClassConditionKey.create(JavaMethodCallElement.class);
    public static final Key<Boolean> COMPLETION_HINTS = Key.create((String)"completion.hints");
    @Nullable
    private final PsiClass myContainingClass;
    private final PsiMethod myMethod;
    private final MemberLookupHelper myHelper;
    private PsiSubstitutor myQualifierSubstitutor;
    private PsiSubstitutor myInferenceSubstitutor;
    private boolean myNeedExplicitTypeParameters;
    private String myForcedQualifier;
    @Nullable
    private String myPresentableTypeArgs;
    public static final Key<PsiMethod> ARGUMENT_TEMPLATE_ACTIVE = Key.create((String)"ARGUMENT_TEMPLATE_ACTIVE");

    public JavaMethodCallElement(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodCallElement.$$$reportNull$$$0(0);
        }
        this(method, method.getName());
    }

    public JavaMethodCallElement(@NotNull PsiMethod method, String methodName) {
        if (method == null) {
            JavaMethodCallElement.$$$reportNull$$$0(1);
        }
        super((Object)method, methodName);
        this.myQualifierSubstitutor = PsiSubstitutor.EMPTY;
        this.myInferenceSubstitutor = PsiSubstitutor.EMPTY;
        this.myForcedQualifier = "";
        this.myMethod = method;
        this.myHelper = null;
        this.myContainingClass = method.getContainingClass();
    }

    public JavaMethodCallElement(PsiMethod method, boolean shouldImportStatic, boolean mergedOverloads) {
        super((Object)method, method.getName());
        String className;
        this.myQualifierSubstitutor = PsiSubstitutor.EMPTY;
        this.myInferenceSubstitutor = PsiSubstitutor.EMPTY;
        this.myForcedQualifier = "";
        this.myMethod = method;
        this.myContainingClass = method.getContainingClass();
        this.myHelper = new MemberLookupHelper((PsiMember)method, this.myContainingClass, shouldImportStatic, mergedOverloads);
        if (!shouldImportStatic && this.myContainingClass != null && (className = this.myContainingClass.getName()) != null) {
            this.addLookupStrings(new String[]{className + "." + this.myMethod.getName()});
        }
    }

    void setForcedQualifier(@NotNull String forcedQualifier) {
        if (forcedQualifier == null) {
            JavaMethodCallElement.$$$reportNull$$$0(2);
        }
        this.myForcedQualifier = forcedQualifier;
        this.setLookupString(forcedQualifier + this.getLookupString());
    }

    @Override
    public PsiType getType() {
        return this.getSubstitutor().substitute(this.getInferenceSubstitutor().substitute(((PsiMethod)this.getObject()).getReturnType()));
    }

    public void setInferenceSubstitutorFromExpectedType(@NotNull PsiElement place, @NotNull PsiType expectedType) {
        if (place == null) {
            JavaMethodCallElement.$$$reportNull$$$0(3);
        }
        if (expectedType == null) {
            JavaMethodCallElement.$$$reportNull$$$0(4);
        }
        this.myInferenceSubstitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(this.myMethod, expectedType);
        this.myNeedExplicitTypeParameters = JavaMethodCallElement.mayNeedTypeParameters(place) && SmartCompletionDecorator.hasUnboundTypeParams(this.myMethod, expectedType);
        String string = this.myPresentableTypeArgs = this.myNeedExplicitTypeParameters ? JavaMethodCallElement.getTypeParamsText(true, (PsiTypeParameterListOwner)this.myMethod, this.myInferenceSubstitutor) : null;
        if (this.myPresentableTypeArgs != null && this.myPresentableTypeArgs.length() > 10) {
            this.myPresentableTypeArgs = this.myPresentableTypeArgs.substring(0, 10) + "...>";
        }
    }

    public JavaMethodCallElement setQualifierSubstitutor(@NotNull PsiSubstitutor qualifierSubstitutor) {
        if (qualifierSubstitutor == null) {
            JavaMethodCallElement.$$$reportNull$$$0(5);
        }
        this.myQualifierSubstitutor = qualifierSubstitutor;
        return this;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.myQualifierSubstitutor;
        if (psiSubstitutor == null) {
            JavaMethodCallElement.$$$reportNull$$$0(6);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getInferenceSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.myInferenceSubstitutor;
        if (psiSubstitutor == null) {
            JavaMethodCallElement.$$$reportNull$$$0(7);
        }
        return psiSubstitutor;
    }

    @Override
    public void setShouldBeImported(boolean shouldImportStatic) {
        this.myHelper.setShouldBeImported(shouldImportStatic);
    }

    @Override
    public boolean canBeImported() {
        return this.myHelper != null;
    }

    @Override
    public boolean willBeImported() {
        return this.canBeImported() && this.myHelper.willBeImported();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethodCallElement)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Objects.equals(this.myPresentableTypeArgs, ((JavaMethodCallElement)o).myPresentableTypeArgs)) {
            return false;
        }
        return this.myQualifierSubstitutor.equals(((JavaMethodCallElement)o).myQualifierSubstitutor);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myPresentableTypeArgs == null ? 0 : this.myPresentableTypeArgs.hashCode());
        result = 31 * result + this.myQualifierSubstitutor.hashCode();
        return result;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            JavaMethodCallElement.$$$reportNull$$$0(8);
        }
        Document document = context.getDocument();
        PsiFile file = context.getFile();
        PsiMethod method = (PsiMethod)this.getObject();
        LookupElement[] allItems = context.getElements();
        boolean overloadsMatter = allItems.length == 1 && this.getUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR) == null;
        boolean hasParams = MethodParenthesesHandler.hasParams((LookupElement)this, (LookupElement[])allItems, (boolean)overloadsMatter, (PsiMethod)method);
        JavaCompletionUtil.insertParentheses(context, (LookupElement)this, overloadsMatter, hasParams);
        int startOffset = context.getStartOffset();
        OffsetKey refStart = context.trackOffset(startOffset, true);
        if (this.myNeedExplicitTypeParameters) {
            this.qualifyMethodCall(file, startOffset, document);
            this.insertExplicitTypeParameters(context, refStart);
        } else if (this.myHelper != null) {
            context.commitDocument();
            this.importOrQualify(document, file, method, startOffset);
        }
        PsiCallExpression methodCall = JavaMethodCallElement.findCallAtOffset(context, context.getOffset(refStart));
        if (methodCall != null) {
            TextRange completedElementRange;
            PsiElement completedElement = methodCall instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)methodCall).getMethodExpression().getReferenceNameElement() : null;
            TextRange textRange = completedElementRange = completedElement == null ? null : completedElement.getTextRange();
            if (completedElementRange == null || completedElementRange.getStartOffset() != context.getStartOffset()) {
                methodCall = null;
            }
        }
        if (methodCall != null) {
            CompletionMemory.registerChosenMethod(method, (PsiCall)methodCall);
            JavaMethodCallElement.handleNegation(context, document, method, methodCall);
        }
        JavaMethodCallElement.startArgumentLiveTemplate(context, method);
        JavaMethodCallElement.showParameterHints((LookupElement)this, context, method, methodCall);
    }

    static PsiCallExpression findCallAtOffset(InsertionContext context, int offset) {
        context.commitDocument();
        return (PsiCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)offset, PsiCallExpression.class, (boolean)false);
    }

    private static void handleNegation(InsertionContext context, Document document, PsiMethod method, PsiCallExpression methodCall) {
        PsiType type2 = method.getReturnType();
        if (context.getCompletionChar() == '!' && type2 != null && PsiType.BOOLEAN.isAssignableFrom(type2)) {
            context.setAddCompletionChar(false);
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
            document.insertString(methodCall.getTextRange().getStartOffset(), (CharSequence)"!");
        }
    }

    private void importOrQualify(Document document, PsiFile file, PsiMethod method, int startOffset) {
        if (this.willBeImported()) {
            PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)startOffset, PsiReferenceExpression.class, (boolean)false);
            if (ref != null && this.myContainingClass != null && !ref.isReferenceTo((PsiElement)method)) {
                ref.bindToElementViaStaticImport(this.myContainingClass);
            }
            return;
        }
        this.qualifyMethodCall(file, startOffset, document);
    }

    @NotNull
    private static Template createArgTemplate(PsiMethod method, int caretOffset, PsiExpressionList argList, TextRange argRange) {
        Template template = TemplateManager.getInstance((Project)method.getProject()).createTemplate("", "");
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            if (i > 0) {
                template.addTextSegment(", ");
            }
            String name = StringUtil.notNullize((String)parameters2[i].getName());
            AutoPopupCompletion expression2 = Registry.is((String)"java.completion.argument.live.template.completion") ? new AutoPopupCompletion() : new ConstantNode(name);
            template.addVariable(name, (Expression)expression2, (Expression)new ConstantNode(name), true);
        }
        boolean finishInsideParens = method.isVarArgs();
        if (finishInsideParens) {
            template.addEndVariable();
        }
        template.addTextSegment(argList.getText().substring(caretOffset - argRange.getStartOffset(), argList.getTextLength()));
        if (!finishInsideParens) {
            template.addEndVariable();
        }
        Template template2 = template;
        if (template2 == null) {
            JavaMethodCallElement.$$$reportNull$$$0(9);
        }
        return template2;
    }

    public static boolean startArgumentLiveTemplate(InsertionContext context, PsiMethod method) {
        int caretOffset;
        PsiExpressionList argList;
        if (method.getParameterList().isEmpty() || context.getCompletionChar() == '\r' || !ParameterInfoController.areParameterTemplatesEnabledOnCompletion()) {
            return false;
        }
        Editor editor = context.getEditor();
        context.commitDocument();
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        PsiCall call = (PsiCall)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiCall.class, (boolean)false);
        PsiExpressionList psiExpressionList = argList = call == null ? null : call.getArgumentList();
        if (argList == null || !argList.isEmpty()) {
            return false;
        }
        TextRange argRange = argList.getTextRange();
        if (!argRange.contains(caretOffset = editor.getCaretModel().getOffset())) {
            return false;
        }
        Template template = JavaMethodCallElement.createArgTemplate(method, caretOffset, argList, argRange);
        context.getDocument().deleteString(caretOffset, argRange.getEndOffset());
        TemplateManager.getInstance((Project)method.getProject()).startTemplate(editor, template);
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (templateState == null) {
            return false;
        }
        JavaMethodCallElement.setupNonFilledArgumentRemoving(editor, templateState);
        editor.putUserData(ARGUMENT_TEMPLATE_ACTIVE, (Object)method);
        Disposer.register((Disposable)templateState, () -> {
            if (editor.getUserData(ARGUMENT_TEMPLATE_ACTIVE) == method) {
                editor.putUserData(ARGUMENT_TEMPLATE_ACTIVE, null);
            }
        });
        return true;
    }

    public static void showParameterHints(LookupElement element, InsertionContext context, PsiMethod method, PsiCallExpression methodCall) {
        if (methodCall == null || methodCall.getContainingFile() instanceof PsiCodeFragment || element.getUserData(JavaMethodMergingContributor.MERGED_ELEMENT) != null) {
            return;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        PsiExpressionList parameterOwner = methodCall.getArgumentList();
        if (parameterOwner == null || !"()".equals(parameterOwner.getText()) || parametersCount == 0 || context.getCompletionChar() == '\r' || context.getCompletionChar() == '\t' || !CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) {
            return;
        }
        Editor editor = context.getEditor();
        if (editor instanceof EditorWindow) {
            return;
        }
        Project project = context.getProject();
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        int limit = JavaMethodCallElement.getCompletionHintsLimit();
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        int afterParenOffset = offset + 1;
        if (afterParenOffset < document.getTextLength() && Character.isJavaIdentifierPart(document.getImmutableCharSequence().charAt(afterParenOffset))) {
            return;
        }
        int braceOffset = offset - 1;
        int numberOfParametersToDisplay = parametersCount > 1 && PsiImplUtil.isVarArgs(method) ? parametersCount - 1 : parametersCount;
        int numberOfCommas = Math.min(numberOfParametersToDisplay, limit) - 1;
        String commas = Registry.is((String)"editor.completion.hints.virtual.comma") ? "" : StringUtil.repeat((String)", ", (int)numberOfCommas);
        document.insertString(offset, (CharSequence)commas);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        MethodParameterInfoHandler handler = new MethodParameterInfoHandler();
        ShowParameterInfoContext infoContext = new ShowParameterInfoContext(editor, project, context.getFile(), offset, braceOffset);
        if (!methodCall.isValid() || handler.findElementForParameterInfo((CreateParameterInfoContext)infoContext) == null) {
            document.deleteString(offset, offset + commas.length());
            return;
        }
        JavaMethodCallElement.setCompletionMode((PsiCall)methodCall, true);
        ParameterInfoController controller = new ParameterInfoController(project, editor, braceOffset, infoContext.getItemsToShow(), null, (PsiElement)methodCall.getArgumentList(), (ParameterInfoHandler)handler, false, false);
        Disposable hintsDisposal = () -> JavaMethodCallElement.setCompletionMode((PsiCall)methodCall, false);
        if (Disposer.isDisposed((Disposable)controller)) {
            Disposer.dispose((Disposable)hintsDisposal);
            document.deleteString(offset, offset + commas.length());
        } else {
            ParameterHintsPass.syncUpdate((PsiElement)methodCall, (Editor)editor);
            Disposer.register((Disposable)controller, (Disposable)hintsDisposal);
        }
    }

    public static int getCompletionHintsLimit() {
        return Math.max(1, Registry.intValue((String)"editor.completion.hints.per.call.limit"));
    }

    public static void setCompletionModeIfNotSet(@NotNull PsiCall expression2, @NotNull Disposable disposable) {
        if (expression2 == null) {
            JavaMethodCallElement.$$$reportNull$$$0(10);
        }
        if (disposable == null) {
            JavaMethodCallElement.$$$reportNull$$$0(11);
        }
        if (!JavaMethodCallElement.isCompletionMode(expression2)) {
            JavaMethodCallElement.setCompletionMode(expression2, true);
            Disposer.register((Disposable)disposable, () -> JavaMethodCallElement.setCompletionMode(expression2, false));
        }
    }

    public static void setCompletionMode(@NotNull PsiCall expression2, boolean value2) {
        if (expression2 == null) {
            JavaMethodCallElement.$$$reportNull$$$0(12);
        }
        expression2.putUserData(COMPLETION_HINTS, (Object)(value2 ? Boolean.TRUE : null));
    }

    public static boolean isCompletionMode(@NotNull PsiCall expression2) {
        if (expression2 == null) {
            JavaMethodCallElement.$$$reportNull$$$0(13);
        }
        return expression2.getUserData(COMPLETION_HINTS) != null;
    }

    private static void setupNonFilledArgumentRemoving(final Editor editor, final TemplateState templateState) {
        final AtomicInteger maxEditedVariable = new AtomicInteger(-1);
        editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                maxEditedVariable.set(Math.max(maxEditedVariable.get(), templateState.getCurrentVariableNumber()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/JavaMethodCallElement$1", "documentChanged"));
            }
        }, (Disposable)templateState);
        templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

            public void currentVariableChanged(@NotNull TemplateState templateState2, Template template, int oldIndex, int newIndex) {
                if (templateState2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                maxEditedVariable.set(Math.max(maxEditedVariable.get(), oldIndex));
            }

            public void beforeTemplateFinished(@NotNull TemplateState state, Template template, boolean brokenOff) {
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (brokenOff) {
                    this.removeUntouchedArguments((TemplateImpl)template);
                }
            }

            private void removeUntouchedArguments(TemplateImpl template) {
                int firstUnchangedVar = maxEditedVariable.get() + 1;
                if (firstUnchangedVar >= template.getVariableCount()) {
                    return;
                }
                TextRange startRange = templateState.getVariableRange(template.getVariableNameAt(firstUnchangedVar));
                TextRange endRange = templateState.getVariableRange(template.getVariableNameAt(template.getVariableCount() - 1));
                if (startRange == null || endRange == null) {
                    return;
                }
                WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), () -> editor.getDocument().deleteString(startRange.getStartOffset(), endRange.getEndOffset()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "templateState";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaMethodCallElement$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "currentVariableChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeTemplateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean mayNeedTypeParameters(@NotNull PsiElement leaf) {
        if (leaf == null) {
            JavaMethodCallElement.$$$reportNull$$$0(14);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiModifierListOwner.class}) == null && PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiConditionalExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiModifierListOwner.class}) == null) {
            return false;
        }
        if (PsiUtil.getLanguageLevel((PsiElement)leaf).isAtLeast(LanguageLevel.JDK_1_8)) {
            return false;
        }
        PsiElement parent = leaf.getParent();
        return !(parent instanceof PsiReferenceExpression) || ((PsiReferenceExpression)parent).getTypeParameters().length <= 0;
    }

    private void insertExplicitTypeParameters(InsertionContext context, OffsetKey refStart) {
        context.commitDocument();
        String typeParams = JavaMethodCallElement.getTypeParamsText(false, (PsiTypeParameterListOwner)this.getObject(), this.getInferenceSubstitutor());
        if (typeParams != null) {
            context.getDocument().insertString(context.getOffset(refStart), (CharSequence)typeParams);
            JavaCompletionUtil.shortenReference(context.getFile(), context.getOffset(refStart));
        }
    }

    private void qualifyMethodCall(PsiFile file, int startOffset, Document document) {
        PsiReference reference = file.findReferenceAt(startOffset);
        if (reference instanceof PsiReferenceExpression && ((PsiReferenceExpression)reference).isQualified()) {
            return;
        }
        PsiMethod method = (PsiMethod)this.getObject();
        if (!method.hasModifierProperty("static")) {
            document.insertString(startOffset, (CharSequence)"this.");
            return;
        }
        if (this.myContainingClass == null) {
            return;
        }
        document.insertString(startOffset, (CharSequence)".");
        JavaCompletionUtil.insertClassReference(this.myContainingClass, file, startOffset);
    }

    @Nullable
    public static String getTypeParamsText(boolean presentable, PsiTypeParameterListOwner owner, PsiSubstitutor substitutor) {
        Object[] parameters2 = owner.getTypeParameters();
        if (parameters2.length == 0) {
            return null;
        }
        List substituted = ContainerUtil.map((Object[])parameters2, parameter2 -> {
            PsiType type2 = substitutor.substitute(parameter2);
            if (type2 instanceof PsiWildcardType) {
                type2 = ((PsiWildcardType)type2).getExtendsBound();
            }
            return PsiUtil.resolveClassInClassTypeOnly((PsiType)type2) == parameter2 ? null : type2;
        });
        if (ContainerUtil.exists((Iterable)substituted, t -> t == null || t instanceof PsiCapturedWildcardType)) {
            return null;
        }
        if (substituted.equals(ContainerUtil.map((Object[])parameters2, TypeConversionUtil::typeParameterErasure))) {
            return null;
        }
        String result = "<" + StringUtil.join((Collection)substituted, (Function)(presentable ? PsiType::getPresentableText : PsiType::getCanonicalText), (String)", ") + ">";
        return result.contains("?") ? null : result;
    }

    public boolean isValid() {
        return super.isValid() && this.myInferenceSubstitutor.isValid() && this.getSubstitutor().isValid();
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this, (boolean)presentation.isReal()));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout((LookupElement)this));
        MemberLookupHelper helper = this.myHelper != null ? this.myHelper : new MemberLookupHelper((PsiMember)this.myMethod, this.myContainingClass, false, false);
        helper.renderElement(presentation, this.myHelper != null, this.myHelper != null && !this.myHelper.willBeImported(), this.getSubstitutor());
        if (!this.myForcedQualifier.isEmpty()) {
            presentation.setItemText(this.myForcedQualifier + presentation.getItemText());
        }
        if (this.myPresentableTypeArgs != null) {
            String itemText = presentation.getItemText();
            assert (itemText != null);
            int i = itemText.indexOf(46);
            if (i > 0) {
                presentation.setItemText(itemText.substring(0, i + 1) + this.myPresentableTypeArgs + itemText.substring(i + 1));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedQualifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierSubstitutor";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaMethodCallElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaMethodCallElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferenceSubstitutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setForcedQualifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setInferenceSubstitutorFromExpectedType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setQualifierSubstitutor";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionModeIfNotSet";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionMode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCompletionMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mayNeedTypeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AutoPopupCompletion
    extends Expression {
        private AutoPopupCompletion() {
        }

        @Nullable
        public Result calculateResult(ExpressionContext context) {
            return new InvokeActionResult(() -> AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor()));
        }

        @Nullable
        public Result calculateQuickResult(ExpressionContext context) {
            return null;
        }

        @Nullable
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return null;
        }
    }
}

