/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NonNls
    private static final String CLONE_METHOD_NAME = "clone";

    private ExceptionUtil() {
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        ArrayList array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownCheckedExceptions(PsiElement ... elements) {
        List<PsiClassType> exceptions;
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if ((exceptions = ExceptionUtil.getThrownExceptions(elements)).isEmpty()) {
            List<PsiClassType> list = exceptions;
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<PsiClassType> list = exceptions = ExceptionUtil.filterOutUncheckedExceptions(exceptions);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<PsiClassType> filterOutUncheckedExceptions(@NotNull List<? extends PsiClassType> exceptions) {
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        ArrayList array = ContainerUtil.newArrayList();
        for (PsiClassType psiClassType : exceptions) {
            if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
            array.add(psiClassType);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(final @NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        final ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            public void visitElement(PsiElement psiElement) {
                PsiElement parent;
                if (psiElement != element && (parent = psiElement.getParent()) instanceof PsiAnonymousClass && !(psiElement instanceof PsiExpressionList)) {
                    return;
                }
                super.visitElement(psiElement);
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                this.visitElement((PsiElement)aClass);
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiReferenceExpression methodRef = expression2.getMethodExpression();
                JavaResolveResult resolveResult = methodRef.advancedResolve(false);
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitMethodCallExpression(expression2);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitNewExpression(expression2);
            }

            public void visitThrowStatement(PsiThrowStatement statement) {
                PsiExpression expr = statement.getException();
                if (expr != null) {
                    ExceptionUtil.addExceptions(result, StreamEx.of((Collection)ExceptionUtil.getPreciseThrowTypes(expr)).select(PsiClassType.class).toList());
                }
                super.visitThrowStatement(statement);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitResourceList(PsiResourceList resourceList) {
                for (PsiResourceListElement listElement : resourceList) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getCloserExceptions(listElement));
                }
                super.visitResourceList(resourceList);
            }

            public void visitTryStatement(PsiTryStatement statement) {
                ExceptionUtil.addExceptions(result, ExceptionUtil.getTryExceptions(statement));
            }
        }
        element.accept((PsiElementVisitor)new Visitor());
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        ArrayList array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiCodeBlock[] resource : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)resource, (PsiElement)resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)tryBlock));
        }
        for (PsiResourceListElement psiResourceListElement : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiResourceListElement.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom((PsiType)exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)psiCodeBlock));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list = ExceptionUtil.getThrownExceptions((PsiElement)finallyBlock);
                if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                    array = ContainerUtil.newArrayList(list);
                } else {
                    ExceptionUtil.addExceptions(array, list);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement place) {
        PsiClassType[] referenceTypes;
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        if (substitutor == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        if (place == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        if ((referenceTypes = method.getThrowsList().getReferencedTypes()).length == 0) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(14);
            }
            return list;
        }
        GlobalSearchScope scope = place.getResolveScope();
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiClassType type2 : referenceTypes) {
            if (!((type2 = PsiClassImplUtil.correctType(substitutor.substitute((PsiType)type2), scope)) instanceof PsiClassType)) continue;
            result.add(type2);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<? extends PsiClassType> exceptions) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        for (PsiClassType psiClassType : exceptions) {
            ExceptionUtil.addException(array, psiClassType);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom((PsiType)exception)) {
                return;
            }
            if (!exception.isAssignableFrom((PsiType)exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @NotNull PsiCallExpression skippedCall) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(19);
        }
        if (skippedCall == null) {
            ExceptionUtil.$$$reportNull$$$0(20);
        }
        Set set = ContainerUtil.notNullize(ExceptionUtil.collectUnhandledExceptions(element, topElement, null, c -> c == skippedCall));
        if (set == null) {
            ExceptionUtil.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        Collection<PsiClassType> collection = ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
        if (collection == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(24);
        }
        Set set = ContainerUtil.notNullize(ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls ? c -> false : expression2 -> {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            return method == PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
        }));
        if (set == null) {
            ExceptionUtil.$$$reportNull$$$0(25);
        }
        return set;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, @NotNull Predicate<? super PsiCallExpression> callFilter) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(26);
        }
        if (callFilter == null) {
            ExceptionUtil.$$$reportNull$$$0(27);
        }
        AbstractCollection unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, callFilter);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression2 = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression2 != null ? ExceptionUtil.collectUnhandledExceptions((PsiElement)qualifierExpression2, topElement, null, callFilter) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass = constructor.getContainingClass();
                PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || !superConstructor.getParameterList().isEmpty()) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.getHandlePlace(element, exceptionType, topElement) != HandlePlace.UNHANDLED) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass != null) {
                    PsiClassInitializer[] initializers = aClass.getInitializers();
                    THashSet thrownByInitializer = new THashSet();
                    for (PsiClassInitializer initializer : initializers) {
                        if (initializer.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions((PsiElement)initializer.getBody(), (PsiElement)initializer, (Set<PsiClassType>)thrownByInitializer, callFilter);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.getHandlePlace((PsiElement)constructor.getBody(), thrown, topElement) != HandlePlace.UNHANDLED) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, (Set<PsiClassType>)foundExceptions, callFilter);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult;
        PsiElement resolve;
        if (methodReferenceExpression == null) {
            ExceptionUtil.$$$reportNull$$$0(28);
        }
        if ((resolve = (resolveResult = methodReferenceExpression.advancedResolve(false)).getElement()) instanceof PsiMethod) {
            PsiElement referenceNameElement2 = methodReferenceExpression.getReferenceNameElement();
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve, referenceNameElement2, topElement, () -> ((JavaResolveResult)resolveResult).getSubstitutor());
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(29);
            }
            return list;
        }
        List<PsiClassType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(30);
        }
        return list;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        PsiStatement[] statements;
        if (constructorBody == null) {
            ExceptionUtil.$$$reportNull$$$0(31);
        }
        if ((statements = constructorBody.getStatements()).length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final @NotNull PsiElement[] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(32);
        }
        final ArrayList array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getOwnUnhandledExceptions(element));
                super.visitElement(element);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                if (ArrayUtil.find((Object[])elements, (Object)expression2) >= 0) {
                    this.visitElement((PsiElement)expression2);
                }
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ArrayUtil.find((Object[])elements, (Object)expression2) >= 0) {
                    this.visitElement((PsiElement)expression2);
                }
            }

            public void visitClass(PsiClass aClass) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExceptionUtil$1", "visitMethodReferenceExpression"));
            }
        };
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)visitor);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getOwnUnhandledExceptions(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(34);
        }
        if (element instanceof PsiEnumConstant) {
            PsiMethod method = ((PsiEnumConstant)element).resolveMethod();
            if (method != null) {
                List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(method, element, null, () -> PsiSubstitutor.EMPTY);
                if (list == null) {
                    ExceptionUtil.$$$reportNull$$$0(35);
                }
                return list;
            }
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(36);
            }
            return list;
        }
        if (element instanceof PsiCallExpression) {
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)element, null);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        if (element instanceof PsiThrowStatement) {
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiThrowStatement)element, null);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiMethodReferenceExpression)element, null);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(39);
            }
            return list;
        }
        if (element instanceof PsiResourceListElement) {
            List<PsiClassType> list = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, null);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(40);
            }
            return list;
        }
        List<PsiClassType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(41);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(42);
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{element});
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            ExceptionUtil.$$$reportNull$$$0(44);
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, c -> false);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(45);
        }
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, @NotNull Predicate<? super PsiCallExpression> skipCondition) {
        block20: {
            block21: {
                if (methodCall == null) {
                    ExceptionUtil.$$$reportNull$$$0(46);
                }
                if (skipCondition == null) {
                    ExceptionUtil.$$$reportNull$$$0(47);
                }
                if (MethodCandidateInfo.isOverloadCheck()) {
                    v0 = Collections.emptyList();
                    if (v0 == null) {
                        ExceptionUtil.$$$reportNull$$$0(48);
                    }
                    return v0;
                }
                properties = MethodCandidateInfo.getCurrentMethod((PsiElement)methodCall.getArgumentList());
                result = properties != null ? properties.getInfo() : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)methodCall);
                element = result.getElement();
                v1 = method = element instanceof PsiMethod != false ? (PsiMethod)element : null;
                if (method == null) {
                    v2 = Collections.emptyList();
                    if (v2 == null) {
                        ExceptionUtil.$$$reportNull$$$0(49);
                    }
                    return v2;
                }
                if (skipCondition.test((PsiCallExpression)methodCall)) {
                    v3 = Collections.emptyList();
                    if (v3 == null) {
                        ExceptionUtil.$$$reportNull$$$0(50);
                    }
                    return v3;
                }
                if (properties != null) {
                    PsiUtilCore.ensureValid((PsiElement)method);
                }
                if ((thrownExceptions = method.getThrowsList().getReferencedTypes()).length == 0) {
                    v4 = Collections.emptyList();
                    if (v4 == null) {
                        ExceptionUtil.$$$reportNull$$$0(51);
                    }
                    return v4;
                }
                if (ExceptionUtil.isArrayClone(method, (PsiElement)methodCall) || !(methodCall instanceof PsiMethodCallExpression)) break block20;
                containingFile = methodCall.getContainingFile();
                processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
                try {
                    PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                    candidates = ContainerUtil.mapNotNull(processor.getResults(), (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getUnhandledExceptions$5(com.intellij.psi.PsiMethod com.intellij.psi.infos.CandidateInfo ), (Lcom/intellij/psi/infos/CandidateInfo;)Lcom/intellij/openapi/util/Pair;)((PsiMethod)method));
                    if (candidates.isEmpty()) break block20;
                    scope = methodCall.getResolveScope();
                    ex = ExceptionUtil.collectSubstituted(result.getSubstitutor(), thrownExceptions, scope);
lbl40:
                    // 2 sources

                    for (Pair pair : candidates) {
                        exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            v5 = Collections.emptyList();
                            break block21;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl58
                }
                catch (MethodProcessorSetupFailedException ignore) {
                    v6 = Collections.emptyList();
                    if (v6 == null) {
                        ExceptionUtil.$$$reportNull$$$0(54);
                    }
                    return v6;
                }
            }
            if (v5 == null) {
                ExceptionUtil.$$$reportNull$$$0(52);
            }
            return v5;
lbl-1000:
            // 1 sources

            {
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                ** GOTO lbl40
lbl58:
                // 1 sources

                v7 = ExceptionUtil.getUnhandledExceptions((PsiElement)methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY));
            }
            if (v7 == null) {
                ExceptionUtil.$$$reportNull$$$0(53);
            }
            return v7;
        }
        v8 = ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, (Supplier<PsiSubstitutor>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getSubstitutor(), ()Lcom/intellij/psi/PsiSubstitutor;)((JavaResolveResult)result));
        if (v8 == null) {
            ExceptionUtil.$$$reportNull$$$0(55);
        }
        return v8;
    }

    public static void retainExceptions(List<PsiClassType> ex, List<? extends PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator = ex.iterator();
        while (iterator.hasNext()) {
            PsiClassType classType = iterator.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom((PsiType)classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom((PsiType)psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor, PsiClassType[] thrownExceptions, GlobalSearchScope scope) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiCapturedWildcardType capturedWildcardType;
            PsiType upperBound;
            PsiType psiType = PsiClassImplUtil.correctType(substitutor.substitute((PsiType)thrownException), scope);
            if (psiType instanceof PsiClassType) {
                ex.add((PsiClassType)psiType);
                continue;
            }
            if (!(psiType instanceof PsiCapturedWildcardType) || !((upperBound = (capturedWildcardType = (PsiCapturedWildcardType)psiType).getUpperBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> ex;
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(56);
        }
        List<Object> list = (ex = ExceptionUtil.getExceptionsFromClose(resource)) != null ? ex : Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(57);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(58);
        }
        PsiType type2 = resource.getType();
        List<PsiClassType> list = ExceptionUtil.getUnhandledCloserExceptions((PsiElement)resource, topElement, type2);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(59);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type2) {
        List<PsiClassType> ex = type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, place.getResolveScope()) : null;
        List<PsiClassType> list = ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY)) : Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(60);
        }
        return list;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        PsiType type2 = resource.getType();
        return type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, resource.getResolveScope()) : null;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type2, GlobalSearchScope scope) {
        PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass resourceClass = resourceType.getElement();
        if (resourceClass == null) {
            return null;
        }
        PsiMethod[] methods = PsiUtil.getResourceCloserMethodsForType((PsiClassType)((PsiClassType)type2));
        if (methods != null) {
            List<PsiClassType> ex = null;
            for (PsiMethod method : methods) {
                PsiSubstitutor substitutor;
                PsiClass closerClass = method.getContainingClass();
                if (closerClass == null || (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)closerClass, (PsiClass)resourceClass, (PsiSubstitutor)resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope));
            }
            return ex;
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(61);
        }
        SmartList unhandled = new SmartList();
        for (PsiType type2 : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List types = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types) {
                PsiType upperBound;
                PsiClassType classType = null;
                if (subType instanceof PsiClassType) {
                    classType = (PsiClassType)subType;
                } else if (subType instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)subType).getUpperBound()) instanceof PsiClassType) {
                    classType = (PsiClassType)upperBound;
                }
                if (classType == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace((PsiElement)throwStatement, classType, topElement) != HandlePlace.UNHANDLED) continue;
                unhandled.add(classType);
            }
        }
        SmartList smartList = unhandled;
        if (smartList == null) {
            ExceptionUtil.$$$reportNull$$$0(62);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression2) {
        PsiType type2;
        PsiElement target;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) != null && PsiUtil.isCatchParameter((PsiElement)target)) {
            List list = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(63);
            }
            return list;
        }
        if (expression2 != null && (type2 = expression2.getType()) != null) {
            List<PsiType> list = Collections.singletonList(type2);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(64);
            }
            return list;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(65);
        }
        return list;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull Supplier<PsiSubstitutor> substitutor) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(66);
        }
        if (substitutor == null) {
            ExceptionUtil.$$$reportNull$$$0(67);
        }
        if (ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(68);
            }
            return list;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        if (referencedTypes.length == 0) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(69);
            }
            return list;
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor.get(), referencedTypes);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(70);
        }
        return list;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type2 = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards((PsiType)substitutor.substitute((PsiType)referencedType), (boolean)false), element.getResolveScope());
                if (!(type2 instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type2;
                PsiClass exceptionClass = ((PsiClassType)type2).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace(element, classType, topElement) != HandlePlace.UNHANDLED) continue;
                result.add((PsiClassType)type2);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(71);
        }
        if (!method.getName().equals(CLONE_METHOD_NAME)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression2 = methodCallExpression.getQualifierExpression();
            return qualifierExpression2 != null && qualifierExpression2.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression3 = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression3 != null && qualifierExpression3.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(72);
        }
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Error");
    }

    public static boolean isUncheckedException(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ExceptionUtil.$$$reportNull$$$0(73);
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(74);
        }
        return ExceptionUtil.isGeneralExceptionType((PsiType)type2) || ExceptionUtil.isUncheckedException(type2);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type2) {
        String canonicalText;
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(75);
        }
        return "java.lang.Throwable".equals(canonicalText = type2.getCanonicalText()) || "java.lang.Exception".equals(canonicalText);
    }

    public static boolean isHandled(@NotNull PsiClassType exceptionType, @NotNull PsiElement throwPlace) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(76);
        }
        if (throwPlace == null) {
            ExceptionUtil.$$$reportNull$$$0(77);
        }
        return ExceptionUtil.getHandlePlace(throwPlace, exceptionType, (PsiElement)throwPlace.getContainingFile()) != HandlePlace.UNHANDLED;
    }

    @NotNull
    public static HandlePlace getHandlePlace(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, @Nullable PsiElement topElement) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(78);
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            HandlePlace handlePlace = HandlePlace.UNHANDLED;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(79);
            }
            return handlePlace;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType));
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(80);
            }
            return handlePlace;
        }
        if (parent instanceof PsiClass) {
            if (!(parent instanceof PsiAnonymousClass)) {
                HandlePlace handlePlace = HandlePlace.UNHANDLED;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(81);
                }
                return handlePlace;
            }
            HandlePlace handlePlace = ExceptionUtil.getHandlePlace(parent, exceptionType, topElement);
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(82);
            }
            return handlePlace;
        }
        if (parent instanceof PsiLambdaExpression || parent instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent).getFunctionalInterfaceType();
            HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType));
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(83);
            }
            return handlePlace;
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                HandlePlace handlePlace = HandlePlace.UNHANDLED;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(84);
                }
                return handlePlace;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(85);
                }
                return handlePlace;
            }
        } else if (parent instanceof PsiTryStatement) {
            HandlePlace place;
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && (place = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                HandlePlace handlePlace = place;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(86);
                }
                return handlePlace;
            }
            if (tryStatement.getResourceList() == element && (place = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                HandlePlace handlePlace = place;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(87);
                }
                return handlePlace;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                HandlePlace handlePlace = HandlePlace.UNKNOWN;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(88);
                }
                return handlePlace;
            }
        } else {
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                HandlePlace handlePlace = HandlePlace.fromBoolean(exceptionHandler != null && exceptionHandler.isHandledException(exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(89);
                }
                return handlePlace;
            }
            if (PsiImplUtil.isInServerPage(parent) && parent instanceof PsiFile) {
                HandlePlace handlePlace = HandlePlace.UNKNOWN;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(90);
                }
                return handlePlace;
            }
            if (parent instanceof PsiFile) {
                HandlePlace handlePlace = HandlePlace.fromBoolean(false);
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(91);
                }
                return handlePlace;
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                    HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType));
                    if (handlePlace == null) {
                        ExceptionUtil.$$$reportNull$$$0(92);
                    }
                    return handlePlace;
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : CustomExceptionHandler.KEY.getExtensionList()) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    HandlePlace handlePlace = HandlePlace.UNKNOWN;
                    if (handlePlace == null) {
                        ExceptionUtil.$$$reportNull$$$0(93);
                    }
                    return handlePlace;
                }
            }
        }
        HandlePlace handlePlace = ExceptionUtil.getHandlePlace(parent, exceptionType, topElement);
        if (handlePlace == null) {
            ExceptionUtil.$$$reportNull$$$0(94);
        }
        return handlePlace;
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(95);
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)(resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)interfaceType)))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(96);
        }
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    @NotNull
    private static HandlePlace getCaughtPlace(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(97);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(98);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            HandlePlace handlePlace = HandlePlace.UNKNOWN;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(99);
            }
            return handlePlace;
        }
        for (PsiParameter parameter2 : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter2.getType();
            if (!paramType.isAssignableFrom((PsiType)exceptionType)) continue;
            HandlePlace.TryCatch tryCatch = new HandlePlace.TryCatch(tryStatement, parameter2);
            if (tryCatch == null) {
                ExceptionUtil.$$$reportNull$$$0(100);
            }
            return tryCatch;
        }
        HandlePlace handlePlace = HandlePlace.UNHANDLED;
        if (handlePlace == null) {
            ExceptionUtil.$$$reportNull$$$0(101);
        }
        return handlePlace;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            ExceptionUtil.$$$reportNull$$$0(102);
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(103);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(104);
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(105);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(106);
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(107);
        }
        if (referencedTypes == null) {
            ExceptionUtil.$$$reportNull$$$0(108);
        }
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, PsiSubstitutor.EMPTY);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(109);
        }
        if (referencedTypes == null) {
            ExceptionUtil.$$$reportNull$$$0(110);
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor.substitute((PsiType)classType);
            if (psiType == null || !psiType.isAssignableFrom((PsiType)exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void sortExceptionsByHierarchy(@NotNull List<? extends PsiClassType> exceptions) {
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(111);
        }
        if (exceptions.size() <= 1) {
            return;
        }
        ExceptionUtil.sortExceptionsByHierarchy(exceptions.subList(1, exceptions.size()));
        for (int i = 0; i < exceptions.size() - 1; ++i) {
            if (!TypeConversionUtil.isAssignable((PsiType)((PsiType)exceptions.get(i)), (PsiType)((PsiType)exceptions.get(i + 1)))) continue;
            Collections.swap(exceptions, i, i + 1);
        }
    }

    private static /* synthetic */ Pair lambda$getUnhandledExceptions$5(PsiMethod method, CandidateInfo info) {
        PsiElement element1 = info.getElement();
        if (info instanceof MethodCandidateInfo && element1 != method && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)((PsiMethod)element1)) && !((PsiMethod)element1).hasModifierProperty("private") && !MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)element1), (PsiMethod)method) && (!((MethodCandidateInfo)info).isToInferApplicability() || ((MethodCandidateInfo)info).isApplicable())) {
            return Pair.create((Object)((PsiMethod)element1), (Object)((MethodCandidateInfo)info).getSubstitutor(false));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 99: 
            case 100: 
            case 101: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 99: 
            case 100: 
            case 101: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 99: 
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 5: 
            case 17: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 7: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 11: 
            case 66: 
            case 71: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCall";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callFilter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorBody";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCondition";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 72: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 76: 
            case 78: 
            case 95: 
            case 96: 
            case 98: 
            case 104: 
            case 106: 
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwPlace";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 108: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 1: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownCheckedExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUncheckedExceptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryExceptions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionsByMethod";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnhandledExceptions";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 62: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledExceptions";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnUnhandledExceptions";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloserExceptions";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledCloserExceptions";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreciseThrowTypes";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlePlace";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaughtPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 99: 
            case 100: 
            case 101: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThrownCheckedExceptions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUncheckedExceptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTryExceptions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsByMethod";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addExceptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectUnhandledExceptions";
                break;
            }
            case 28: 
            case 32: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 61: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptions";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "firstStatementIsConstructorCall";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOwnUnhandledExceptions";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getCloserExceptions";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledCloserExceptions";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClone";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedException";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedExceptionOrSuperclass";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralExceptionType";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isHandled";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getHandlePlace";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredBySAMMethod";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "areAllConstructorsThrow";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getCaughtPlace";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesAbruptly";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByMethodThrowsClause";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isHandledBy";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "sortExceptionsByHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 99: 
            case 100: 
            case 101: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HandlePlace {
        public static final HandlePlace UNHANDLED = new HandlePlace(){};
        public static final HandlePlace UNKNOWN = new HandlePlace(){};

        public static HandlePlace fromBoolean(boolean isHandled) {
            return isHandled ? UNKNOWN : UNHANDLED;
        }

        public static class TryCatch
        implements HandlePlace {
            private final PsiTryStatement myTryStatement;
            private final PsiParameter myParameter;

            public TryCatch(PsiTryStatement statement, PsiParameter parameter2) {
                this.myTryStatement = statement;
                this.myParameter = parameter2;
            }

            public PsiTryStatement getTryStatement() {
                return this.myTryStatement;
            }

            public PsiParameter getParameter() {
                return this.myParameter;
            }
        }
    }
}

