/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.language.twirl.TwirlImports;
import org.gradle.language.twirl.TwirlTemplateFormat;
import org.gradle.play.internal.twirl.TwirlCompilerAdapterV10X;
import org.gradle.play.internal.twirl.VersionedPlayTwirlAdapter;
import org.gradle.scala.internal.reflect.ScalaCodecMapper;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;
import org.gradle.util.CollectionUtils;

class TwirlCompilerAdapterV13X
extends TwirlCompilerAdapterV10X {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("play.twirl.compiler", "scala.io", "scala.util.parsing.input", "scala.collection");
    private static final List<String> DEFAULT_TEMPLATE_IMPORTS = Collections.unmodifiableList(Arrays.asList("_root_.play.twirl.api.TwirlFeatureImports._", "_root_.play.twirl.api.TwirlHelperImports._", "_root_.play.twirl.api.Html", "_root_.play.twirl.api.JavaScript", "_root_.play.twirl.api.Txt", "_root_.play.twirl.api.Xml"));

    public TwirlCompilerAdapterV13X(String twirlVersion, String scalaVersion, VersionedPlayTwirlAdapter playTwirlAdapter) {
        super(twirlVersion, scalaVersion, playTwirlAdapter);
    }

    @Override
    public ScalaMethod getCompileMethod(ClassLoader cl) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(cl, "play.twirl.compiler.TwirlCompiler", "compile", File.class, File.class, File.class, String.class, cl.loadClass("scala.collection.Seq"), cl.loadClass("scala.collection.Seq"), cl.loadClass(ScalaCodecMapper.getClassName()), Boolean.TYPE);
    }

    @Override
    public Object[] createCompileParameters(ClassLoader cl, File file, File sourceDirectory, File destinationDirectory, TwirlImports defaultPlayImports, TwirlTemplateFormat templateFormat, List<String> additionalImports) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ArrayList<String> defaultImports = new ArrayList<String>(DEFAULT_TEMPLATE_IMPORTS);
        defaultImports.addAll(this.playTwirlAdapter.getDefaultImports(defaultPlayImports));
        return new Object[]{file, sourceDirectory, destinationDirectory, templateFormat.getFormatType(), this.toScalaSeq(CollectionUtils.flattenCollections(defaultImports, additionalImports, templateFormat.getTemplateImports()), cl), this.toScalaSeq(Collections.emptyList(), cl), ScalaCodecMapper.create(cl, "UTF-8"), this.isInclusiveDots()};
    }

    private Object toScalaSeq(Collection<?> list, ClassLoader classLoader) {
        ScalaMethod method = ScalaReflectionUtil.scalaMethod(classLoader, "scala.collection.JavaConversions", "asScalaBuffer", List.class);
        return method.invoke(list);
    }

    @Override
    public Iterable<String> getClassLoaderPackages() {
        return SHARED_PACKAGES;
    }

    @Override
    public List<String> getDependencyNotation() {
        if (this.scalaVersion.startsWith("2.12")) {
            return CollectionUtils.flattenCollections(super.getDependencyNotation(), "org.scala-lang.modules:scala-parser-combinators_2.12:1.0.6");
        }
        return super.getDependencyNotation();
    }
}

