/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.model.internal.manage.binding.ManagedProperty;
import org.gradle.model.internal.type.ModelType;

public class NodeInitializerContext<T> {
    private final ModelType<T> modelType;
    private final Spec<ModelType<?>> constraints;
    private final Optional<PropertyContext> propertyContextOptional;

    private NodeInitializerContext(ModelType<T> modelType, Spec<ModelType<?>> constraints, Optional<PropertyContext> propertyContextOptional) {
        this.modelType = modelType;
        this.constraints = constraints;
        this.propertyContextOptional = propertyContextOptional;
    }

    public static <T> NodeInitializerContext<T> forType(ModelType<T> type) {
        return new NodeInitializerContext<T>(type, Specs.<ModelType<?>>satisfyAll(), (Optional<PropertyContext>)Optional.absent());
    }

    public static <T> NodeInitializerContext<T> forExtensibleType(ModelType<T> type, Spec<ModelType<?>> constraints) {
        return new NodeInitializerContext<T>(type, constraints, (Optional<PropertyContext>)Optional.absent());
    }

    public static <T> NodeInitializerContext<T> forProperty(ModelType<T> type, ManagedProperty<?> property, ModelType<?> containingType) {
        return new NodeInitializerContext<T>(type, Specs.<ModelType<?>>satisfyAll(), (Optional<PropertyContext>)Optional.of((Object)new PropertyContext(property.getName(), property.getType(), property.isWritable(), property.isDeclaredAsHavingUnmanagedType(), containingType)));
    }

    public ModelType<T> getModelType() {
        return this.modelType;
    }

    public Spec<ModelType<?>> getConstraints() {
        return this.constraints;
    }

    public Optional<PropertyContext> getPropertyContextOptional() {
        return this.propertyContextOptional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInitializerContext that = (NodeInitializerContext)o;
        return Objects.equal(this.modelType, that.modelType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modelType});
    }

    public static class PropertyContext {
        private final String name;
        private final ModelType<?> type;
        private final boolean writable;
        private final boolean declaredAsHavingUnmanagedType;
        private final ModelType<?> declaringType;

        private PropertyContext(String name, ModelType<?> type, boolean writable, boolean declaredAsHavingUnmanagedType, ModelType<?> declaringType) {
            this.name = name;
            this.type = type;
            this.writable = writable;
            this.declaredAsHavingUnmanagedType = declaredAsHavingUnmanagedType;
            this.declaringType = declaringType;
        }

        public String getName() {
            return this.name;
        }

        public ModelType<?> getType() {
            return this.type;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public boolean isDeclaredAsHavingUnmanagedType() {
            return this.declaredAsHavingUnmanagedType;
        }

        public ModelType<?> getDeclaringType() {
            return this.declaringType;
        }
    }
}

