/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.id;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.regex.Pattern;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.io.BaseEncoding;

public final class UniqueId {
    private static final BaseEncoding ENCODING = BaseEncoding.base32().lowerCase().omitPadding();
    private static final Pattern PATTERN = Pattern.compile("[a-z2-7]{26}");
    private static final Factory<UniqueId> FACTORY = new Factory<UniqueId>(){

        @Override
        public UniqueId create() {
            return UniqueId.generate();
        }
    };
    private final String value;

    public static UniqueId from(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] bytes = new byte[16];
        ByteBuffer.wrap(bytes).putLong(msb).putLong(lsb);
        String value = ENCODING.encode(bytes);
        return new UniqueId(value);
    }

    public static UniqueId from(String string) {
        if (PATTERN.matcher(string).matches()) {
            return new UniqueId(string);
        }
        throw new IllegalArgumentException("Invalid unique ID: " + string);
    }

    public static UniqueId generate() {
        return UniqueId.from(UUID.randomUUID());
    }

    public static Factory<UniqueId> factory() {
        return FACTORY;
    }

    private UniqueId(String value) {
        this.value = value;
    }

    public String asString() {
        return this.value;
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueId uniqueId = (UniqueId)o;
        return this.value.equals(uniqueId.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

