/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.definition;

import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.definition.DefaultInjectedPluginDependency;
import org.gradle.initialization.definition.SelfResolvingPluginRequest;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.util.CollectionUtils;

public class InjectedPluginResolver {
    private final ClassLoaderScope classLoaderScope;

    public InjectedPluginResolver(ClassLoaderScope classLoaderScope) {
        this.classLoaderScope = classLoaderScope;
    }

    public PluginRequests resolveAll(List<DefaultInjectedPluginDependency> requests) {
        if (requests.isEmpty()) {
            return DefaultPluginRequests.EMPTY;
        }
        return new DefaultPluginRequests(this.convert(requests));
    }

    private List<PluginRequestInternal> convert(List<DefaultInjectedPluginDependency> requests) {
        return CollectionUtils.collect(requests, new Transformer<PluginRequestInternal, DefaultInjectedPluginDependency>(){

            @Override
            public PluginRequestInternal transform(DefaultInjectedPluginDependency original) {
                return new SelfResolvingPluginRequest(original.getId(), InjectedPluginResolver.this.classLoaderScope);
            }
        });
    }
}

