/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.internal.impldep.com.googlecode.jatl.Html;
import org.gradle.reporting.HtmlPageBuilder;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.GradleVersion;

public class ProjectPageRenderer
extends ReportRenderer<Project, HtmlPageBuilder<Writer>> {
    private final Transformer<String, Project> namingScheme;

    public ProjectPageRenderer(Transformer<String, Project> namingScheme) {
        this.namingScheme = namingScheme;
    }

    @Override
    public void render(final Project project, final HtmlPageBuilder<Writer> builder) throws IOException {
        final String baseCssLink = builder.requireResource(this.getClass().getResource("/org/gradle/reporting/base-style.css"));
        final String cssLink = builder.requireResource(this.getClass().getResource(this.getReportResourcePath("style.css")));
        final String jqueryLink = builder.requireResource(this.getClass().getResource("/org/gradle/reporting/jquery.min-1.11.0.js"));
        final String jtreeLink = builder.requireResource(this.getClass().getResource(this.getReportResourcePath("jquery.jstree.js")));
        final String scriptLink = builder.requireResource(this.getClass().getResource(this.getReportResourcePath("script.js")));
        builder.requireResource(this.getClass().getResource(this.getReportResourcePath("tree.css")));
        builder.requireResource(this.getClass().getResource(this.getReportResourcePath("d.gif")));
        builder.requireResource(this.getClass().getResource(this.getReportResourcePath("d.png")));
        builder.requireResource(this.getClass().getResource(this.getReportResourcePath("throbber.gif")));
        new Html(builder.getOutput()){
            {
                super(x0);
                this.html();
                this.head();
                ((Html)((Html)this.meta()).httpEquiv("Content-Type")).content("text/html; charset=utf-8");
                ((Html)((Html)this.meta()).httpEquiv("x-ua-compatible")).content("IE=edge");
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href(baseCssLink)).end();
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href(cssLink)).end();
                ((Html)((Html)((Html)this.script()).src(jqueryLink)).charset("utf-8")).end();
                ((Html)((Html)((Html)this.script()).src(jtreeLink)).charset("utf-8")).end();
                ((Html)((Html)((Html)this.script()).src((String)ProjectPageRenderer.this.namingScheme.transform(project))).charset("utf-8")).end();
                ((Html)((Html)((Html)this.script()).src(scriptLink)).charset("utf-8")).end();
                ((Html)((Html)this.title()).text("Dependency reports")).end();
                this.end();
                this.body();
                ((Html)this.div()).id("content");
                ((Html)((Html)this.h1()).text("Dependency Report")).end();
                ((Html)this.div()).classAttr("breadcrumbs");
                ((Html)((Html)((Html)this.a()).href("index.html")).text("Projects")).end();
                this.text(" > ");
                ((Html)((Html)this.span()).id("projectBreacrumb")).end();
                this.end();
                ((Html)((Html)this.div()).id("insight")).end();
                ((Html)((Html)this.div()).id("dependencies")).end();
                ((Html)this.div()).id("footer");
                this.p();
                this.text("Generated by ");
                ((Html)((Html)((Html)this.a()).href("http://www.gradle.org")).text(GradleVersion.current().toString())).end();
                this.text(" at " + builder.formatDate(new Date()));
                this.end();
                this.end();
                this.end();
                this.end();
                this.endAll();
            }
        };
    }

    private String getReportResourcePath(String fileName) {
        return "/org/gradle/api/tasks/diagnostics/htmldependencyreport/" + fileName;
    }
}

