/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal.findbugs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsExecuter;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsResult;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpec;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsWorker;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.SingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class FindBugsWorkerManager {
    public FindBugsResult runWorker(File workingDir, WorkerProcessFactory workerFactory, FileCollection findBugsClasspath, FindBugsSpec spec) throws IOException, InterruptedException {
        FindBugsWorker worker = this.createWorkerProcess(workingDir, workerFactory, findBugsClasspath, spec);
        return worker.runFindbugs(spec);
    }

    private FindBugsWorker createWorkerProcess(File workingDir, WorkerProcessFactory workerFactory, FileCollection findBugsClasspath, FindBugsSpec spec) {
        SingleRequestWorkerProcessBuilder<FindBugsExecuter> builder = workerFactory.singleRequestWorker(FindBugsWorker.class, FindBugsExecuter.class);
        builder.setBaseName("Gradle FindBugs Worker");
        builder.applicationClasspath(findBugsClasspath);
        builder.sharedPackages(Arrays.asList("edu.umd.cs.findbugs"));
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir(workingDir);
        javaCommand.setMaxHeapSize(spec.getMaxHeapSize());
        javaCommand.jvmArgs(spec.getJvmArgs());
        return builder.build();
    }
}

