/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.bean;

import java.util.Map;
import org.gradle.api.internal.tasks.properties.PropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.bean.IterableRuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.MapRuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.NestedRuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RootRuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNode;

public class RuntimeBeanNodeFactory {
    private final PropertyMetadataStore metadataStore;

    public RuntimeBeanNodeFactory(PropertyMetadataStore metadataStore) {
        this.metadataStore = metadataStore;
    }

    public RuntimeBeanNode<?> createRoot(Object bean) {
        return new RootRuntimeBeanNode(bean, this.metadataStore.getTypeMetadata(bean.getClass()));
    }

    public RuntimeBeanNode<?> create(RuntimeBeanNode parentNode, String propertyName, Object bean) {
        parentNode.checkCycles(propertyName, bean);
        TypeMetadata typeMetadata = this.metadataStore.getTypeMetadata(bean.getClass());
        if (!typeMetadata.hasAnnotatedProperties()) {
            if (bean instanceof Map) {
                return new MapRuntimeBeanNode(parentNode, propertyName, (Map)bean, typeMetadata);
            }
            if (bean instanceof Iterable) {
                return new IterableRuntimeBeanNode(parentNode, propertyName, (Iterable)bean, typeMetadata);
            }
        }
        return new NestedRuntimeBeanNode((RuntimeBeanNode<?>)parentNode, propertyName, bean, typeMetadata);
    }
}

