/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.DefaultClasspathEntrySnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class PreviousCompilationOutputAnalyzer {
    private static final Logger LOG = Logging.getLogger(PreviousCompilationOutputAnalyzer.class);
    private final DefaultClasspathEntrySnapshotter snapshotter;

    public PreviousCompilationOutputAnalyzer(FileHasher fileHasher, StreamHasher streamHasher, ClassDependenciesAnalyzer analyzer, FileOperations fileOperations) {
        this.snapshotter = new DefaultClasspathEntrySnapshotter(fileHasher, streamHasher, analyzer, fileOperations);
    }

    public ClassSetAnalysis getAnalysis(File classesDirectory) {
        Timer clock = Time.startTimer();
        HashCode unusedHashCode = HashCode.fromInt(0);
        ClasspathEntrySnapshot snapshot = this.snapshotter.createSnapshot(unusedHashCode, classesDirectory);
        LOG.info("Class dependency analysis for incremental compilation took {}.", clock.getElapsed());
        return snapshot.getClassAnalysis();
    }
}

