/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractLockableProperty;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.provider.Provider;

public abstract class LockableCollectionProperty<T, C extends Collection<T>>
extends AbstractLockableProperty<C>
implements CollectionPropertyInternal<T, C> {
    private CollectionPropertyInternal<T, C> delegate;

    public LockableCollectionProperty(CollectionPropertyInternal<T, C> delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    public void add(T element) {
        this.assertNotLocked();
        this.delegate.add(element);
    }

    @Override
    public void add(Provider<? extends T> provider) {
        this.assertNotLocked();
        this.delegate.add(provider);
    }

    @Override
    public void addAll(Provider<? extends Iterable<? extends T>> provider) {
        this.assertNotLocked();
        this.delegate.addAll(provider);
    }

    @Override
    public void addAll(Iterable<? extends T> elements) {
        this.assertNotLocked();
        this.delegate.addAll(elements);
    }

    @Override
    public void addAll(T ... elements) {
        this.assertNotLocked();
        this.delegate.addAll(elements);
    }

    @Override
    public void set(@Nullable Iterable<? extends T> elements) {
        this.assertNotLocked();
        this.delegate.set(elements);
    }

    @Override
    public void set(Provider<? extends Iterable<? extends T>> provider) {
        this.assertNotLocked();
        this.delegate.set(provider);
    }

    @Override
    public void lockNow() {
        super.lockNow();
        this.delegate = null;
    }
}

