/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.TimestampStorage;

public class ProjectTimestamps {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.storage.ProjectTimestamps");
    private static final String TIMESTAMP_STORAGE = "timestamps";
    private final TimestampStorage myTimestamps;
    private final File myTimestampsRoot;

    public ProjectTimestamps(File dataStorageRoot, BuildTargetsState targetsState) throws IOException {
        this.myTimestampsRoot = new File(dataStorageRoot, TIMESTAMP_STORAGE);
        this.myTimestamps = new TimestampStorage(new File(this.myTimestampsRoot, "data"), targetsState);
    }

    public TimestampStorage getStorage() {
        return this.myTimestamps;
    }

    public void clean() throws IOException {
        TimestampStorage timestamps = this.myTimestamps;
        if (timestamps != null) {
            timestamps.wipe();
        } else {
            FileUtil.delete((File)this.myTimestampsRoot);
        }
    }

    public void close() {
        TimestampStorage timestamps = this.myTimestamps;
        if (timestamps != null) {
            try {
                timestamps.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                FileUtil.delete((File)this.myTimestampsRoot);
            }
        }
    }
}

