/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.variable;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrInplaceVariableIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceLocalVariableProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyIntroduceVariableDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyIntroduceVariableSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyVariableValidator;

public class GrIntroduceVariableHandler
extends GrIntroduceHandlerBase<GroovyIntroduceVariableSettings, GrControlFlowOwner> {
    public static final String DUMMY_NAME = "________________xxx_________________";
    protected static final String REFACTORING_NAME = GroovyRefactoringBundle.message("introduce.variable.title", new Object[0]);
    private RangeMarker myPosition = null;

    @NotNull
    protected GrControlFlowOwner[] findPossibleScopes(GrExpression selectedExpr, GrVariable variable, StringPartInfo stringPartInfo, Editor editor) {
        GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(stringPartInfo != null ? stringPartInfo.getLiteral() : selectedExpr);
        if (scope == null) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", REFACTORING_NAME));
        }
        if (!GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(scope)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", REFACTORING_NAME));
        }
        GrControlFlowOwner[] grControlFlowOwnerArray = new GrControlFlowOwner[]{scope};
        if (grControlFlowOwnerArray == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        return grControlFlowOwnerArray;
    }

    @Override
    protected void checkExpression(@NotNull GrExpression selectedExpr) {
        PsiElement parent2;
        if (selectedExpr == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        for (parent2 = selectedExpr.getParent(); parent2 != null && !(parent2 instanceof GroovyFileBase) && !(parent2 instanceof GrParameter); parent2 = parent2.getParent()) {
        }
        if (GrIntroduceVariableHandler.checkInFieldInitializer(selectedExpr)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", new Object[0]));
        }
        if (parent2 instanceof GrParameter) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.method.parameters", new Object[0]));
        }
    }

    @Override
    protected void checkVariable(@NotNull GrVariable variable) throws GrRefactoringError {
        if (variable == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(2);
        }
        throw new GrRefactoringError(null);
    }

    @Override
    protected void checkStringLiteral(@NotNull StringPartInfo info) throws GrRefactoringError {
        if (info == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(3);
        }
    }

    @Override
    protected void checkOccurrences(@NotNull PsiElement[] occurrences) {
        if (occurrences == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(4);
        }
    }

    private static boolean checkInFieldInitializer(@NotNull GrExpression expr) {
        PsiElement parent2;
        if (expr == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(5);
        }
        if ((parent2 = expr.getParent()) instanceof GrClosableBlock) {
            return false;
        }
        if (parent2 instanceof GrField && expr == ((GrField)parent2).getInitializerGroovy()) {
            return true;
        }
        if (parent2 instanceof GrExpression) {
            return GrIntroduceVariableHandler.checkInFieldInitializer((GrExpression)parent2);
        }
        return false;
    }

    @Override
    public GrVariable runRefactoring(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings) {
        if (context == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(7);
        }
        GrVariable insertedVar = this.processExpression(context, settings);
        this.moveOffsetToPositionMarker(context.getEditor());
        return insertedVar;
    }

    private void moveOffsetToPositionMarker(Editor editor) {
        if (editor != null && this.getPositionMarker() != null) {
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(this.getPositionMarker().getEndOffset());
        }
    }

    protected GrInplaceVariableIntroducer getIntroducer(@NotNull GrIntroduceContext context, @NotNull OccurrencesChooser.ReplaceChoice choice) {
        GrStatement anchor;
        if (context == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(8);
        }
        if (choice == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(9);
        }
        final Ref contextRef = Ref.create((Object)context);
        if (context.getStringPart() != null) {
            this.extractStringPart((Ref<GrIntroduceContext>)contextRef);
        }
        if ((anchor = GrIntroduceVariableHandler.findAnchor(context = (GrIntroduceContext)contextRef.get(), choice == OccurrencesChooser.ReplaceChoice.ALL)).getParent() instanceof GrControlStatement) {
            this.addBraces(anchor, (Ref<GrIntroduceContext>)contextRef);
        }
        return new GrInplaceVariableIntroducer(this.getRefactoringName(), choice, (GrIntroduceContext)contextRef.get()){

            @Override
            protected GrVariable runRefactoring(GrIntroduceContext context, GroovyIntroduceVariableSettings settings, boolean processUsages) {
                return this.refactorInWriteAction((Computable<GrVariable>)((Computable)() -> processUsages ? GrIntroduceVariableHandler.this.processExpression(context, settings) : GrIntroduceVariableHandler.addVariable(context, settings)));
            }

            protected void performPostIntroduceTasks() {
                super.performPostIntroduceTasks();
                GrIntroduceVariableHandler.this.moveOffsetToPositionMarker(((GrIntroduceContext)contextRef.get()).getEditor());
            }
        };
    }

    private static GrVariable addVariable(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings) {
        if (context == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(11);
        }
        GrStatement anchor = GrIntroduceVariableHandler.findAnchor(context, settings.replaceAllOccurrences());
        PsiElement parent2 = anchor.getParent();
        assert (parent2 instanceof GrStatementOwner);
        GrVariableDeclaration generated = GrIntroduceVariableHandler.generateDeclaration(context, settings);
        GrStatement declaration = ((GrStatementOwner)parent2).addStatementBefore(generated, anchor);
        declaration = (GrStatement)JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)declaration);
        return ((GrVariableDeclaration)declaration).getVariables()[0];
    }

    protected void showScopeChooser(GrControlFlowOwner[] scopes, Pass<GrControlFlowOwner> callback, Editor editor) {
    }

    @NotNull
    private static GrVariableDeclaration generateDeclaration(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings) {
        String[] stringArray;
        if (context == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(13);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.getProject());
        if (settings.isDeclareFinal()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "final";
        } else {
            stringArray = null;
        }
        String[] modifiers = stringArray;
        GrVariableDeclaration declaration = factory.createVariableDeclaration(modifiers, "foo", settings.getSelectedType(), settings.getName());
        GrIntroduceVariableHandler.generateInitializer(context, declaration.getVariables()[0]);
        GrVariableDeclaration grVariableDeclaration = declaration;
        if (grVariableDeclaration == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(14);
        }
        return grVariableDeclaration;
    }

    @NotNull
    private GrVariable processExpression(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings) {
        if (context == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(16);
        }
        GrVariableDeclaration varDecl = GrIntroduceVariableHandler.generateDeclaration(context, settings);
        if (context.getStringPart() != null) {
            GrExpression ref = context.getStringPart().replaceLiteralWithConcatenation(DUMMY_NAME);
            GrVariable grVariable = this.doProcessExpression(context, settings, varDecl, new PsiElement[]{ref}, ref, true);
            if (grVariable == null) {
                GrIntroduceVariableHandler.$$$reportNull$$$0(17);
            }
            return grVariable;
        }
        GrExpression expression = context.getExpression();
        assert (expression != null);
        GrVariable grVariable = this.doProcessExpression(context, settings, varDecl, context.getOccurrences(), expression, true);
        if (grVariable == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(18);
        }
        return grVariable;
    }

    private GrVariable doProcessExpression(final @NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings, @NotNull GrVariableDeclaration varDecl, @NotNull PsiElement[] elements, @NotNull GrExpression expression, boolean processUsages) {
        if (context == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(19);
        }
        if (settings == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(20);
        }
        if (varDecl == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(21);
        }
        if (elements == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(22);
        }
        if (expression == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(23);
        }
        return new GrIntroduceLocalVariableProcessor(context, settings, elements, expression, processUsages){

            @Override
            protected void refreshPositionMarker(PsiElement e) {
                GrIntroduceVariableHandler.this.refreshPositionMarker(context.getEditor().getDocument().createRangeMarker(e.getTextRange()));
            }
        }.processExpression(varDecl);
    }

    @NotNull
    private static GrExpression generateInitializer(@NotNull GrIntroduceContext context, @NotNull GrVariable variable) {
        if (context == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(24);
        }
        if (variable == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(25);
        }
        GrExpression initializer = context.getStringPart() != null ? context.getStringPart().createLiteralFromSelected() : context.getExpression();
        GrExpression dummyInitializer = variable.getInitializerGroovy();
        assert (dummyInitializer != null);
        GrExpression grExpression = dummyInitializer.replaceWithExpression(initializer, true);
        if (grExpression == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(26);
        }
        return grExpression;
    }

    void refreshPositionMarker(RangeMarker marker) {
        this.myPosition = marker;
    }

    private RangeMarker getPositionMarker() {
        return this.myPosition;
    }

    @Override
    @NotNull
    protected String getRefactoringName() {
        String string = REFACTORING_NAME;
        if (string == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getHelpID() {
        if ("refactoring.introduceVariable" == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(28);
        }
        return "refactoring.introduceVariable";
    }

    @NotNull
    protected GroovyIntroduceVariableDialog getDialog(@NotNull GrIntroduceContext context) {
        if (context == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(29);
        }
        GroovyVariableValidator validator = new GroovyVariableValidator(context);
        GroovyIntroduceVariableDialog groovyIntroduceVariableDialog = new GroovyIntroduceVariableDialog(context, validator);
        if (groovyIntroduceVariableDialog == null) {
            GrIntroduceVariableHandler.$$$reportNull$$$0(30);
        }
        return groovyIntroduceVariableDialog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/variable/GrIntroduceVariableHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedExpr";
                break;
            }
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choice";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varDecl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findPossibleScopes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/variable/GrIntroduceVariableHandler";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDeclaration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "processExpression";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "generateInitializer";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpID";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkVariable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkStringLiteral";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkOccurrences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkInFieldInitializer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIntroducer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addVariable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateDeclaration";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doProcessExpression";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "generateInitializer";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

