/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public abstract class MvcActionBase
extends DumbAwareAction {
    protected abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Module var2, @NotNull MvcFramework var3);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Pair<MvcFramework, Module> pair;
        if (e == null) {
            MvcActionBase.$$$reportNull$$$0(0);
        }
        if ((pair = MvcActionBase.guessFramework(e)) != null && this.isSupported((MvcFramework)pair.getFirst(), (Module)pair.getSecond())) {
            this.actionPerformed(e, (Module)pair.getSecond(), (MvcFramework)pair.getFirst());
        }
    }

    protected boolean isFrameworkSupported(@NotNull MvcFramework framework) {
        if (framework == null) {
            MvcActionBase.$$$reportNull$$$0(1);
        }
        return true;
    }

    protected boolean isSupported(@NotNull MvcFramework framework, @NotNull Module module) {
        if (framework == null) {
            MvcActionBase.$$$reportNull$$$0(2);
        }
        if (module == null) {
            MvcActionBase.$$$reportNull$$$0(3);
        }
        return this.isFrameworkSupported(framework);
    }

    @Nullable
    public static Pair<MvcFramework, Module> guessFramework(AnActionEvent event) {
        Project project;
        Module module = (Module)event.getData(ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()) ? LangDataKeys.MODULE : LangDataKeys.MODULE_CONTEXT);
        if (module != null) {
            MvcFramework framework;
            MvcFramework commonPluginModuleFramework = MvcFramework.findCommonPluginModuleFramework(module);
            if (commonPluginModuleFramework != null) {
                for (Module mod : ModuleManager.getInstance((Project)module.getProject()).getModules()) {
                    if (!commonPluginModuleFramework.getCommonPluginsModuleName(mod).equals(module.getName())) continue;
                    if (commonPluginModuleFramework.hasSupport(mod)) {
                        return Pair.create((Object)commonPluginModuleFramework, (Object)mod);
                    }
                    return null;
                }
            }
            if ((framework = MvcFramework.getInstance(module)) != null) {
                return Pair.create((Object)framework, (Object)module);
            }
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext())) == null) {
            return null;
        }
        Pair result2 = null;
        for (Module mod : ModuleManager.getInstance((Project)project).getModules()) {
            MvcFramework framework = MvcFramework.getInstance(mod);
            if (framework == null) continue;
            if (result2 != null) {
                return null;
            }
            result2 = Pair.create((Object)framework, (Object)mod);
        }
        return result2;
    }

    public final void update(@NotNull AnActionEvent event) {
        Pair<MvcFramework, Module> pair;
        if (event == null) {
            MvcActionBase.$$$reportNull$$$0(4);
        }
        if ((pair = MvcActionBase.guessFramework(event)) != null && this.isSupported((MvcFramework)pair.getFirst(), (Module)pair.getSecond())) {
            event.getPresentation().setVisible(true);
            this.updateView(event, (MvcFramework)pair.getFirst(), (Module)pair.getSecond());
        } else {
            event.getPresentation().setVisible(false);
        }
    }

    protected void updateView(AnActionEvent event, @NotNull MvcFramework framework, @NotNull Module module) {
        if (framework == null) {
            MvcActionBase.$$$reportNull$$$0(5);
        }
        if (module == null) {
            MvcActionBase.$$$reportNull$$$0(6);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFrameworkSupported";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

