/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.KotlinUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.typing.GrCallTypeCalculator;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/ClosureMethodsCallTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrCallTypeCalculator;", "()V", "getType", "Lcom/intellij/psi/PsiType;", "receiver", "method", "Lcom/intellij/psi/PsiMethod;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "context", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.groovy.psi"})
public final class ClosureMethodsCallTypeCalculator
implements GrCallTypeCalculator {
    private static final Set<String> interestingNames;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PsiType getType(@Nullable PsiType receiver, @NotNull PsiMethod method, @Nullable List<? extends Argument> arguments2, @NotNull PsiElement context) {
        PsiType psiType;
        Object[] argumentTypes;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(receiver instanceof GrClosureType)) {
            return null;
        }
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (!interestingNames.contains(methodName)) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"groovy.lang.Closure") ^ true) {
            return null;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"memoize")) {
            return receiver;
        }
        List<? extends Argument> list = arguments2;
        if (list != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void receiver2;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PsiType psiType2 = ((Argument)receiver2).getType();
                collection.add(psiType2);
            }
            Collection collection = (List)destination$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiType.EMPTY_ARRAY, (String)"PsiType.EMPTY_ARRAY");
            objectArray = (PsiType[])KotlinUtils.toArray((Collection)collection, (Object[])PsiType.EMPTY_ARRAY);
        } else {
            objectArray = argumentTypes = null;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"call")) {
            return GrClosureSignatureUtil.getReturnType(((GrClosureType)receiver).getSignatures(), argumentTypes, context);
        }
        if (arguments2 == null || argumentTypes == null) {
            return null;
        }
        switch (methodName) {
            case "rcurry": {
                psiType = ((GrClosureType)receiver).curry((PsiType[])argumentTypes, -1, context);
                break;
            }
            case "trampoline": 
            case "curry": {
                psiType = ((GrClosureType)receiver).curry((PsiType[])argumentTypes, 0, context);
                break;
            }
            case "ncurry": {
                Integer value;
                GrLiteral literal;
                Object object = CollectionsKt.firstOrNull(arguments2);
                if (!(object instanceof ExpressionArgument)) {
                    object = null;
                }
                ExpressionArgument expressionArgument = (ExpressionArgument)object;
                GrExpression grExpression = expressionArgument != null ? expressionArgument.getExpression() : null;
                if (!(grExpression instanceof GrLiteral)) {
                    grExpression = null;
                }
                GrLiteral grLiteral = literal = (GrLiteral)grExpression;
                Object object2 = grLiteral != null ? grLiteral.getValue() : null;
                if (!(object2 instanceof Integer)) {
                    object2 = null;
                }
                if ((value = (Integer)object2) != null) {
                    GrClosureType grClosureType = (GrClosureType)receiver;
                    Collection collection = ArraysKt.drop((Object[])argumentTypes, (int)1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)PsiType.EMPTY_ARRAY, (String)"PsiType.EMPTY_ARRAY");
                    psiType = grClosureType.curry((PsiType[])KotlinUtils.toArray((Collection)collection, (Object[])PsiType.EMPTY_ARRAY), value, context);
                    break;
                }
                psiType = receiver;
                break;
            }
            default: {
                psiType = null;
            }
        }
        return psiType;
    }

    static {
        Companion = new Companion(null);
        interestingNames = SetsKt.setOf((Object[])new String[]{"call", "curry", "ncurry", "rcurry", "memoize", "trampoline"});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/ClosureMethodsCallTypeCalculator$Companion;", "", "()V", "interestingNames", "", "", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

