/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReferenceBase;
import org.jetbrains.plugins.groovy.lang.resolve.impl.CallReferenceImplKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006j\u0004\u0018\u0001`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrUnaryOperatorReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCallReferenceBase;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrUnaryExpression;", "element", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrUnaryExpression;)V", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getArguments", "()Ljava/util/List;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "receiver", "Lcom/intellij/psi/PsiType;", "getReceiver", "()Lcom/intellij/psi/PsiType;", "doResolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "incomplete", "", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "Companion", "intellij.groovy.psi"})
public final class GrUnaryOperatorReference
extends GroovyMethodCallReferenceBase<GrUnaryExpression> {
    private static final Map<IElementType, String> unaryOperatorMethodNames;
    public static final Companion Companion;

    @NotNull
    public TextRange getRangeInElement() {
        GrUnaryExpression grUnaryExpression = (GrUnaryExpression)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)grUnaryExpression, (String)"element");
        PsiElement psiElement = grUnaryExpression.getOperationToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.operationToken");
        TextRange textRange = psiElement.getTextRangeInParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.operationToken.textRangeInParent");
        return textRange;
    }

    @Override
    @Nullable
    public PsiType getReceiver() {
        GrUnaryExpression grUnaryExpression = (GrUnaryExpression)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)grUnaryExpression, (String)"element");
        GrExpression grExpression = grUnaryExpression.getOperand();
        return grExpression != null ? grExpression.getType() : null;
    }

    @Override
    @NotNull
    public String getMethodName() {
        GrUnaryExpression grUnaryExpression = (GrUnaryExpression)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)grUnaryExpression, (String)"element");
        String string = unaryOperatorMethodNames.get(grUnaryExpression.getOperationTokenType());
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    @Nullable
    public List<Argument> getArguments() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<GroovyResolveResult> doResolve(boolean incomplete) {
        return CallReferenceImplKt.resolveImpl2(this, incomplete);
    }

    public GrUnaryOperatorReference(@NotNull GrUnaryExpression element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super((PsiElement)element);
    }

    static {
        Companion = new Companion(null);
        unaryOperatorMethodNames = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)GroovyElementTypes.T_NOT, (Object)"asBoolean"), TuplesKt.to((Object)GroovyElementTypes.T_PLUS, (Object)"positive"), TuplesKt.to((Object)GroovyElementTypes.T_MINUS, (Object)"negative"), TuplesKt.to((Object)GroovyElementTypes.T_DEC, (Object)"previous"), TuplesKt.to((Object)GroovyElementTypes.T_INC, (Object)"next"), TuplesKt.to((Object)GroovyElementTypes.T_BNOT, (Object)"bitwiseNegate")});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrUnaryOperatorReference$Companion;", "", "()V", "unaryOperatorMethodNames", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

