/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionReferenceKt;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunner;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCachingReference;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.OverloadsKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyRValueProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodProcessor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrExplicitMethodCallReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCachingReference;", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl;", "ref", "(Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl;)V", "doResolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "incomplete", "", "intellij.groovy.psi"})
public final class GrExplicitMethodCallReference
extends GroovyCachingReference<GrReferenceExpressionImpl> {
    @Override
    @NotNull
    public Collection<GroovyResolveResult> doResolve(boolean incomplete) {
        boolean bl;
        boolean bl2 = bl = !incomplete;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        GrReferenceExpressionImpl grReferenceExpressionImpl = (GrReferenceExpressionImpl)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)grReferenceExpressionImpl, (String)"element");
        GrReferenceExpressionImpl ref = grReferenceExpressionImpl;
        String string = ref.getReferenceName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ref.referenceName ?: return emptyList()");
        String name = string;
        PsiElement psiElement = ref.getParent();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall");
        }
        GrMethodCall methodCall = (GrMethodCall)psiElement;
        List<Argument> arguments2 = ArgumentsKt.getArguments(methodCall);
        PsiElement psiElement2 = ref;
        PsiType[] psiTypeArray = ref.getTypeArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"ref.typeArguments");
        MethodProcessor methodProcessor = new MethodProcessor(name, psiElement2, arguments2, psiTypeArray);
        new GrReferenceResolveRunner(ref, (PsiScopeProcessor)methodProcessor).resolveReferenceExpression();
        List<GroovyMethodResult> list = methodProcessor.getApplicableCandidates();
        if (list != null) {
            List<GroovyMethodResult> list2;
            List<GroovyMethodResult> it = list2 = list;
            boolean bl3 = false;
            return it;
        }
        GroovyRValueProcessor propertyProcessor = new GroovyRValueProcessor(name, ref, GrReferenceExpressionReferenceKt.resolveKinds(ref));
        new GrReferenceResolveRunner(ref, propertyProcessor).resolveReferenceExpression();
        List<GroovyResolveResult> properties = propertyProcessor.getResults();
        if (properties.size() == 1) {
            return properties;
        }
        List<GroovyMethodResult> methods = OverloadsKt.filterBySignature(OverloadsKt.filterByArgumentsCount(methodProcessor.getAllCandidates(), arguments2));
        return CollectionsKt.plus((Collection)methods, (Iterable)properties);
    }

    public GrExplicitMethodCallReference(@NotNull GrReferenceExpressionImpl ref) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        super((PsiElement)ref);
    }
}

