/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.BaseMethodResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.MethodResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.impl.OverloadsKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B;\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r\u0012\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000b\u0012\u0004\u0012\u00020\u00130\u001dH\u0002J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020&H\u0016J\u001a\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0013H\u0016R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001c\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000b\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001dj\u0004\u0018\u0001`\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/MethodProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "Lcom/intellij/psi/scope/NameHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind$Hint;", "Lcom/intellij/psi/scope/ElementClassHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/DynamicMembersHint;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "typeArguments", "", "Lcom/intellij/psi/PsiType;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Ljava/util/List;[Lcom/intellij/psi/PsiType;)V", "acceptMore", "", "getAcceptMore", "()Z", "allCandidates", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "getAllCandidates", "()Ljava/util/List;", "applicableCandidates", "getApplicableCandidates", "myApplicable", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/groovy/lang/resolve/impl/ApplicabilitiesResult;", "myCandidates", "Lcom/intellij/util/SmartList;", "[Lcom/intellij/psi/PsiType;", "computeApplicableCandidates", "execute", "element", "state", "Lcom/intellij/psi/ResolveState;", "getName", "handleEvent", "", "event", "Lcom/intellij/psi/scope/PsiScopeProcessor$Event;", "associated", "", "shouldProcess", "kind", "Lcom/intellij/psi/scope/ElementClassHint$DeclarationKind;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "shouldProcessMethods", "intellij.groovy.psi"})
public final class MethodProcessor
extends ProcessorWithHints
implements NameHint,
GroovyResolveKind.Hint,
ElementClassHint,
DynamicMembersHint {
    private final SmartList<GroovyMethodResult> myCandidates;
    private Pair<? extends List<? extends GroovyMethodResult>, Boolean> myApplicable;
    private final String name;
    private final PsiElement place;
    private final List<Argument> arguments;
    private final PsiType[] typeArguments;

    @Nullable
    public String getName(@NotNull ResolveState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return this.name;
    }

    @Override
    public boolean shouldProcess(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        return kind == GroovyResolveKind.METHOD && this.getAcceptMore();
    }

    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return kind == ElementClassHint.DeclarationKind.METHOD && this.getAcceptMore();
    }

    @Override
    public boolean shouldProcessMethods() {
        return this.myCandidates.isEmpty();
    }

    private final boolean getAcceptMore() {
        Pair<? extends List<? extends GroovyMethodResult>, Boolean> pair = this.myApplicable;
        return UtilKt.isNullOrEmpty((Collection)(pair != null ? (List)pair.getFirst() : null));
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Object object;
        BaseMethodResolveResult baseMethodResolveResult;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!this.getAcceptMore()) {
            ResolveUtilKt.getLog().warn("Don't pass more methods if processor doesn't want to accept them");
            return false;
        }
        if (!(element instanceof PsiMethod)) {
            if (Intrinsics.areEqual((Object)((Boolean)state.get(ResolveUtilKt.sorryCannotKnowElementKind)), (Object)true) ^ true) {
                ResolveUtilKt.getLog().error("Unexpected element. " + PsiUtilKt.elementInfo(element));
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)this.name, (Object)ResolveUtilKt.getName(state, (PsiNamedElement)element)) ^ true) {
            return true;
        }
        Collection collection = (Collection)this.myCandidates;
        if (!((PsiMethod)element).hasTypeParameters()) {
            baseMethodResolveResult = new BaseMethodResolveResult((PsiMethod)element, this.place, state, this.arguments);
        } else {
            object = this.typeArguments;
            if (((PsiType[])object).length == 0) {
                baseMethodResolveResult = new MethodResolveResult((PsiMethod)element, this.place, state, this.arguments);
            } else {
                Object object2 = state.get(PsiSubstitutor.KEY);
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"state[PsiSubstitutor.KEY]");
                PsiSubstitutor psiSubstitutor = (PsiSubstitutor)object2;
                PsiTypeParameter[] psiTypeParameterArray = ((PsiMethod)element).getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"element.typeParameters");
                PsiSubstitutor substitutor = InferenceKt.putAll(psiSubstitutor, psiTypeParameterArray, this.typeArguments);
                PsiMethod psiMethod = (PsiMethod)element;
                ResolveState resolveState = state.put(PsiSubstitutor.KEY, (Object)substitutor);
                Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state.put(PsiSubstitutor.KEY, substitutor)");
                baseMethodResolveResult = new BaseMethodResolveResult(psiMethod, this.place, resolveState, this.arguments);
            }
        }
        object = baseMethodResolveResult;
        collection.add(object);
        this.myApplicable = null;
        return true;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && this.myApplicable == null) {
            this.myApplicable = this.computeApplicableCandidates();
        }
    }

    private final Pair<List<GroovyMethodResult>, Boolean> computeApplicableCandidates() {
        return OverloadsKt.findApplicable(OverloadsKt.correctStaticScope((List)this.myCandidates));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<GroovyMethodResult> getApplicableCandidates() {
        void applicableCandidates;
        Object object = this.myApplicable;
        if (object == null) {
            object = this.computeApplicableCandidates();
        }
        Pair<? extends List<? extends GroovyMethodResult>, Boolean> pair = object;
        List list = (List)pair.component1();
        boolean canChooseOverload = (Boolean)pair.component2();
        if (applicableCandidates.isEmpty()) {
            return null;
        }
        List<GroovyMethodResult> filteredBySignature = OverloadsKt.filterBySignature((List<? extends GroovyMethodResult>)applicableCandidates);
        if (canChooseOverload) {
            return OverloadsKt.chooseOverloads(filteredBySignature);
        }
        return filteredBySignature;
    }

    @NotNull
    public final List<GroovyMethodResult> getAllCandidates() {
        return (List)this.myCandidates;
    }

    public MethodProcessor(@NotNull String name, @NotNull PsiElement place, @Nullable List<? extends Argument> arguments2, @NotNull PsiType[] typeArguments) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)typeArguments, (String)"typeArguments");
        this.name = name;
        this.place = place;
        this.arguments = arguments2;
        this.typeArguments = typeArguments;
        this.hint(NameHint.KEY, this);
        this.hint(GroovyResolveKind.HINT_KEY, this);
        this.hint(ElementClassHint.KEY, this);
        this.hint(DynamicMembersHint.KEY, this);
        this.myCandidates = new SmartList();
    }
}

