/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ConstructorProcessor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"classConstructors", "", "Lcom/intellij/psi/PsiMethod;", "clazz", "Lcom/intellij/psi/PsiClass;", "getAllConstructors", "place", "Lcom/intellij/psi/PsiElement;", "runtimeConstructors", "intellij.groovy.psi"})
public final class ConstructorsKt {
    @NotNull
    public static final List<PsiMethod> getAllConstructors(@NotNull PsiClass clazz, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return CollectionsKt.plus((Collection)ConstructorsKt.classConstructors(clazz), (Iterable)ConstructorsKt.runtimeConstructors(clazz, place));
    }

    private static final List<PsiMethod> classConstructors(PsiClass clazz) {
        PsiMethod[] constructors;
        PsiMethod[] psiMethodArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"clazz.constructors");
        PsiMethod[] psiMethodArray2 = constructors = psiMethodArray;
        if (psiMethodArray2.length == 0) {
            return CollectionsKt.listOf((Object)ResolveUtilKt.getDefaultConstructor(clazz));
        }
        List<PsiMethod> list = Arrays.asList(Arrays.copyOf(constructors, constructors.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*constructors)");
        return list;
    }

    private static final List<PsiMethod> runtimeConstructors(PsiClass clazz, PsiElement place) {
        String string = clazz.getName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clazz.name ?: return emptyList()");
        String name = string;
        ConstructorProcessor processor = new ConstructorProcessor(name);
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)clazz.getProject()).createType(clazz);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"JavaPsiFacade.getElement\u2026roject).createType(clazz)");
        PsiClassType qualifierType = psiClassType;
        ResolveUtil.processNonCodeMembers((PsiType)qualifierType, (PsiScopeProcessor)processor, place, ResolveState.initial());
        return processor.getCandidates();
    }
}

