/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityIcons;
import icons.JetgroovyIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionMembersCache;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeDefinitionImpl
extends GrStubElementBase<GrTypeDefinitionStub>
implements GrTypeDefinition,
StubBasedPsiElement<GrTypeDefinitionStub> {
    private final GrTypeDefinitionMembersCache<GrTypeDefinition> myCache;

    public GrTypeDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myCache = new GrTypeDefinitionMembersCache<GrTypeDefinitionImpl>(this);
    }

    protected GrTypeDefinitionImpl(GrTypeDefinitionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
        this.myCache = new GrTypeDefinitionMembersCache<GrTypeDefinitionImpl>(this);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitTypeDefinition(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GroovyFile) {
            String packageName = ((GroovyFile)parent2).getPackageName();
            return !packageName.isEmpty() ? packageName + "." + this.getName() : this.getName();
        }
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && containingClass.getQualifiedName() != null) {
            return containingClass.getQualifiedName() + "." + this.getName();
        }
        return null;
    }

    @Override
    @Nullable
    public GrTypeDefinitionBody getBody() {
        return (GrTypeDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.CLASS_BODY);
    }

    @Override
    @NotNull
    public GrMembersDeclaration[] getMemberDeclarations() {
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            if (GrMembersDeclaration.EMPTY_ARRAY == null) {
                GrTypeDefinitionImpl.$$$reportNull$$$0(2);
            }
            return GrMembersDeclaration.EMPTY_ARRAY;
        }
        GrMembersDeclaration[] grMembersDeclarationArray = body.getMemberDeclarations();
        if (grMembersDeclarationArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(3);
        }
        return grMembersDeclarationArray;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @Nullable
    public GrExtendsClause getExtendsClause() {
        return (GrExtendsClause)this.getStubOrPsiChild(GroovyStubElementTypes.EXTENDS_CLAUSE);
    }

    @Override
    @Nullable
    public GrImplementsClause getImplementsClause() {
        return (GrImplementsClause)this.getStubOrPsiChild(GroovyStubElementTypes.IMPLEMENTS_CLAUSE);
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement result2 = this.findChildByType(TokenSets.PROPERTY_NAMES);
        assert (result2 != null);
        PsiElement psiElement = result2;
        if (psiElement == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        GroovyFileImpl file;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GroovyFileImpl && (file = (GroovyFileImpl)parent2).getTypeDefinitions().length == 1 && !file.isScript()) {
            file.delete();
            return;
        }
        super.delete();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(7);
        }
        return GrClassImplUtil.processDeclarations(this, processor, state, lastParent, place);
    }

    @Override
    public String getName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return PsiImplUtil.getName(this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return GrClassImplUtil.isClassEquivalentTo(this, another);
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isTrait() {
        return false;
    }

    @Nullable
    public PsiReferenceList getExtendsList() {
        return this.getExtendsClause();
    }

    @Nullable
    public PsiReferenceList getImplementsList() {
        return this.getImplementsClause();
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        PsiClassType[] psiClassTypeArray = this.myCache.getExtendsListTypes(includeSynthetic);
        if (psiClassTypeArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(8);
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes(boolean includeSynthetic) {
        PsiClassType[] psiClassTypeArray = this.myCache.getImplementsListTypes(includeSynthetic);
        if (psiClassTypeArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(9);
        }
        return psiClassTypeArray;
    }

    @Nullable
    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this);
    }

    @NotNull
    public PsiClass[] getInterfaces() {
        PsiClass[] psiClassArray = GrClassImplUtil.getInterfaces(this);
        if (psiClassArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public final PsiClass[] getSupers(boolean includeSynthetic) {
        PsiClass[] psiClassArray = GrClassImplUtil.getSupers(this, includeSynthetic);
        if (psiClassArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes(boolean includeSynthetic) {
        PsiClassType[] psiClassTypeArray = GrClassImplUtil.getSuperTypes(this, includeSynthetic);
        if (psiClassTypeArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(12);
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public GrField[] getCodeFields() {
        GrField[] grFieldArray = this.myCache.getCodeFields();
        if (grFieldArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(13);
        }
        return grFieldArray;
    }

    @Override
    public PsiField findCodeFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases, false);
    }

    @Override
    @NotNull
    public GrField[] getFields() {
        GrField[] grFieldArray = this.myCache.getFields();
        if (grFieldArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(14);
        }
        return grFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myCache.getMethods();
        if (psiMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(15);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public GrMethod[] getCodeMethods() {
        GrMethod[] grMethodArray = this.myCache.getCodeMethods();
        if (grMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(16);
        }
        return grMethodArray;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myCache.getConstructors();
        if (psiMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(17);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public GrMethod[] getCodeConstructors() {
        GrMethod[] grMethodArray = this.myCache.getCodeConstructors();
        if (grMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(18);
        }
        return grMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myCache.getInnerClasses();
        if (psiClassArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(19);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public GrTypeDefinition[] getCodeInnerClasses() {
        GrTypeDefinition[] grTypeDefinitionArray = this.myCache.getCodeInnerClasses();
        if (grTypeDefinitionArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(20);
        }
        return grTypeDefinitionArray;
    }

    @Override
    @NotNull
    public GrClassInitializer[] getInitializers() {
        GrTypeDefinitionBody body = this.getBody();
        GrClassInitializer[] grClassInitializerArray = body != null ? body.getInitializers() : GrClassInitializer.EMPTY_ARRAY;
        if (grClassInitializerArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(21);
        }
        return grClassInitializerArray;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = GrClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(22);
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = GrClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(23);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
        if (psiClassArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(24);
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases, true);
    }

    @Nullable
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(25);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findCodeMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findCodeMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(26);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(this, name, checkBases);
        if (psiMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(27);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findCodeMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findCodeMethodsByName(this, name, checkBases);
        if (psiMethodArray == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(28);
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = GrClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
        if (list == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = GrClassImplUtil.getAllMethodsAndTheirSubstitutors(this);
        if (list == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return GrClassImplUtil.findInnerClassByName(this, name, checkBases);
    }

    @Nullable
    public PsiElement getLBrace() {
        GrTypeDefinitionBody body = this.getBody();
        return body == null ? null : body.getLBrace();
    }

    @Nullable
    public PsiElement getRBrace() {
        GrTypeDefinitionBody body = this.getBody();
        return body == null ? null : body.getRBrace();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    @Nullable
    public PsiElement getScope() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        ASTNode treeElement = this.getNode();
        for (ASTNode parent2 = treeElement.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (!(parent2.getElementType() instanceof IStubElementType) || parent2.getElementType() == GroovyEmptyStubElementTypes.CLASS_BODY) continue;
            return parent2.getPsi();
        }
        return this.getContainingFile();
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(31);
        }
        if (this.isTrait() && baseClass.isInterface() && !checkDeep) {
            for (PsiClassType superType : this.getImplementsListTypes()) {
                if (!this.getManager().areElementsEquivalent((PsiElement)superType.resolve(), (PsiElement)baseClass)) continue;
                return true;
            }
        }
        return InheritanceImplUtil.isInheritor((PsiClass)this, (PsiClass)baseClass, (boolean)checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep((PsiClass)this, (PsiClass)baseClass, (PsiClass)classToByPass);
    }

    @Nullable
    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrTypeDefinitionBody && (pparent = parent2.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        return null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection collection = PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)this);
        if (collection == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(32);
        }
        return collection;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(33);
        }
        boolean renameFile = this.isRenameFileOnClassRenaming();
        String oldName = this.getName();
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        GrTypeDefinitionBody body = this.getBody();
        if (body != null) {
            for (GrMethod method : body.getMethods()) {
                if (!method.isConstructor() || !method.getName().equals(oldName)) continue;
                method.setName(name);
            }
        }
        if (renameFile) {
            PsiFile file = this.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            String ext = virtualFile != null ? virtualFile.getExtension() : GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension();
            file.setName(name + "." + ext);
        }
        return this;
    }

    @Override
    @Nullable
    public GrModifierList getModifierList() {
        return (GrModifierList)this.getStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        GrModifierList modifierList;
        if (name == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(34);
        }
        return (modifierList = this.getModifierList()) != null && modifierList.hasModifierProperty(name);
    }

    @Override
    @Nullable
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDoc() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Override
    @Nullable
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.TYPE_PARAMETER_LIST);
    }

    @NotNull
    public GrTypeParameter[] getTypeParameters() {
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            GrTypeParameter[] grTypeParameterArray = list.getTypeParameters();
            if (grTypeParameterArray == null) {
                GrTypeDefinitionImpl.$$$reportNull$$$0(35);
            }
            return grTypeParameterArray;
        }
        if (GrTypeParameter.EMPTY_ARRAY == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(36);
        }
        return GrTypeParameter.EMPTY_ARRAY;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getIconInner();
        boolean isLocked = (flags & 2) != 0 && !this.isWritable();
        RowIcon rowIcon = GrTypeDefinitionImpl.createLayeredIcon((Iconable)this, (Icon)icon, (int)(ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)isLocked) | this.getFlagsInner()));
        if ((flags & 1) != 0) {
            VisibilityIcons.setVisibilityIcon((PsiModifierList)this.getModifierList(), (RowIcon)rowIcon);
        }
        return rowIcon;
    }

    private int getFlagsInner() {
        return !DumbService.isDumb((Project)this.getProject()) && GroovyRunnerPsiUtil.isRunnable(this) ? 16384 : 0;
    }

    private Icon getIconInner() {
        if (this.isAnnotationType()) {
            return JetgroovyIcons.Groovy.AnnotationType;
        }
        if (this.isTrait()) {
            return JetgroovyIcons.Groovy.Trait;
        }
        if (this.isInterface()) {
            return JetgroovyIcons.Groovy.Interface;
        }
        if (this.isEnum()) {
            return JetgroovyIcons.Groovy.Enum;
        }
        if (this.hasModifierProperty("abstract")) {
            return JetgroovyIcons.Groovy.AbstractClass;
        }
        return JetgroovyIcons.Groovy.Class;
    }

    private boolean isRenameFileOnClassRenaming() {
        PsiFile file = this.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        if (groovyFile.isScript()) {
            return false;
        }
        String name = this.getName();
        VirtualFile vFile = groovyFile.getVirtualFile();
        return vFile != null && name != null && name.equals(vFile.getNameWithoutExtension());
    }

    @Nullable
    public PsiElement getOriginalElement() {
        return JavaPsiImplementationHelper.getInstance((Project)this.getProject()).getOriginalClass((PsiClass)this);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(37);
        }
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        if (anchor.getParent() == body) {
            PsiElement nextChild = anchor.getNextSibling();
            if (nextChild == null) {
                return this.add(element);
            }
            if (body == null) {
                throw new IncorrectOperationException("Class must have body");
            }
            return body.addBefore(element, nextChild);
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(38);
        }
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        if (anchor.getParent() != body) {
            return super.addBefore(element, anchor);
        }
        if (body == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        return body.addBefore(element, anchor);
    }

    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiElement anchor;
        GrTypeDefinitionBody body;
        if (psiElement == null) {
            GrTypeDefinitionImpl.$$$reportNull$$$0(39);
        }
        if ((body = this.getBody()) == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        PsiElement lBrace = body.getLBrace();
        if (lBrace == null) {
            throw new IncorrectOperationException("No left brace");
        }
        PsiMember member = GrTypeDefinitionImpl.getAnyMember(psiElement);
        PsiElement psiElement2 = anchor = member != null ? this.getDefaultAnchor(body, member) : null;
        if (anchor == null) {
            anchor = lBrace.getNextSibling();
        }
        if (anchor != null) {
            ASTNode node = anchor.getNode();
            assert (node != null);
            if (GroovyTokenTypes.mSEMI.equals(node.getElementType())) {
                anchor = anchor.getNextSibling();
            }
            if (psiElement instanceof GrField) {
                int i = ArrayUtilRt.find((Object[])((GrVariableDeclaration)psiElement.getParent()).getVariables(), (Object)psiElement);
                psiElement = body.addBefore(psiElement.getParent(), anchor);
                GrVariable[] vars = ((GrVariableDeclaration)psiElement).getVariables();
                for (int j = 0; j < vars.length; ++j) {
                    if (i == j) continue;
                    vars[i].delete();
                }
                psiElement = vars[i];
            } else {
                psiElement = body.addBefore(psiElement, anchor);
            }
        } else {
            psiElement = body.add(psiElement);
        }
        return psiElement;
    }

    @Nullable
    protected static PsiMember getAnyMember(@Nullable PsiElement psiElement) {
        GrMember[] members;
        if (psiElement instanceof PsiMember) {
            return (PsiMember)psiElement;
        }
        if (psiElement instanceof GrVariableDeclaration && (members = ((GrVariableDeclaration)psiElement).getMembers()).length > 0) {
            return members[0];
        }
        return null;
    }

    public static int getMemberOrderWeight(PsiElement member, GroovyCodeStyleSettingsFacade settings) {
        if (member instanceof PsiField) {
            if (member instanceof PsiEnumConstant) {
                return 1;
            }
            return ((PsiField)member).hasModifierProperty("static") ? settings.staticFieldsOrderWeight() + 1 : settings.fieldsOrderWeight() + 1;
        }
        if (member instanceof PsiMethod) {
            if (((PsiMethod)member).isConstructor()) {
                return settings.constructorsOrderWeight() + 1;
            }
            return ((PsiMethod)member).hasModifierProperty("static") ? settings.staticMethodsOrderWeight() + 1 : settings.methodsOrderWeight() + 1;
        }
        if (member instanceof PsiClass) {
            return ((PsiClass)member).hasModifierProperty("static") ? settings.staticInnerClassesOrderWeight() + 1 : settings.innerClassesOrderWeight() + 1;
        }
        return -1;
    }

    @Nullable
    protected PsiElement getDefaultAnchor(GrTypeDefinitionBody body, PsiMember member) {
        GroovyCodeStyleSettingsFacade settings = GroovyCodeStyleSettingsFacade.getInstance(this.getProject());
        int order = GrTypeDefinitionImpl.getMemberOrderWeight((PsiElement)member, settings);
        if (order < 0) {
            return null;
        }
        PsiElement lastMember = null;
        for (PsiElement child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
            int order1 = GrTypeDefinitionImpl.getMemberOrderWeight((PsiElement)GrTypeDefinitionImpl.getAnyMember(child), settings);
            if (order1 < 0) continue;
            if (order1 > order) {
                PsiElement lBrace = body.getLBrace();
                if (lastMember != null) {
                    PsiElement nextSibling = lastMember.getNextSibling();
                    while (nextSibling instanceof LeafPsiElement && (nextSibling.getText().equals(",") || nextSibling.getText().equals(";"))) {
                        nextSibling = nextSibling.getNextSibling();
                    }
                    return nextSibling == null && lBrace != null ? PsiUtil.skipWhitespacesAndComments(lBrace.getNextSibling(), true) : nextSibling;
                }
                if (lBrace != null) {
                    return PsiUtil.skipWhitespacesAndComments(lBrace.getNextSibling(), true);
                }
            }
            lastMember = child;
        }
        return body.getRBrace();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberDeclarations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifierGroovy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsListTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeMethods";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeConstructors";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInnerClasses";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySignature";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeMethodsBySignature";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeMethodsByName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodsAndTheirSubstitutors";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleSignatures";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

