/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;

public abstract class GrDocMemberReferenceImpl
extends GroovyDocPsiElementImpl
implements GrDocMemberReference {
    public GrDocMemberReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    public GrDocReferenceElement getReferenceHolder() {
        return (GrDocReferenceElement)this.findChildByClass(GrDocReferenceElement.class);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(1);
        }
        return this.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(2);
        }
        if (this.isReferenceTo(element)) {
            return this;
        }
        if (element instanceof PsiClass) {
            GrDocReferenceElement holder = this.getReferenceHolder();
            if (holder != null) {
                return this.replace(holder.getReferenceElement().bindToElement(element).getParent());
            }
            GrDocReferenceElement ref = GroovyPsiElementFactory.getInstance(this.getProject()).createDocReferenceElementFromFQN(((PsiClass)element).getQualifiedName());
            return this.replace(ref);
        }
        if (element instanceof PsiMember) {
            String memberRefText;
            PsiClass clazz = ((PsiMember)element).getContainingClass();
            if (clazz == null) {
                return null;
            }
            String qName = clazz.getQualifiedName();
            if (element instanceof PsiField) {
                memberRefText = ((PsiField)element).getName();
            } else if (element instanceof PsiMethod) {
                PsiParameterList list = ((PsiMethod)element).getParameterList();
                StringBuilder builder = new StringBuilder();
                builder.append(((PsiMethod)element).getName()).append("(");
                PsiParameter[] params = list.getParameters();
                for (int i = 0; i < params.length; ++i) {
                    PsiParameter parameter = params[i];
                    PsiType type2 = parameter.getType();
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(type2.getPresentableText());
                }
                builder.append(")");
                memberRefText = builder.toString();
            } else {
                return null;
            }
            GrDocMemberReference ref = GroovyPsiElementFactory.getInstance(this.getProject()).createDocMemberReferenceFromText(qName, memberRefText);
            return this.replace(ref);
        }
        return null;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(3);
        }
        GrDocTagValueToken nameElement = this.getReferenceNameElement();
        ASTNode node = nameElement.getNode();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createDocMemberReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null && node != null);
        node.getTreeParent().replaceChild(node, newNameNode);
        return this;
    }

    @Override
    @NotNull
    public GrDocTagValueToken getReferenceNameElement() {
        GrDocTagValueToken token = (GrDocTagValueToken)this.findChildByClass(GrDocTagValueToken.class);
        assert (token != null);
        GrDocTagValueToken grDocTagValueToken = token;
        if (grDocTagValueToken == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(4);
        }
        return grDocTagValueToken;
    }

    @NotNull
    public PsiElement getElement() {
        GrDocMemberReferenceImpl grDocMemberReferenceImpl = this;
        if (grDocMemberReferenceImpl == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(5);
        }
        return grDocMemberReferenceImpl;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        GrDocTagValueToken refNameElement = this.getReferenceNameElement();
        int offsetInParent = refNameElement.getStartOffsetInParent();
        TextRange textRange = new TextRange(offsetInParent, offsetInParent + refNameElement.getTextLength());
        if (textRange == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    public PsiElement getQualifier() {
        return this.getReferenceHolder();
    }

    @Nullable
    @NonNls
    public String getReferenceName() {
        return this.getReferenceNameElement().getText();
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = this.multiResolveImpl();
        if (resolveResultArray == null) {
            GrDocMemberReferenceImpl.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    protected abstract ResolveResult[] multiResolveImpl();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMemberReferenceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMemberReferenceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceNameElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

