/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.codeInsight.intention.impl.CreateSubclassAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;

public class GrCreateSubclassAction
extends CreateSubclassAction {
    private static final Logger LOG = Logger.getInstance(GrCreateSubclassAction.class);

    protected boolean isSupportedLanguage(PsiClass aClass) {
        return aClass.getLanguage() == GroovyLanguage.INSTANCE;
    }

    protected void createTopLevelClass(PsiClass psiClass) {
        CreateClassDialog dlg = GrCreateSubclassAction.chooseSubclassToCreate((PsiClass)psiClass);
        if (dlg != null) {
            GrCreateSubclassAction.createSubclassGroovy((GrTypeDefinition)psiClass, dlg.getTargetDirectory(), dlg.getClassName());
        }
    }

    @Nullable
    public static PsiClass createSubclassGroovy(GrTypeDefinition psiClass, PsiDirectory targetDirectory, String className) {
        Project project = psiClass.getProject();
        Ref targetClass = new Ref();
        WriteCommandAction.writeCommandAction((Project)project).withName(GrCreateSubclassAction.getTitle((PsiClass)psiClass)).withGroupId(GrCreateSubclassAction.getTitle((PsiClass)psiClass)).run(() -> {
            IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
            GrTypeParameterList oldTypeParameterList = psiClass.getTypeParameterList();
            try {
                targetClass.set((Object)CreateClassActionBase.createClassByType(targetDirectory, className, PsiManager.getInstance((Project)project), psiClass, "Groovy Class.groovy", true));
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)(CodeInsightBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{className}) + "\n" + e.getLocalizedMessage()), (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0])));
                return;
            }
            GrCreateSubclassAction.startTemplate(oldTypeParameterList, project, psiClass, (GrTypeDefinition)targetClass.get(), false);
        });
        if (targetClass.get() == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !psiClass.hasTypeParameters()) {
            Editor editor = CodeInsightUtil.positionCursorAtLBrace((Project)project, (PsiFile)((GrTypeDefinition)targetClass.get()).getContainingFile(), (PsiClass)((PsiClass)targetClass.get()));
            if (editor == null) {
                return (PsiClass)targetClass.get();
            }
            GrCreateSubclassAction.chooseAndImplement((PsiClass)psiClass, (Project)project, (PsiClass)((PsiClass)targetClass.get()), (Editor)editor);
        }
        return (PsiClass)targetClass.get();
    }

    private static void startTemplate(GrTypeParameterList oldTypeParameterList, final Project project, final GrTypeDefinition psiClass, GrTypeDefinition targetClass, boolean includeClassName) {
        PsiElementFactory jfactory = JavaPsiFacade.getElementFactory((Project)project);
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(project);
        GrCodeReferenceElement stubRef = elementFactory.createCodeReferenceElementFromClass(psiClass);
        try {
            GrReferenceList clause;
            GrReferenceList grReferenceList = clause = psiClass.isInterface() ? targetClass.getImplementsClause() : targetClass.getExtendsClause();
            if (clause == null) {
                GrReferenceList stubRefList = psiClass.isInterface() ? elementFactory.createImplementsClause() : elementFactory.createExtendsClause();
                clause = (GrExtendsClause)targetClass.addAfter(stubRefList, targetClass.getNameIdentifierGroovy());
            }
            GrCodeReferenceElement ref = (GrCodeReferenceElement)clause.add(stubRef);
            if (psiClass.hasTypeParameters() || includeClassName) {
                TemplateBuilderImpl templateBuilder;
                final Editor editor = CodeInsightUtil.positionCursorAtLBrace((Project)project, (PsiFile)targetClass.getContainingFile(), (PsiClass)targetClass);
                TemplateBuilderImpl templateBuilderImpl = templateBuilder = editor == null || ApplicationManager.getApplication().isUnitTestMode() ? null : (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)targetClass);
                if (includeClassName && templateBuilder != null) {
                    templateBuilder.replaceElement((PsiElement)targetClass.getNameIdentifier(), targetClass.getName());
                }
                if (oldTypeParameterList != null && oldTypeParameterList.getTypeParameters().length > 0) {
                    GrTypeArgumentList argList;
                    GrTypeArgumentList existingList = ref.getTypeArgumentList();
                    GrTypeParameterList typeParameterList = (GrTypeParameterList)targetClass.addAfter((PsiElement)elementFactory.createTypeParameterList(), targetClass.getNameIdentifierGroovy());
                    if (existingList == null) {
                        GrTypeParameter[] codeRef = elementFactory.createCodeReference("A<T>");
                        argList = (GrTypeArgumentList)ref.add(codeRef.getTypeArgumentList());
                        argList.getTypeArgumentElements()[0].delete();
                    } else {
                        argList = existingList;
                    }
                    for (GrTypeParameter parameter : oldTypeParameterList.getTypeParameters()) {
                        PsiElement param = argList.add(elementFactory.createTypeElement((PsiType)jfactory.createType((PsiClass)parameter)));
                        if (templateBuilder != null) {
                            templateBuilder.replaceElement(param, param.getText());
                        }
                        typeParameterList.add((PsiElement)elementFactory.createTypeParameter(parameter.getName(), parameter.getExtendsListTypes()));
                    }
                }
                if (templateBuilder != null) {
                    templateBuilder.setEndVariableBefore((PsiElement)ref);
                    Template template = templateBuilder.buildTemplate();
                    template.addEndVariable();
                    final PsiFile containingFile = targetClass.getContainingFile();
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    TextRange textRange = targetClass.getTextRange();
                    final RangeMarker startClassOffset = editor.getDocument().createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
                    startClassOffset.setGreedyToLeft(true);
                    startClassOffset.setGreedyToRight(true);
                    editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                    CreateFromUsageBaseFix.startTemplate((Editor)editor, (Template)template, (Project)project, (TemplateEditingListener)new TemplateEditingAdapter(){

                        public void templateFinished(@NotNull Template template, boolean brokenOff) {
                            if (template == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            GrCreateSubclassAction.chooseAndImplement((PsiClass)psiClass, (Project)project, (PsiClass)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingFile.findElementAt(startClassOffset.getStartOffset()), GrTypeDefinition.class)), (Editor)editor);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/groovy/intentions/declaration/GrCreateSubclassAction$1", "templateFinished"));
                        }
                    }, (String)GrCreateSubclassAction.getTitle((PsiClass)psiClass));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

