/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.MutablyNamedIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ConjunctionPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

public class DemorgansLawIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (GroovyTokenTypes.mLAND.equals(tokenType)) {
            return GroovyIntentionsBundle.message("demorgans.intention.name1", new Object[0]);
        }
        return GroovyIntentionsBundle.message("demorgans.intention.name2", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            DemorgansLawIntention.$$$reportNull$$$0(0);
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            DemorgansLawIntention.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DemorgansLawIntention.$$$reportNull$$$0(2);
        }
        GrBinaryExpression exp = (GrBinaryExpression)element;
        IElementType tokenType = exp.getOperationTokenType();
        PsiElement parent2 = exp.getParent();
        while (DemorgansLawIntention.isConjunctionExpression(parent2, tokenType)) {
            exp = (GrBinaryExpression)parent2;
            assert (exp != null);
            parent2 = exp.getParent();
        }
        String newExpression = DemorgansLawIntention.convertConjunctionExpression(exp, tokenType);
        DemorgansLawIntention.replaceExpressionWithNegatedExpressionString(newExpression, exp);
    }

    private static String convertConjunctionExpression(GrBinaryExpression exp, IElementType tokenType) {
        GrExpression lhs = exp.getLeftOperand();
        String lhsText = DemorgansLawIntention.isConjunctionExpression(lhs, tokenType) ? DemorgansLawIntention.convertConjunctionExpression((GrBinaryExpression)lhs, tokenType) : DemorgansLawIntention.convertLeafExpression(lhs);
        GrExpression rhs = exp.getRightOperand();
        String rhsText = DemorgansLawIntention.isConjunctionExpression(rhs, tokenType) ? DemorgansLawIntention.convertConjunctionExpression((GrBinaryExpression)rhs, tokenType) : DemorgansLawIntention.convertLeafExpression(rhs);
        String flippedConjunction = tokenType.equals(GroovyTokenTypes.mLAND) ? "||" : "&&";
        return lhsText + flippedConjunction + rhsText;
    }

    private static String convertLeafExpression(GrExpression condition) {
        if (BoolUtils.isNegation(condition)) {
            GrExpression negated = BoolUtils.getNegated(condition);
            if (ParenthesesUtils.getPrecedence(negated) > ParenthesesUtils.OR_PRECEDENCE) {
                return '(' + negated.getText() + ')';
            }
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationTokenType();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            GrExpression lhs = binaryExpression.getLeftOperand();
            GrExpression rhs = binaryExpression.getRightOperand();
            assert (rhs != null);
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(condition) > ParenthesesUtils.PREFIX_PRECEDENCE) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }

    private static boolean isConjunctionExpression(PsiElement exp, IElementType conjunctionType) {
        if (!(exp instanceof GrBinaryExpression)) {
            return false;
        }
        GrBinaryExpression binExp = (GrBinaryExpression)exp;
        IElementType tokenType = binExp.getOperationTokenType();
        return conjunctionType.equals(tokenType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/DemorgansLawIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/DemorgansLawIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

