/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"shouldBeErased", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.groovy.psi"})
public final class GroovyKeywordAnnotatorKt {
    public static final boolean shouldBeErased(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"element.node.elementType");
        IElementType tokenType = iElementType;
        if (!TokenSets.KEYWORDS.contains(tokenType)) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof GrArgumentLabel) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, GrCodeReferenceElement.class) != null) {
            if (TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS.contains(tokenType)) {
                return true;
            }
        } else {
            if (tokenType == GroovyTokenTypes.kDEF && element.getParent() instanceof GrAnnotationNameValuePair) {
                return true;
            }
            if (parent2 instanceof GrReferenceExpression && element == ((GrReferenceExpression)parent2).getReferenceNameElement()) {
                if (tokenType == GroovyTokenTypes.kSUPER && ((GrReferenceExpression)parent2).getQualifier() == null) {
                    return false;
                }
                return tokenType != GroovyTokenTypes.kTHIS || ((GrReferenceExpression)parent2).getQualifier() != null;
            }
        }
        return false;
    }
}

