/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.gant.GantSettings;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GantUtils {
    @NonNls
    public static final String GANT_JAR_FILE_PATTERN = "gant((_groovy)?|-)\\d.*\\.jar";

    private GantUtils() {
    }

    public static GrArgumentLabel[] getScriptTargets(GroovyFile file) {
        ArrayList<GrArgumentLabel> labels = new ArrayList<GrArgumentLabel>();
        for (PsiElement child : file.getChildren()) {
            GrArgumentLabel label;
            GrMethodCallExpression call;
            GrNamedArgument[] arguments2;
            if (!(child instanceof GrMethodCallExpression) || (arguments2 = (call = (GrMethodCallExpression)child).getNamedArguments()).length != 1 || (label = arguments2[0].getLabel()) == null || !GantUtils.isPlainIdentifier(label)) continue;
            labels.add(label);
        }
        return labels.toArray(GrArgumentLabel.EMPTY_ARRAY);
    }

    public static boolean isPlainIdentifier(GrArgumentLabel label) {
        PsiElement elem = label.getNameElement();
        ASTNode node = elem.getNode();
        if (node == null) {
            return false;
        }
        return node.getElementType() == GroovyTokenTypes.mIDENT;
    }

    public static String getGantVersion(String path) {
        String jarVersion = AbstractConfigUtils.getSDKJarVersion(path + "/lib", "gant-\\d.*\\.jar", "META-INF/MANIFEST.MF");
        return jarVersion != null ? jarVersion : "undefined";
    }

    public static boolean isGantSdkHome(VirtualFile file) {
        if (file != null && file.isDirectory()) {
            String path = file.getPath();
            if (GroovyUtils.getFilesInDirectoryByPattern(path + "/lib", GANT_JAR_FILE_PATTERN).length > 0) {
                return true;
            }
            if (GroovyUtils.getFilesInDirectoryByPattern(path + "/embeddable", GANT_JAR_FILE_PATTERN).length > 0) {
                return true;
            }
            if (file.findFileByRelativePath("bin/gant") != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return GantUtils.isGantLibrary(library.getFiles(OrderRootType.CLASSES));
    }

    public static boolean isGantLibrary(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!GantUtils.isGantJarFile(file.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGantJarFile(String name) {
        return name.matches(GANT_JAR_FILE_PATTERN);
    }

    public static String getSDKVersion(@NotNull Library library) {
        if (library == null) {
            GantUtils.$$$reportNull$$$0(0);
        }
        return GantUtils.getGantVersion(GantUtils.getGantLibraryHome(library));
    }

    public static String getGantLibraryHome(Library library) {
        return GantUtils.getGantLibraryHome(library.getFiles(OrderRootType.CLASSES));
    }

    public static String getGantLibraryHome(VirtualFile[] files) {
        for (VirtualFile file : files) {
            VirtualFile gantHome;
            VirtualFile parent2;
            if (!GantUtils.isGantJarFile(file.getName()) || (parent2 = LibrariesUtil.getLocalFile(file).getParent()) == null || (gantHome = parent2.getParent()) == null) continue;
            return PathUtil.getLocalPath((VirtualFile)gantHome);
        }
        return "";
    }

    @NotNull
    public static String getSDKInstallPath(@Nullable Module module, @NotNull Project project) {
        String fromClasspath;
        if (project == null) {
            GantUtils.$$$reportNull$$$0(1);
        }
        if (module != null && (fromClasspath = GantUtils.getSdkHomeFromClasspath(module)) != null) {
            String string = fromClasspath;
            if (string == null) {
                GantUtils.$$$reportNull$$$0(2);
            }
            return string;
        }
        VirtualFile sdkHome = GantSettings.getInstance(project).getSdkHome();
        String string = sdkHome != null ? sdkHome.getPath() : "";
        if (string == null) {
            GantUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static String getSdkHomeFromClasspath(@NotNull Module module) {
        String home;
        Library[] libraries;
        if (module == null) {
            GantUtils.$$$reportNull$$$0(4);
        }
        if ((libraries = LibrariesUtil.getLibrariesByCondition(module, (Condition<? super Library>)((Condition)library1 -> GantUtils.isSDKLibrary(library1)))).length != 0 && StringUtil.isNotEmpty((String)(home = GantUtils.getGantLibraryHome(libraries[0])))) {
            return home;
        }
        return null;
    }

    public static boolean isSDKConfiguredToRun(@NotNull Module module) {
        if (module == null) {
            GantUtils.$$$reportNull$$$0(5);
        }
        return !GantUtils.getSDKInstallPath(module, module.getProject()).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/gant/GantUtils";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/gant/GantUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSDKInstallPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSDKVersion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSDKInstallPath";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHomeFromClasspath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSDKConfiguredToRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

