/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.lang.ant.ReflectedProject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.gant.AntBuilderMethod;
import org.jetbrains.plugins.groovy.gant.GantScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class AntTasksProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.gant.AntTasksProvider");
    private static final Key<CachedValue<Set<LightMethodBuilder>>> GANT_METHODS = Key.create((String)"gantMethods");
    private static final Object ourLock = new Object();
    public static final ParameterizedCachedValueProvider<Map<List<URL>, AntClassLoader>, Project> PROVIDER = project -> {
        Map map2 = ContainerUtil.createSoftValueMap();
        return CachedValueProvider.Result.create((Object)map2, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
    };
    public static final Key<ParameterizedCachedValue<Map<List<URL>, AntClassLoader>, Project>> KEY = Key.create((String)"ANtClassLoader");

    private AntTasksProvider() {
    }

    public static Set<LightMethodBuilder> getAntTasks(PsiElement place) {
        PsiFile file = place.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, GANT_METHODS, () -> {
            Map<String, Class> antObjects = AntTasksProvider.getAntObjects((GroovyFile)file);
            HashSet<AntBuilderMethod> methods = new HashSet<AntBuilderMethod>();
            Project project = file.getProject();
            PsiClassType closureType = TypesUtil.createType("groovy.lang.Closure", (PsiElement)file);
            PsiClassType stringType = TypesUtil.createType("java.lang.String", (PsiElement)file);
            for (String name : antObjects.keySet()) {
                methods.add(new AntBuilderMethod(file, name, (PsiType)closureType, antObjects.get(name), (PsiType)stringType));
            }
            return CachedValueProvider.Result.create(methods, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Class> getAntObjects(GroovyFile groovyFile) {
        AntClassLoader loader;
        Project project = groovyFile.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)groovyFile);
        HashSet<VirtualFile> jars = new HashSet<VirtualFile>();
        if (module != null) {
            ContainerUtil.addAll(jars, (Object[])OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots());
        }
        if (groovyFile.isScript() && GroovyScriptUtil.getScriptType(groovyFile) instanceof GantScriptType) {
            jars.addAll(GantScriptType.additionalScopeFiles(groovyFile));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (VirtualFile jar : jars) {
            VirtualFile localFile = VfsUtil.getLocalFile((VirtualFile)jar);
            if (!localFile.isInLocalFileSystem()) continue;
            urls.add(VfsUtilCore.convertToURL((String)localFile.getUrl()));
        }
        Object object = ourLock;
        synchronized (object) {
            Map map2 = (Map)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, KEY, PROVIDER, false, (Object)project);
            loader = (AntClassLoader)((Object)map2.get(urls));
            if (loader == null) {
                loader = new AntClassLoader(urls);
                map2.put(urls, loader);
            }
        }
        return loader.getAntObjects();
    }

    private static class AntClassLoader
    extends UrlClassLoader {
        private final Future<Map<String, Class>> myFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                ReflectedProject antProject = ReflectedProject.getProject((ClassLoader)((Object)this));
                HashMap result2 = new HashMap();
                if (antProject != null) {
                    Hashtable dataTypeDefinitions;
                    Hashtable taskDefinitions = antProject.getTaskDefinitions();
                    if (taskDefinitions != null) {
                        result2.putAll(taskDefinitions);
                    }
                    if ((dataTypeDefinitions = antProject.getDataTypeDefinitions()) != null) {
                        result2.putAll(dataTypeDefinitions);
                    }
                }
                return result2;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        });

        AntClassLoader(ArrayList<URL> urls) {
            super(AntClassLoader.getBuilder(urls));
        }

        private static UrlClassLoader.Builder getBuilder(ArrayList<URL> urls) {
            UrlClassLoader.Builder builder = AntClassLoader.build().urls(urls).allowUnescaped().noPreload();
            ClassLoaderUtil.addPlatformLoaderParentIfOnJdk9((UrlClassLoader.Builder)builder);
            return builder;
        }

        @NotNull
        public Map<String, Class> getAntObjects() {
            while (true) {
                block6: {
                    Map<String, Class> map2;
                    try {
                        Map<String, Class> map3 = this.myFuture.get(100L, TimeUnit.MILLISECONDS);
                        if (map3 == null) break block6;
                        map2 = map3;
                    }
                    catch (TimeoutException map3) {
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                        break;
                    }
                    if (map2 == null) {
                        AntClassLoader.$$$reportNull$$$0(0);
                    }
                    return map2;
                }
                ProgressManager.checkCanceled();
            }
            Map<String, Class> map4 = Collections.emptyMap();
            if (map4 == null) {
                AntClassLoader.$$$reportNull$$$0(1);
            }
            return map4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/AntTasksProvider$AntClassLoader", "getAntObjects"));
        }
    }
}

