/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.ext.spock.DataVariablesKt;
import org.jetbrains.plugins.groovy.ext.spock.SpockConstants;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class SpockUtils {
    public static final String SPEC_CLASS_NAME = "spock.lang.Specification";
    private static final LightCacheKey<Map<String, SpockVariableDescriptor>> KEY = LightCacheKey.create();

    private SpockUtils() {
    }

    public static Map<String, SpockVariableDescriptor> getVariableMap(@NotNull GrMethod method) {
        Map<String, SpockVariableDescriptor> cachedValue;
        GrMethod originalMethod;
        PsiFile containingFile;
        if (method == null) {
            SpockUtils.$$$reportNull$$$0(0);
        }
        if ((containingFile = method.getContainingFile()) != containingFile.getOriginalFile()) {
            int methodOffset = method.getTextOffset();
            PsiElement originalPlace = containingFile.getOriginalFile().findElementAt(methodOffset);
            originalMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)originalPlace, GrMethod.class);
            assert (originalMethod != null) : containingFile.getOriginalFile().getText().substring(Math.max(0, methodOffset - 50), Math.min(methodOffset + 50, containingFile.getOriginalFile().getText().length()));
        } else {
            originalMethod = method;
        }
        if ((cachedValue = KEY.getCachedValue(originalMethod)) == null) {
            cachedValue = DataVariablesKt.createVariableMap(originalMethod);
            cachedValue = KEY.putCachedValue(originalMethod, cachedValue);
        }
        return cachedValue;
    }

    @Nullable
    public static String getNameByReference(@Nullable PsiElement expression) {
        if (!(expression instanceof GrReferenceExpression)) {
            return null;
        }
        PsiElement firstChild = expression.getFirstChild();
        if (firstChild != expression.getLastChild() || !PsiImplUtil.isLeafElementOfType((PsiElement)firstChild, (IElementType)GroovyTokenTypes.mIDENT)) {
            return null;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        if (ref.isQualified()) {
            return null;
        }
        return ref.getReferenceName();
    }

    public static boolean isTestMethod(PsiElement element) {
        if (!(element instanceof GrMethod)) {
            return false;
        }
        GrMethod method = (GrMethod)element;
        PsiClass clazz = method.getContainingClass();
        if (!SpockUtils.isSpecification(clazz)) {
            return false;
        }
        if (SpockUtils.isFixtureMethod(method)) {
            return false;
        }
        return SpockUtils.isFeatureMethod(method);
    }

    public static boolean isSpecification(@Nullable PsiClass clazz) {
        return clazz instanceof GrTypeDefinition && InheritanceUtil.isInheritor((PsiClass)clazz, (String)SPEC_CLASS_NAME);
    }

    public static boolean isFixtureMethod(@NotNull GrMethod method) {
        if (method == null) {
            SpockUtils.$$$reportNull$$$0(1);
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        return SpockConstants.FIXTURE_METHOD_NAMES.contains(method.getName());
    }

    public static boolean isFeatureMethod(@NotNull GrMethod method) {
        if (method == null) {
            SpockUtils.$$$reportNull$$$0(2);
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return false;
        }
        for (GrStatement statement : block.getStatements()) {
            String label;
            if (!(statement instanceof GrLabeledStatement) || !SpockConstants.FEATURE_METHOD_LABELS.contains(label = ((GrLabeledStatement)statement).getName())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "method";
        objectArray2[1] = "org/jetbrains/plugins/groovy/ext/spock/SpockUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariableMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFixtureMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFeatureMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

